/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ContentWriter;
import org.apache.kylin.common.persistence.HDFSResourceStore;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PushdownResourceStore
extends ResourceStore {
    private static final Logger logger = LoggerFactory.getLogger(HDFSResourceStore.class);

    protected PushdownResourceStore(KylinConfig kylinConfig) {
        super(kylinConfig);
    }

    @Override
    protected final void putResourceImpl(String resPath, ContentWriter content, long ts) throws IOException {
        if (content.isBigContent()) {
            this.putBigResource(resPath, content, ts);
        } else {
            this.putSmallResource(resPath, content, ts);
        }
    }

    protected abstract void putSmallResource(String var1, ContentWriter var2, long var3) throws IOException;

    final void putBigResource(String resPath, ContentWriter content, long newTS) throws IOException {
        try (RollbackablePushdown pushdown = this.writePushdown(resPath, content);){
            logger.debug("Writing marker for big resource {}", (Object)resPath);
            this.putResourceWithRetry(resPath, ContentWriter.create(BytesUtil.EMPTY_BYTE_ARRAY), newTS);
        }
    }

    protected RollbackablePushdown writePushdown(String resPath, ContentWriter content) throws IOException {
        return new RollbackablePushdown(resPath, content);
    }

    protected InputStream openPushdown(String resPath) throws IOException {
        try {
            Path p = this.pushdownPath(resPath);
            FileSystem fs = this.pushdownFS();
            if (fs.exists(p)) {
                return fs.open(p);
            }
            throw new FileNotFoundException(p.toString() + "  (FS: " + fs + ")");
        }
        catch (Exception ex) {
            throw new IOException("Failed to read big resource " + resPath, ex);
        }
    }

    protected abstract String pushdownRootPath();

    protected FileSystem pushdownFS() {
        return HadoopUtil.getFileSystem(new Path(this.kylinConfig.getMetastoreBigCellHdfsDirectory()));
    }

    protected final Path pushdownPath(String resPath) {
        Path p = new Path(this.pushdownRootPath() + resPath);
        return Path.getPathWithoutSchemeAndAuthority((Path)p);
    }

    protected void deletePushdown(String resPath) throws IOException {
        this.deletePushdownFile(this.pushdownPath(resPath));
    }

    private void deletePushdownFile(Path path) throws IOException {
        FileSystem fileSystem = this.pushdownFS();
        if (fileSystem.exists(path)) {
            fileSystem.delete(path, true);
            logger.debug("Delete temp file success. Temp file: {} .", (Object)path);
        } else {
            logger.debug("{} is not exists in the file system.", (Object)path);
        }
    }

    public class RollbackablePushdown
    implements AutoCloseable {
        FileSystem fs;
        Path tempPath;
        Path realPath;
        Path backPath;
        boolean hasOldFile;
        boolean hasRollback = false;

        private RollbackablePushdown(String resPath, ContentWriter content) throws IOException {
            int salt = System.identityHashCode(resPath) + System.identityHashCode(content);
            this.tempPath = PushdownResourceStore.this.pushdownPath(resPath + ".temp." + salt);
            this.realPath = PushdownResourceStore.this.pushdownPath(resPath);
            this.backPath = PushdownResourceStore.this.pushdownPath(resPath + ".orig." + salt);
            this.fs = PushdownResourceStore.this.pushdownFS();
            if (this.fs.exists(this.tempPath)) {
                this.fs.delete(this.tempPath, true);
            }
            logger.debug("Writing pushdown file {}", (Object)this.tempPath);
            try (FSDataOutputStream out = this.fs.create(this.tempPath, true);){
                content.write((DataOutputStream)out);
            }
            catch (IOException ex) {
                this.close();
                throw ex;
            }
            try {
                this.hasOldFile = this.fs.exists(this.realPath);
                if (this.hasOldFile) {
                    logger.debug("Backup {} to {}", (Object)this.realPath, (Object)this.backPath);
                    this.fs.rename(this.realPath, this.backPath);
                }
            }
            catch (IOException ex) {
                this.close();
                throw ex;
            }
            logger.debug("Move {} to {}", (Object)this.tempPath, (Object)this.realPath);
            try {
                this.fs.rename(this.tempPath, this.realPath);
            }
            catch (IOException ex) {
                this.rollback();
                this.close();
                throw ex;
            }
        }

        public void rollback() {
            if (this.hasRollback) {
                return;
            }
            this.hasRollback = true;
            try {
                logger.error("Rollback {} from {}", (Object)this.realPath, (Object)(this.hasOldFile ? this.backPath.toString() : "<empty>"));
                if (this.fs.exists(this.realPath)) {
                    this.fs.delete(this.realPath, true);
                }
                if (this.hasOldFile) {
                    this.fs.rename(this.backPath, this.realPath);
                }
            }
            catch (IOException ex2) {
                logger.error("Rollback failed", (Throwable)ex2);
            }
        }

        @Override
        public void close() {
            try {
                if (this.fs.exists(this.tempPath)) {
                    this.fs.delete(this.tempPath, true);
                }
            }
            catch (IOException e) {
                logger.error("Error cleaning up " + this.tempPath, (Throwable)e);
            }
            try {
                if (this.fs.exists(this.backPath)) {
                    this.fs.delete(this.backPath, true);
                }
            }
            catch (IOException e) {
                logger.error("Error cleaning up " + this.backPath, (Throwable)e);
            }
        }
    }
}

