/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;

public class ShardingHash {
    static HashFunction hashFunc = Hashing.murmur3_128();

    public static short getShard(int integerValue, int totalShards) {
        if (totalShards <= 1) {
            return 0;
        }
        long hash = hashFunc.hashInt(integerValue).asLong();
        return ShardingHash._getShard(hash, totalShards);
    }

    public static short getShard(long longValue, int totalShards) {
        if (totalShards <= 1) {
            return 0;
        }
        long hash = hashFunc.hashLong(longValue).asLong();
        return ShardingHash._getShard(hash, totalShards);
    }

    public static short getShard(byte[] byteValues, int offset, int length, int totalShards) {
        if (totalShards <= 1) {
            return 0;
        }
        long hash = hashFunc.hashBytes(byteValues, offset, length).asLong();
        return ShardingHash._getShard(hash, totalShards);
    }

    public static short normalize(short cuboidShardBase, short shardOffset, int totalShards) {
        if (totalShards <= 1) {
            return 0;
        }
        return (short)((cuboidShardBase + shardOffset) % totalShards);
    }

    private static short _getShard(long hash, int totalShard) {
        long x = hash % (long)totalShard;
        if (x < 0L) {
            x += (long)totalShard;
        }
        return (short)x;
    }
}

