/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    private static TimeZone gmt = TimeZone.getTimeZone("GMT");
    public static long ONE_MINUTE_TS = 60000L;
    public static long ONE_HOUR_TS = 60L * ONE_MINUTE_TS;
    public static long ONE_DAY_TS = 24L * ONE_HOUR_TS;

    private TimeUtil() {
        throw new IllegalStateException("Class TimeUtil is an utility class !");
    }

    public static long getMinuteStart(long ts) {
        return ts / ONE_MINUTE_TS * ONE_MINUTE_TS;
    }

    public static long getHourStart(long ts) {
        return ts / ONE_HOUR_TS * ONE_HOUR_TS;
    }

    public static long getDayStart(long ts) {
        return ts / ONE_DAY_TS * ONE_DAY_TS;
    }

    public static long getWeekStart(long ts) {
        Calendar calendar = Calendar.getInstance(gmt, Locale.ROOT);
        calendar.setTimeInMillis(TimeUtil.getDayStart(ts));
        calendar.add(7, calendar.getFirstDayOfWeek() - calendar.get(7));
        return calendar.getTimeInMillis();
    }

    public static long getMonthStart(long ts) {
        Calendar calendar = Calendar.getInstance(gmt, Locale.ROOT);
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.clear();
        calendar.set(year, month, 1);
        return calendar.getTimeInMillis();
    }

    public static long getQuarterStart(long ts) {
        Calendar calendar = Calendar.getInstance(gmt, Locale.ROOT);
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.clear();
        calendar.set(year, month / 3 * 3, 1);
        return calendar.getTimeInMillis();
    }

    public static long getYearStart(long ts) {
        Calendar calendar = Calendar.getInstance(gmt, Locale.ROOT);
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(year, 0, 1);
        return calendar.getTimeInMillis();
    }

    public static long getWeekEnd(long ts) {
        Calendar calendar = Calendar.getInstance(gmt, Locale.ROOT);
        calendar.setTimeInMillis(TimeUtil.getWeekStart(ts));
        calendar.add(7, 7);
        return calendar.getTimeInMillis();
    }

    public static long getMonthEnd(long ts) {
        Calendar calendar = Calendar.getInstance(gmt, Locale.ROOT);
        calendar.setTimeInMillis(ts);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 24);
        return calendar.getTimeInMillis();
    }

    public static long getQuarterEnd(long ts) {
        Calendar calendar = Calendar.getInstance(gmt, Locale.ROOT);
        calendar.setTimeInMillis(TimeUtil.getQuarterStart(ts));
        calendar.add(2, 3);
        return calendar.getTimeInMillis();
    }

    public static long getYearEnd(long ts) {
        Calendar calendar = Calendar.getInstance(gmt, Locale.ROOT);
        calendar.setTimeInMillis(TimeUtil.getYearStart(ts));
        calendar.add(1, 1);
        return calendar.getTimeInMillis();
    }
}

