/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import org.apache.kylin.common.KylinConfig;

public final class ServerMode
extends Enum<ServerMode> {
    public static final /* enum */ ServerMode ALL = new ServerMode("all");
    public static final /* enum */ ServerMode JOB = new ServerMode("job");
    public static final /* enum */ ServerMode QUERY = new ServerMode("query");
    private final String name;
    private static final /* synthetic */ ServerMode[] $VALUES;

    public static ServerMode[] values() {
        return (ServerMode[])$VALUES.clone();
    }

    public static ServerMode valueOf(String name) {
        return Enum.valueOf(ServerMode.class, name);
    }

    private ServerMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private static void validate(KylinConfig config) {
        assert (config != null);
    }

    private static boolean match(ServerMode serverMode, KylinConfig config) {
        ServerMode.validate(config);
        return serverMode.getName().equals(config.getServerMode());
    }

    public static boolean isJob(KylinConfig config) {
        return ServerMode.isJobOnly(config) || ServerMode.isAll(config);
    }

    public static boolean isJob(String serverMode) {
        return ServerMode.ALL.name.equals(serverMode) || ServerMode.JOB.name.equals(serverMode);
    }

    public static boolean isJobOnly(KylinConfig config) {
        return ServerMode.match(JOB, config);
    }

    public static boolean isQueryOnly(KylinConfig config) {
        return ServerMode.match(QUERY, config);
    }

    public static boolean isQuery(KylinConfig config) {
        return ServerMode.isQueryOnly(config) || ServerMode.isAll(config);
    }

    public static boolean isAll(KylinConfig config) {
        return ServerMode.match(ALL, config);
    }

    public static boolean isQuery(String serverMode) {
        return ServerMode.ALL.name.equals(serverMode) || ServerMode.QUERY.name.equals(serverMode);
    }

    static {
        $VALUES = new ServerMode[]{ALL, JOB, QUERY};
    }
}

