/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.livy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.kylin.common.KylinConfig;

public class LivyRestClient {
    private int httpConnectionTimeoutMs = 30000;
    private int httpSocketTimeoutMs = 120000;
    protected String baseUrl;
    protected DefaultHttpClient client;
    private final KylinConfig config = KylinConfig.getInstanceFromEnv();

    public LivyRestClient() {
        this.init();
    }

    private void init() {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.httpSocketTimeoutMs);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.httpConnectionTimeoutMs);
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
        cm.setDefaultMaxPerRoute(this.config.getRestClientDefaultMaxPerRoute());
        cm.setMaxTotal(this.config.getRestClientMaxTotal());
        this.baseUrl = this.config.getLivyUrl();
        this.client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
    }

    public String livySubmitJobBatches(String jobJson) throws IOException {
        String url = this.baseUrl + "/batches";
        HttpPost post = this.newPost(url);
        post.setEntity((HttpEntity)new StringEntity(jobJson, "UTF-8"));
        HttpResponse response = this.client.execute((HttpUriRequest)post);
        String content = this.getContent(response);
        if (response.getStatusLine().getStatusCode() != 201) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n");
        }
        return content;
    }

    public String livyGetJobStatusBatches(String jobId) throws IOException {
        String url = this.baseUrl + "/batches/" + jobId;
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.client.execute((HttpUriRequest)get);
        String content = this.getContent(response);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n");
        }
        return content;
    }

    public String livyDeleteBatches(String jobId) throws IOException {
        String url = this.baseUrl + "/batches/" + jobId;
        HttpDelete delete = new HttpDelete(url);
        HttpResponse response = this.client.execute((HttpUriRequest)delete);
        String content = this.getContent(response);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n");
        }
        return content;
    }

    private HttpPost newPost(String url) {
        HttpPost post = new HttpPost(url);
        this.addHttpHeaders((HttpRequestBase)post);
        return post;
    }

    private void addHttpHeaders(HttpRequestBase method) {
        method.addHeader("Accept", "application/json, text/plain, */*");
        method.addHeader("Content-Type", "application/json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(HttpResponse response) throws IOException {
        InputStreamReader reader = null;
        BufferedReader rd = null;
        StringBuffer result = new StringBuffer();
        try {
            String line;
            reader = new InputStreamReader(response.getEntity().getContent(), "UTF-8");
            rd = new BufferedReader(reader);
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(rd);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Reader)rd);
        return result.toString();
    }
}

