/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.kylin.common.util.Logger;

public class BufferedLogger
implements Logger {
    private final org.slf4j.Logger wrappedLogger;
    private final StringBuilder buffer = new StringBuilder();
    private static int MAX_BUFFER_SIZE = 0xA00000;

    public BufferedLogger(org.slf4j.Logger wrappedLogger) {
        this.wrappedLogger = wrappedLogger;
    }

    @Override
    public void log(String message) {
        this.wrappedLogger.info(message);
        if (this.buffer.length() < MAX_BUFFER_SIZE) {
            this.buffer.append(message).append("\n");
        }
    }

    public String getBufferedLog() {
        return this.buffer.toString();
    }

    public void resetBuffer() {
        this.buffer.setLength(0);
    }
}

