/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateFormat {
    public static final String COMPACT_DATE_PATTERN = "yyyyMMdd";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    public static final String DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HH = "yyyy-MM-dd HH";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String YYYYMMDDHH = "yyyyMMddHH";
    public static final String[] SUPPORTED_DATETIME_PATTERN = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyyMMdd"};
    private static final Map<String, FastDateFormat> formatMap = new ConcurrentHashMap<String, FastDateFormat>();

    public static FastDateFormat getDateFormat(String datePattern) {
        FastDateFormat r = formatMap.get(datePattern);
        if (r == null) {
            r = FastDateFormat.getInstance((String)datePattern, (TimeZone)TimeZone.getTimeZone("GMT"));
            formatMap.put(datePattern, r);
        }
        return r;
    }

    public static String formatToCompactDateStr(long millis) {
        return DateFormat.formatToDateStr(millis, COMPACT_DATE_PATTERN);
    }

    public static String formatToDateStr(long millis) {
        return DateFormat.formatToDateStr(millis, DEFAULT_DATE_PATTERN);
    }

    public static String formatToDateStr(long millis, String pattern) {
        return DateFormat.getDateFormat(pattern).format(new Date(millis));
    }

    public static String formatToTimeStr(long millis) {
        return DateFormat.formatToTimeStr(millis, DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS);
    }

    public static String formatToTimeWithoutMilliStr(long millis) {
        return DateFormat.formatToTimeStr(millis, DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS);
    }

    public static String formatToTimeStr(long millis, String pattern) {
        return DateFormat.getDateFormat(pattern).format(new Date(millis));
    }

    public static String dateToString(Date date, String pattern) {
        return DateFormat.getDateFormat(pattern).format(date);
    }

    public static Date stringToDate(String str) {
        return DateFormat.stringToDate(str, DEFAULT_DATE_PATTERN);
    }

    public static Date stringToDate(String str, String pattern) {
        Date date = null;
        try {
            date = DateFormat.getDateFormat(pattern).parse(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("'" + str + "' is not a valid date of pattern '" + pattern + "'", e);
        }
        return date;
    }

    public static long stringToMillis(String str) {
        if (DateFormat.isAllDigits(str)) {
            if (str.length() == 8 && DateFormat.isInputFormatDate(str, COMPACT_DATE_PATTERN)) {
                return DateFormat.stringToDate(str, COMPACT_DATE_PATTERN).getTime();
            }
            if (str.length() == 10 && DateFormat.isInputFormatDate(str, YYYYMMDDHH)) {
                return DateFormat.stringToDate(str, YYYYMMDDHH).getTime();
            }
            if (str.length() == 12 && DateFormat.isInputFormatDate(str, YYYYMMDDHHMM)) {
                return DateFormat.stringToDate(str, YYYYMMDDHHMM).getTime();
            }
            if (str.length() == 14 && DateFormat.isInputFormatDate(str, YYYYMMDDHHMMSS)) {
                return DateFormat.stringToDate(str, YYYYMMDDHHMMSS).getTime();
            }
            return Long.parseLong(str);
        }
        if (str.length() == 10) {
            return DateFormat.stringToDate(str, DEFAULT_DATE_PATTERN).getTime();
        }
        if (str.length() == 13) {
            return DateFormat.stringToDate(str, YYYY_MM_DD_HH).getTime();
        }
        if (str.length() == 16) {
            return DateFormat.stringToDate(str, YYYY_MM_DD_HH_MM).getTime();
        }
        if (str.length() == 19) {
            return DateFormat.stringToDate(str, DEFAULT_DATETIME_PATTERN_WITHOUT_MILLISECONDS).getTime();
        }
        if (str.length() > 19) {
            return DateFormat.stringToDate(str, DEFAULT_DATETIME_PATTERN_WITH_MILLISECONDS).getTime();
        }
        throw new IllegalArgumentException("there is no valid date pattern for:" + str);
    }

    private static boolean isAllDigits(String str) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(str.charAt(i)) || i == 0 && str.charAt(0) == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isSupportedDateFormat(String dateStr) {
        assert (dateStr != null);
        for (String formatStr : SUPPORTED_DATETIME_PATTERN) {
            try {
                if (!dateStr.equals(DateFormat.dateToString(DateFormat.stringToDate(dateStr, formatStr), formatStr))) continue;
                return true;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isInputFormatDate(String dateStr, String formatStr) {
        try {
            return dateStr.equals(DateFormat.dateToString(DateFormat.stringToDate(dateStr, formatStr), formatStr));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isDatePattern(String ptn) {
        return COMPACT_DATE_PATTERN.equals(ptn) || YYYYMMDDHH.equals(ptn) || YYYYMMDDHHMM.equals(ptn) || YYYYMMDDHHMMSS.equals(ptn);
    }
}

