/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.KylinConfig;

public class ServerMode {
    public static final String SERVER_MODE_QUERY = "query";
    public static final String SERVER_MODE_JOB = "job";
    public static final String SERVER_MODE_STREAM_COORDINATOR = "stream_coordinator";
    public static final String SERVER_MODE_ALL = "all";
    private List<String> serverModes;
    public static ServerMode SERVER_MODE = ServerMode.getServerMode();

    public ServerMode(List<String> serverModes) {
        this.serverModes = serverModes;
    }

    public boolean canServeQuery() {
        return this.serverModes.contains(SERVER_MODE_ALL) || this.serverModes.contains(SERVER_MODE_QUERY);
    }

    public boolean canServeJobBuild() {
        return this.serverModes.contains(SERVER_MODE_ALL) || this.serverModes.contains(SERVER_MODE_JOB);
    }

    public boolean canServeStreamingCoordinator() {
        return this.serverModes.contains(SERVER_MODE_ALL) || this.serverModes.contains(SERVER_MODE_STREAM_COORDINATOR);
    }

    public boolean canServeAll() {
        return this.serverModes.contains(SERVER_MODE_ALL);
    }

    public String toString() {
        return this.serverModes.toString();
    }

    private static ServerMode getServerMode() {
        String[] serverModeArray;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String serverModeStr = kylinConfig.getServerMode();
        ArrayList serverModes = Lists.newArrayList();
        for (String serverMode : serverModeArray = serverModeStr.split("\\s*,\\s*")) {
            serverModes.add(serverMode.toLowerCase(Locale.ROOT));
        }
        return new ServerMode(serverModes);
    }
}

