/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.utils;

import java.text.NumberFormat;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.SparkStatusTracker;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class JobProgressUtil$
implements Logging {
    public static final JobProgressUtil$ MODULE$;
    private NumberFormat _percentFormat;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new JobProgressUtil$();
    }

    private Logger logger$lzycompute() {
        JobProgressUtil$ jobProgressUtil$ = this;
        synchronized (jobProgressUtil$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    public float progress(SparkContext sc, String jobGroup) {
        int[] jobIds = sc.statusTracker().getJobIdsForGroup(jobGroup);
        SparkJobInfo[] jobs = (SparkJobInfo[])Predef$.MODULE$.intArrayOps(jobIds).flatMap((Function1)new Serializable(sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$1;

            public final Iterable<SparkJobInfo> apply(int id) {
                return Option$.MODULE$.option2Iterable(this.sc$1.statusTracker().getJobInfo(id));
            }
            {
                this.sc$1 = sc$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkJobInfo.class)));
        SparkStageInfo[] stages = (SparkStageInfo[])Predef$.MODULE$.refArrayOps((Object[])jobs).flatMap((Function1)new Serializable(sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$1;

            public final ArrayOps<SparkStageInfo> apply(SparkJobInfo job) {
                SparkStatusTracker sparkStatusTracker = this.sc$1.statusTracker();
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(job.stageIds()).flatMap((Function1)new Serializable(this, sparkStatusTracker){
                    public static final long serialVersionUID = 0L;
                    private final SparkStatusTracker eta$0$1$1;

                    public final Iterable<SparkStageInfo> apply(int stageId) {
                        return Option$.MODULE$.option2Iterable(this.eta$0$1$1.getStageInfo(stageId));
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkStageInfo.class))));
            }
            {
                this.sc$1 = sc$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkStageInfo.class)));
        int taskCount = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])stages).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(SparkStageInfo x$1) {
                return x$1.numTasks();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int completedTaskCount = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])stages).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(SparkStageInfo x$2) {
                return x$2.numCompletedTasks();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return taskCount == 0 ? 0.0f : (float)((double)completedTaskCount / (double)taskCount);
    }

    public JobProgressInfo[] getActiveJobProgressInfo(SparkContext sc, String jobGroup) {
        int[] jobIds = sc.statusTracker().getJobIdsForGroup(jobGroup);
        SparkJobInfo[] activeJobs = (SparkJobInfo[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(jobIds).flatMap((Function1)new Serializable(sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$2;

            public final Iterable<SparkJobInfo> apply(int id) {
                return Option$.MODULE$.option2Iterable(this.sc$2.statusTracker().getJobInfo(id));
            }
            {
                this.sc$2 = sc$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkJobInfo.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SparkJobInfo x$3) {
                JobExecutionStatus jobExecutionStatus = x$3.status();
                JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.RUNNING;
                return !(jobExecutionStatus != null ? !jobExecutionStatus.equals(jobExecutionStatus2) : jobExecutionStatus2 != null);
            }
        });
        JobProgressInfo[] progressInfos = (JobProgressInfo[])Predef$.MODULE$.refArrayOps((Object[])activeJobs).map((Function1)new Serializable(sc, jobGroup){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$2;
            private final String jobGroup$1;

            /*
             * WARNING - void declaration
             */
            public final JobProgressInfo apply(SparkJobInfo job) {
                void var2_2;
                JobProgressInfo jobProgressInfo = JobProgressUtil$.MODULE$.org$apache$linkis$engineplugin$spark$utils$JobProgressUtil$$getJobProgressInfoByStages(job, this.sc$2, this.jobGroup$1);
                String timestamp = DateFormatUtils.format((long)System.currentTimeMillis(), (String)"yyyy-MM-dd HH:mm:ss");
                double progress = (double)jobProgressInfo.succeedTasks() * 1.0 / (double)jobProgressInfo.totalTasks();
                JobProgressUtil$.MODULE$.info((Function0<String>)new Serializable(this, jobProgressInfo, progress){
                    public static final long serialVersionUID = 0L;
                    private final JobProgressInfo jobProgressInfo$1;
                    private final double progress$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " numTasks = ", ", numCompletedTasks = ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jobProgressInfo$1.id(), BoxesRunTime.boxToInteger((int)this.jobProgressInfo$1.totalTasks()), BoxesRunTime.boxToInteger((int)this.jobProgressInfo$1.succeedTasks())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numActiveTasks = ", " , completed:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.jobProgressInfo$1.runningTasks()), JobProgressUtil$.MODULE$.percentageFormat(this.progress$1)}))).toString();
                    }
                    {
                        this.jobProgressInfo$1 = jobProgressInfo$1;
                        this.progress$1 = progress$1;
                    }
                });
                return var2_2;
            }
            {
                this.sc$2 = sc$2;
                this.jobGroup$1 = jobGroup$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(JobProgressInfo.class)));
        return progressInfos;
    }

    public JobProgressInfo[] getCompletedJobProgressInfo(SparkContext sc, String jobGroup) {
        int[] jobIds = sc.statusTracker().getJobIdsForGroup(jobGroup);
        SparkJobInfo[] completedJobs = (SparkJobInfo[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(jobIds).flatMap((Function1)new Serializable(sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$3;

            public final Iterable<SparkJobInfo> apply(int id) {
                return Option$.MODULE$.option2Iterable(this.sc$3.statusTracker().getJobInfo(id));
            }
            {
                this.sc$3 = sc$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkJobInfo.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SparkJobInfo x$4) {
                JobExecutionStatus jobExecutionStatus = x$4.status();
                JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.SUCCEEDED;
                return !(jobExecutionStatus != null ? !jobExecutionStatus.equals(jobExecutionStatus2) : jobExecutionStatus2 != null);
            }
        });
        JobProgressInfo[] progressInfos = (JobProgressInfo[])Predef$.MODULE$.refArrayOps((Object[])completedJobs).map((Function1)new Serializable(sc, jobGroup){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$3;
            private final String jobGroup$2;

            public final JobProgressInfo apply(SparkJobInfo job) {
                return JobProgressUtil$.MODULE$.org$apache$linkis$engineplugin$spark$utils$JobProgressUtil$$getJobProgressInfoByStages(job, this.sc$3, this.jobGroup$2);
            }
            {
                this.sc$3 = sc$3;
                this.jobGroup$2 = jobGroup$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(JobProgressInfo.class)));
        return progressInfos;
    }

    public JobProgressInfo org$apache$linkis$engineplugin$spark$utils$JobProgressUtil$$getJobProgressInfoByStages(SparkJobInfo job, SparkContext sc, String jobGroup) {
        SparkStatusTracker sparkStatusTracker = sc.statusTracker();
        SparkStageInfo[] stages = (SparkStageInfo[])Predef$.MODULE$.intArrayOps(job.stageIds()).flatMap((Function1)new Serializable(sparkStatusTracker){
            public static final long serialVersionUID = 0L;
            private final SparkStatusTracker eta$0$2$1;

            public final Iterable<SparkStageInfo> apply(int stageId) {
                return Option$.MODULE$.option2Iterable(this.eta$0$2$1.getStageInfo(stageId));
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkStageInfo.class)));
        IntRef numTasks = IntRef.create((int)0);
        IntRef numActiveTasks = IntRef.create((int)0);
        IntRef numFailedTasks = IntRef.create((int)0);
        IntRef numSucceedTasks = IntRef.create((int)0);
        Predef$.MODULE$.refArrayOps((Object[])stages).foreach((Function1)new Serializable(numTasks, numActiveTasks, numFailedTasks, numSucceedTasks){
            public static final long serialVersionUID = 0L;
            private final IntRef numTasks$1;
            private final IntRef numActiveTasks$1;
            private final IntRef numFailedTasks$1;
            private final IntRef numSucceedTasks$1;

            public final void apply(SparkStageInfo stageInfo) {
                if (stageInfo.submissionTime() > 0L) {
                    this.numTasks$1.elem += stageInfo.numTasks();
                    this.numActiveTasks$1.elem += stageInfo.numActiveTasks();
                    this.numFailedTasks$1.elem += stageInfo.numFailedTasks();
                    this.numSucceedTasks$1.elem += stageInfo.numCompletedTasks();
                }
            }
            {
                this.numTasks$1 = numTasks$1;
                this.numActiveTasks$1 = numActiveTasks$1;
                this.numFailedTasks$1 = numFailedTasks$1;
                this.numSucceedTasks$1 = numSucceedTasks$1;
            }
        });
        return new JobProgressInfo(this.getJobId(job.jobId(), jobGroup), numTasks.elem, numActiveTasks.elem, numFailedTasks.elem, numSucceedTasks.elem);
    }

    private String getJobId(int jobId, String jobGroup) {
        return new StringBuilder().append((Object)"jobId-").append((Object)BoxesRunTime.boxToInteger((int)jobId)).append((Object)"(").append((Object)jobGroup).append((Object)")").toString();
    }

    private NumberFormat _percentFormat() {
        return this._percentFormat;
    }

    private void _percentFormat_$eq(NumberFormat x$1) {
        this._percentFormat = x$1;
    }

    public String percentageFormat(double decimal) {
        if (this._percentFormat() == null) {
            this._percentFormat_$eq(NumberFormat.getPercentInstance());
            this._percentFormat().setMinimumFractionDigits(2);
        }
        return this._percentFormat().format(decimal);
    }

    private JobProgressUtil$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

