/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.factory;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.common.engineconn.EngineConn;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.entity.SparkEngineSession;
import org.apache.linkis.engineplugin.spark.exception.SparkCreateFileException;
import org.apache.linkis.engineplugin.spark.exception.SparkSessionNullException;
import org.apache.linkis.engineplugin.spark.factory.SparkPythonExecutorFactory;
import org.apache.linkis.engineplugin.spark.factory.SparkScalaExecutorFactory;
import org.apache.linkis.engineplugin.spark.factory.SparkSqlExecutorFactory;
import org.apache.linkis.manager.engineplugin.common.creation.AbstractEngineConnFactory;
import org.apache.linkis.manager.engineplugin.common.creation.ExecutorFactory;
import org.apache.linkis.manager.engineplugin.common.creation.MultiExecutorEngineConnFactory;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineConnModeLabel;
import org.apache.linkis.manager.label.entity.engine.EngineType$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.SparkUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001=\u0011ac\u00159be.,enZ5oK\u000e{gN\u001c$bGR|'/\u001f\u0006\u0003\u0007\u0011\tqAZ1di>\u0014\u0018P\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\rK:<\u0017N\\3qYV<\u0017N\u001c\u0006\u0003\u0013)\ta\u0001\\5oW&\u001c(BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!Y\t\u0003CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u0018?5\t\u0001D\u0003\u0002\u001a5\u0005A1M]3bi&|gN\u0003\u0002\u001c9\u000511m\\7n_:T!aB\u000f\u000b\u0005yA\u0011aB7b]\u0006<WM]\u0005\u0003Aa\u0011a$T;mi&,\u00050Z2vi>\u0014XI\\4j]\u0016\u001cuN\u001c8GC\u000e$xN]=\u0011\u0005\t2S\"A\u0012\u000b\u0005\u0011*\u0013!B;uS2\u001c(BA\u000e\t\u0013\t93EA\u0004M_\u001e<\u0017N\\4\t\u000b%\u0002A\u0011\u0001\u0016\u0002\rqJg.\u001b;?)\u0005Y\u0003C\u0001\u0017\u0001\u001b\u0005\u0011\u0001\"\u0002\u0018\u0001\t#z\u0013aF2sK\u0006$X-\u00128hS:,7i\u001c8o'\u0016\u001c8/[8o)\t\u00014\u0007\u0005\u0002\u0012c%\u0011!G\u0005\u0002\u0004\u0003:L\b\"\u0002\u001b.\u0001\u0004)\u0014!F3oO&tWm\u0011:fCRLwN\\\"p]R,\u0007\u0010\u001e\t\u0003mmj\u0011a\u000e\u0006\u00033aR!aG\u001d\u000b\u0005iB\u0011AC3oO&tWmY8o]&\u0011Ah\u000e\u0002\u0016\u000b:<\u0017N\\3De\u0016\fG/[8o\u0007>tG/\u001a=u\u0011\u0015q\u0004\u0001\"\u0001@\u0003I\u0019'/Z1uKN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0015\t\u0001;\u0015k\u0016\t\u0003\u0003\u0016k\u0011A\u0011\u0006\u0003\u0007\u0012\u000b1a]9m\u0015\t)!\"\u0003\u0002G\u0005\na1\u000b]1sWN+7o]5p]\")\u0001*\u0010a\u0001\u0013\u0006Iq.\u001e;qkR$\u0015N\u001d\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000b!![8\u000b\u00039\u000bAA[1wC&\u0011\u0001k\u0013\u0002\u0005\r&dW\rC\u0003S{\u0001\u00071+\u0001\u0003d_:4\u0007C\u0001+V\u001b\u0005!\u0015B\u0001,E\u0005%\u0019\u0006/\u0019:l\u0007>tg\rC\u0004Y{A\u0005\t\u0019A-\u0002!\u0005$G\rU=uQ>t7+\u001e9q_J$\bCA\t[\u0013\tY&CA\u0004C_>dW-\u00198\t\u000bu\u0003A\u0011\u00010\u0002!\r\u0014X-\u0019;f'Fc5i\u001c8uKb$H#B0cO\u0006%\u0001CA!a\u0013\t\t'I\u0001\u0006T#2\u001buN\u001c;fqRDQa\u0019/A\u0002\u0011\f!a]2\u0011\u0005Q+\u0017B\u00014E\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015AG\f1\u0001j\u0003\u001dy\u0007\u000f^5p]N\u0004BA\u001b>~{:\u00111n\u001e\b\u0003YVt!!\u001c;\u000f\u00059\u001chBA8s\u001b\u0005\u0001(BA9\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003m\"\taa]3sm\u0016\u0014\u0018B\u0001=z\u0003\u001d\u0001\u0018mY6bO\u0016T!A\u001e\u0005\n\u0005md(\u0001\u0002&NCBT!\u0001_=\u0011\u0007y\f\u0019A\u0004\u0002\u0012\u007f&\u0019\u0011\u0011\u0001\n\u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\rM#(/\u001b8h\u0015\r\t\tA\u0005\u0005\u0007\u0003\u0017a\u0006\u0019\u0001!\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\u0005y1M]3bi\u0016|U\u000f\u001e9vi\u0012K'\u000fF\u0002J\u0003'AaAUA\u0007\u0001\u0004\u0019\u0006bBA\f\u0001\u0011E\u0013\u0011D\u0001\u001fO\u0016$H)\u001a4bk2$X\t_3dkR|'OR1di>\u0014\u0018p\u00117bgN,\"!a\u00071\t\u0005u\u0011q\u0005\t\u0006}\u0006}\u00111E\u0005\u0005\u0003C\t9AA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0002&\u0005\u001dB\u0002\u0001\u0003\r\u0003S\t)\"!A\u0001\u0002\u000b\u0005\u00111\u0006\u0002\u0004?\u0012\u0012\u0014\u0003BA\u0017\u0003g\u00012!EA\u0018\u0013\r\t\tD\u0005\u0002\b\u001d>$\b.\u001b8h!\r9\u0012QG\u0005\u0004\u0003oA\"aD#yK\u000e,Ho\u001c:GC\u000e$xN]=\t\u000f\u0005m\u0002\u0001\"\u0015\u0002>\u0005\tr-\u001a;F]\u001eLg.Z\"p]:$\u0016\u0010]3\u0016\u0005\u0005}\u0002\u0003BA!\u0003GrA!a\u0011\u0002^9!\u0011QIA,\u001d\u0011\t9%!\u0015\u000f\t\u0005%\u0013Q\n\b\u0004Y\u0006-\u0013B\u0001\u0010\t\u0013\r\ty%H\u0001\u0006Y\u0006\u0014W\r\\\u0005\u0005\u0003'\n)&\u0001\u0004f]RLG/\u001f\u0006\u0004\u0003\u001fj\u0012\u0002BA-\u00037\na!\u001a8hS:,'\u0002BA*\u0003+JA!a\u0018\u0002b\u0005QQI\\4j]\u0016$\u0016\u0010]3\u000b\t\u0005e\u00131L\u0005\u0005\u0003K\n9G\u0001\u0006F]\u001eLg.\u001a+za\u0016TA!a\u0018\u0002b!I\u00111\u000e\u0001C\u0002\u0013%\u0011QN\u0001\u0015Kb,7-\u001e;pe\u001a\u000b7\r^8ss\u0006\u0013(/Y=\u0016\u0005\u0005=\u0004#B\t\u0002r\u0005M\u0012bAA:%\t)\u0011I\u001d:bs\"A\u0011q\u000f\u0001!\u0002\u0013\ty'A\u000bfq\u0016\u001cW\u000f^8s\r\u0006\u001cGo\u001c:z\u0003J\u0014\u0018-\u001f\u0011\t\u000f\u0005m\u0004\u0001\"\u0011\u0002n\u0005!r-\u001a;Fq\u0016\u001cW\u000f^8s\r\u0006\u001cGo\u001c:jKND\u0011\"a \u0001#\u0003%\t!!!\u00029\r\u0014X-\u0019;f'B\f'o[*fgNLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0011\u0016\u00043\u0006\u00155FAAD!\u0011\tI)a%\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E%#\u0001\u0006b]:|G/\u0019;j_:LA!!&\u0002\f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class SparkEngineConnFactory
implements MultiExecutorEngineConnFactory {
    private final ExecutorFactory[] executorFactoryArray;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public ExecutorFactory getDefaultExecutorFactory() {
        return MultiExecutorEngineConnFactory.class.getDefaultExecutorFactory((MultiExecutorEngineConnFactory)this);
    }

    public EngineConnModeLabel getEngineConnModeLabel(List<Label<?>> labels) {
        return MultiExecutorEngineConnFactory.class.getEngineConnModeLabel((MultiExecutorEngineConnFactory)this, labels);
    }

    private Logger logger$lzycompute() {
        SparkEngineConnFactory sparkEngineConnFactory = this;
        synchronized (sparkEngineConnFactory) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    public EngineConn createEngineConn(EngineCreationContext engineCreationContext) {
        return AbstractEngineConnFactory.class.createEngineConn((AbstractEngineConnFactory)this, (EngineCreationContext)engineCreationContext);
    }

    public Object createEngineConnSession(EngineCreationContext engineCreationContext) {
        BoxedUnit boxedUnit;
        Map options = engineCreationContext.getOptions();
        boolean useSparkSubmit = true;
        SparkConf sparkConf = new SparkConf(true);
        String master = (String)sparkConf.getOption("spark.master").getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return (String)CommonVars$.MODULE$.apply("spark.master", (Object)"yarn").getValue();
            }
        });
        this.info((Function0<String>)new Serializable(this, master){
            public static final long serialVersionUID = 0L;
            private final String master$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"------ Create new SparkContext {", "} -------"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.master$1}));
            }
            {
                this.master$1 = master$1;
            }
        });
        String pysparkBasePath = (String)SparkConfiguration$.MODULE$.SPARK_HOME().getValue();
        File pysparkPath = new File(pysparkBasePath, new StringBuilder().append((Object)"python").append((Object)File.separator).append((Object)"lib").toString());
        String[] pythonLibUris = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pysparkPath.listFiles()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return x$1.toURI().toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.endsWith(".zip");
            }
        });
        if (pythonLibUris.length == 2) {
            String sparkConfValue1 = (String)Utils$.MODULE$.tryQuietly((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return (String)CommonVars$.MODULE$.apply("spark.yarn.dist.files", (Object)"").getValue();
                }
            });
            String sparkConfValue2 = (String)Utils$.MODULE$.tryQuietly((Function0)new Serializable(this, sparkConf){
                public static final long serialVersionUID = 0L;
                private final SparkConf sparkConf$1;

                public final String apply() {
                    return this.sparkConf$1.get("spark.yarn.dist.files");
                }
                {
                    this.sparkConf$1 = sparkConf$1;
                }
            });
            boxedUnit = StringUtils.isEmpty((String)sparkConfValue1) && StringUtils.isEmpty((String)sparkConfValue2) ? sparkConf.set("spark.yarn.dist.files", Predef$.MODULE$.refArrayOps((Object[])pythonLibUris).mkString(",")) : (StringUtils.isEmpty((String)sparkConfValue1) ? sparkConf.set("spark.yarn.dist.files", new StringBuilder().append((Object)sparkConfValue2).append((Object)",").append((Object)Predef$.MODULE$.refArrayOps((Object[])pythonLibUris).mkString(",")).toString()) : (StringUtils.isEmpty((String)sparkConfValue2) ? sparkConf.set("spark.yarn.dist.files", new StringBuilder().append((Object)sparkConfValue1).append((Object)",").append((Object)Predef$.MODULE$.refArrayOps((Object[])pythonLibUris).mkString(",")).toString()) : sparkConf.set("spark.yarn.dist.files", new StringBuilder().append((Object)sparkConfValue1).append((Object)",").append((Object)sparkConfValue2).append((Object)",").append((Object)Predef$.MODULE$.refArrayOps((Object[])pythonLibUris).mkString(",")).toString())));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = master.contains("yarn") ? sparkConf.set("spark.yarn.isPython", "true") : BoxedUnit.UNIT;
        File outputDir = this.createOutputDir(sparkConf);
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"print current thread name ").append((Object)Thread.currentThread().getContextClassLoader().toString()).toString();
            }
        });
        SparkSession sparkSession = this.createSparkSession(outputDir, sparkConf, this.createSparkSession$default$3());
        if (sparkSession == null) {
            throw new SparkSessionNullException(40009, "sparkSession can not be null");
        }
        SparkContext sc = sparkSession.sparkContext();
        SQLContext sqlContext = this.createSQLContext(sc, (HashMap)options, sparkSession);
        sc.hadoopConfiguration().set("mapred.output.compress", (String)SparkConfiguration$.MODULE$.MAPRED_OUTPUT_COMPRESS().getValue(options));
        sc.hadoopConfiguration().set("mapred.output.compression.codec", (String)SparkConfiguration$.MODULE$.MAPRED_OUTPUT_COMPRESSION_CODEC().getValue(options));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Application report for ").append((Object)sc.applicationId()).toString());
        return new SparkEngineSession(sc, sqlContext, sparkSession, outputDir);
    }

    public SparkSession createSparkSession(File outputDir, SparkConf conf, boolean addPythonSupport) {
        Seq seq;
        String execUri = System.getenv("SPARK_EXECUTOR_URI");
        Option sparkJars = conf.getOption("spark.jars");
        String master = (String)conf.getOption("spark.master").getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return (String)SparkConfiguration$.MODULE$.SPARK_MASTER().getValue();
            }
        });
        this.info((Function0<String>)new Serializable(this, master){
            public static final long serialVersionUID = 0L;
            private final String master$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"------ Create new SparkContext {", "} -------"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.master$2}));
            }
            {
                this.master$2 = master$2;
            }
        });
        Object object = StringUtils.isNotEmpty((String)master) ? conf.setMaster(master) : BoxedUnit.UNIT;
        if (conf.get("spark.master").contains("yarn")) {
            Option yarnJars = conf.getOption("spark.yarn.dist.jars");
            seq = this.unionFileLists$1(sparkJars, yarnJars).toSeq();
        } else {
            seq = (Seq)Option$.MODULE$.option2Iterable(sparkJars.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply(String x$4) {
                    return x$4.split(",");
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply(String[] x$5) {
                    return (String[])Predef$.MODULE$.refArrayOps((Object[])x$5).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$6) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
                        }
                    });
                }
            })).toSeq().flatten((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<String> apply(String[] xs) {
                    return Predef$.MODULE$.refArrayOps((Object[])xs);
                }
            });
        }
        Seq jars = seq;
        Object object2 = outputDir == null ? BoxedUnit.UNIT : conf.set("spark.repl.class.outputDir", outputDir.getAbsolutePath());
        Object object3 = jars.nonEmpty() ? conf.setJars(jars) : BoxedUnit.UNIT;
        Object object4 = execUri == null ? BoxedUnit.UNIT : conf.set("spark.executor.uri", execUri);
        Object object5 = System.getenv("SPARK_HOME") == null ? BoxedUnit.UNIT : conf.setSparkHome(System.getenv("SPARK_HOME"));
        conf.set("spark.scheduler.mode", "FAIR");
        SparkSession.Builder builder = SparkSession$.MODULE$.builder().config(conf);
        return builder.enableHiveSupport().getOrCreate();
    }

    public boolean createSparkSession$default$3() {
        return false;
    }

    public SQLContext createSQLContext(SparkContext sc, HashMap<String, String> options, SparkSession sparkSession) {
        Object object;
        ObjectRef sqlc = ObjectRef.create(null);
        if (BoxesRunTime.unboxToBoolean((Object)SparkConfiguration$.MODULE$.LINKIS_SPARK_USEHIVECONTEXT().getValue(options))) {
            String name = "org.apache.spark.sql.hive.HiveContext";
            ObjectRef hc = ObjectRef.create(null);
            object = Utils$.MODULE$.tryCatch((Function0)new Serializable(this, sc, sqlc, name, hc){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkEngineConnFactory $outer;
                private final SparkContext sc$1;
                private final ObjectRef sqlc$1;
                private final String name$1;
                private final ObjectRef hc$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.hc$1.elem = this.$outer.getClass().getClassLoader().loadClass(this.name$1).getConstructor(SparkContext.class);
                    this.sqlc$1.elem = (SQLContext)((Constructor)this.hc$1.elem).newInstance(this.sc$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sc$1 = sc$1;
                    this.sqlc$1 = sqlc$1;
                    this.name$1 = name$1;
                    this.hc$1 = hc$1;
                }
            }, (Function1)new Serializable(this, sparkSession, sqlc){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkEngineConnFactory $outer;
                private final SparkSession sparkSession$1;
                private final ObjectRef sqlc$1;

                public final void apply(Throwable e) {
                    this.$outer.logger().warn("Can't create HiveContext. Fallback to SQLContext", e);
                    this.sqlc$1.elem = this.sparkSession$1.sqlContext();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sparkSession$1 = sparkSession$1;
                    this.sqlc$1 = sqlc$1;
                }
            });
        } else {
            sqlc.elem = sparkSession.sqlContext();
            object = BoxedUnit.UNIT;
        }
        return (SQLContext)sqlc.elem;
    }

    public File createOutputDir(SparkConf conf) {
        String rootDir = conf.get("spark.repl.classdir", System.getProperty("java.io.tmpdir"));
        return (File)Utils$.MODULE$.tryThrow((Function0)new Serializable(this, conf, rootDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkEngineConnFactory $outer;
            private final SparkConf conf$1;
            private final String rootDir$1;

            /*
             * WARNING - void declaration
             */
            public final File apply() {
                void var1_1;
                File output = SparkUtils$.MODULE$.createTempDir(this.rootDir$1, "repl");
                this.$outer.info((Function0<String>)new Serializable(this, output){
                    public static final long serialVersionUID = 0L;
                    private final File output$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"outputDir====> ").append((Object)this.output$1).toString();
                    }
                    {
                        this.output$1 = output$1;
                    }
                });
                output.deleteOnExit();
                this.conf$1.set("spark.repl.class.outputDir", output.getAbsolutePath());
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conf$1 = conf$1;
                this.rootDir$1 = rootDir$1;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkEngineConnFactory $outer;

            public final Null$ apply(Throwable t) {
                this.$outer.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "create spark repl classdir failed";
                    }
                }, t);
                throw new SparkCreateFileException(80002, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark repl classdir create exception"})).s((Seq)Nil$.MODULE$), t);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Class<? extends ExecutorFactory> getDefaultExecutorFactoryClass() {
        return SparkSqlExecutorFactory.class;
    }

    public Enumeration.Value getEngineConnType() {
        return EngineType$.MODULE$.SPARK();
    }

    private ExecutorFactory[] executorFactoryArray() {
        return this.executorFactoryArray;
    }

    public ExecutorFactory[] getExecutorFactories() {
        return this.executorFactoryArray();
    }

    private final Set unionFileLists$1(Option leftList, Option rightList) {
        ObjectRef allFiles = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        leftList.foreach((Function1)new Serializable(this, allFiles){
            public static final long serialVersionUID = 0L;
            private final ObjectRef allFiles$1;

            public final void apply(String value) {
                this.allFiles$1.elem = (Set)((Set)this.allFiles$1.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])value.split(",")));
            }
            {
                this.allFiles$1 = allFiles$1;
            }
        });
        rightList.foreach((Function1)new Serializable(this, allFiles){
            public static final long serialVersionUID = 0L;
            private final ObjectRef allFiles$1;

            public final void apply(String value) {
                this.allFiles$1.elem = (Set)((Set)this.allFiles$1.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])value.split(",")));
            }
            {
                this.allFiles$1 = allFiles$1;
            }
        });
        return (Set)((Set)allFiles.elem).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
            }
        });
    }

    public SparkEngineConnFactory() {
        AbstractEngineConnFactory.class.$init$((AbstractEngineConnFactory)this);
        Logging.class.$init$((Logging)this);
        MultiExecutorEngineConnFactory.class.$init$((MultiExecutorEngineConnFactory)this);
        this.executorFactoryArray = (ExecutorFactory[])((Object[])new ExecutorFactory[]{new SparkSqlExecutorFactory(), new SparkPythonExecutorFactory(), new SparkScalaExecutorFactory()});
    }
}

