/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.imexport;

import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.imexport.CsvRelation$;
import org.apache.linkis.engineplugin.spark.imexport.LoadData$;
import org.apache.linkis.engineplugin.spark.imexport.util.BackGroundServiceUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ExportData$
implements Logging {
    public static final ExportData$ MODULE$;
    private final DefaultFormats$ formats;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ExportData$();
    }

    private Logger logger$lzycompute() {
        ExportData$ exportData$ = this;
        synchronized (exportData$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    public DefaultFormats$ formats() {
        return this.formats;
    }

    public void exportData(SparkSession spark, String dataInfo, String destination) {
        this.exportDataFromFile(spark, (Map<String, Object>)((Map)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(dataInfo), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})))), (Map<String, Object>)((Map)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(destination), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})))));
    }

    public void exportDataByFile(SparkSession spark, String dataInfoPath, String destination) {
        String dataInfo = BackGroundServiceUtils$.MODULE$.exchangeExecutionCode(dataInfoPath);
        this.exportDataFromFile(spark, (Map<String, Object>)((Map)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(dataInfo), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})))), (Map<String, Object>)((Map)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(destination), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})))));
    }

    public void exportDataFromFile(SparkSession spark, Map<String, Object> dataInfo, Map<String, Object> dest) {
        Object object;
        Dataset df = spark.sql(this.getExportSql(dataInfo));
        String pathType = LoadData$.MODULE$.getMapValue(dest, "pathType", "share");
        String path = "share".equals(pathType) ? new StringBuilder().append((Object)"file://").append(LoadData$.MODULE$.getMapValue(dest, "path", LoadData$.MODULE$.getMapValue$default$3())).toString() : (BoxesRunTime.unboxToBoolean((Object)SparkConfiguration$.MODULE$.IS_VIEWFS_ENV().getValue()) ? (String)LoadData$.MODULE$.getMapValue(dest, "path", LoadData$.MODULE$.getMapValue$default$3()) : new StringBuilder().append((Object)"hdfs://").append(LoadData$.MODULE$.getMapValue(dest, "path", LoadData$.MODULE$.getMapValue$default$3())).toString());
        boolean hasHeader = BoxesRunTime.unboxToBoolean((Object)LoadData$.MODULE$.getMapValue(dest, "hasHeader", BoxesRunTime.boxToBoolean((boolean)false)));
        boolean isCsv = BoxesRunTime.unboxToBoolean((Object)LoadData$.MODULE$.getMapValue(dest, "isCsv", BoxesRunTime.boxToBoolean((boolean)true)));
        boolean isOverwrite = BoxesRunTime.unboxToBoolean((Object)LoadData$.MODULE$.getMapValue(dest, "isOverwrite", BoxesRunTime.boxToBoolean((boolean)true)));
        String sheetName = LoadData$.MODULE$.getMapValue(dest, "sheetName", "Sheet1");
        String fieldDelimiter = LoadData$.MODULE$.getMapValue(dest, "fieldDelimiter", ",");
        String nullValue = LoadData$.MODULE$.getMapValue(dest, "nullValue", "SHUFFLEOFF");
        if (isCsv) {
            object = BoxesRunTime.boxToBoolean((boolean)CsvRelation$.MODULE$.saveDFToCsv(spark, (Dataset<Row>)df, path, hasHeader, isOverwrite, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldDelimiter"), (Object)fieldDelimiter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exportNullValue"), (Object)nullValue)})))));
        } else {
            df.write().format("com.webank.wedatasphere.spark.excel").option("sheetName", sheetName).option("useHeader", hasHeader).option("exportNullValue", nullValue).mode("overwrite").save(path);
            object = BoxedUnit.UNIT;
        }
        this.warn((Function0<String>)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Succeed to export data  to path:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    public String getExportSql(Map<String, Object> dataInfo) {
        String string;
        StringBuilder sql = new StringBuilder();
        String database = (String)LoadData$.MODULE$.getMapValue(dataInfo, "database", LoadData$.MODULE$.getMapValue$default$3());
        String tableName = (String)LoadData$.MODULE$.getMapValue(dataInfo, "tableName", LoadData$.MODULE$.getMapValue$default$3());
        boolean isPartition = BoxesRunTime.unboxToBoolean((Object)LoadData$.MODULE$.getMapValue(dataInfo, "isPartition", BoxesRunTime.boxToBoolean((boolean)false)));
        String partition = LoadData$.MODULE$.getMapValue(dataInfo, "partition", "ds");
        if (partition.equals("ds")) {
            string = LoadData$.MODULE$.getMapValue(dataInfo, "partitionValue", "1993-01-02");
        } else {
            String value = LoadData$.MODULE$.getMapValue(dataInfo, "partitionValue", "1993-01-02");
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}));
        }
        String partitionValue = string;
        String columns = LoadData$.MODULE$.getMapValue(dataInfo, "columns", "*");
        sql.append("select ").append(columns).append(" from ").append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName})));
        Object object = isPartition ? sql.append(" where ").append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, partitionValue}))) : BoxedUnit.UNIT;
        String sqlString = sql.toString();
        this.warn((Function0<String>)new Serializable(sqlString){
            public static final long serialVersionUID = 0L;
            private final String sqlString$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"export sql:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sqlString$1}));
            }
            {
                this.sqlString$1 = sqlString$1;
            }
        });
        return sqlString;
    }

    private ExportData$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.formats = DefaultFormats$.MODULE$;
    }
}

