/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.cs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.cs.client.service.CSTableService;
import org.apache.linkis.cs.common.entity.metadata.CSTable;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineplugin.spark.exception.ExecuteError;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.datasources.csv.DolphinToSpark$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;

public final class CSTableParser$
implements Logging {
    public static final CSTableParser$ MODULE$;
    private final Pattern pb;
    private final String DB;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new CSTableParser$();
    }

    private Logger logger$lzycompute() {
        CSTableParser$ cSTableParser$ = this;
        synchronized (cSTableParser$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    private Pattern pb() {
        return this.pb;
    }

    private String DB() {
        return this.DB;
    }

    public String[] org$apache$linkis$engineplugin$spark$cs$CSTableParser$$getCSTempTable(String code) {
        ArrayBuffer bmlResourceNames = new ArrayBuffer();
        Matcher mb = this.pb().matcher(code);
        while (mb.find()) {
            bmlResourceNames.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{mb.group().trim()}));
        }
        return (String[])bmlResourceNames.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public String parse(EngineExecutionContext engineExecutorContext, String code, String contextIDValueStr, String nodeNameStr) {
        String[] csTempTables = this.org$apache$linkis$engineplugin$spark$cs$CSTableParser$$getCSTempTable(code);
        ArrayBuffer parsedTables = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])csTempTables).foreach((Function1)new Serializable(contextIDValueStr, nodeNameStr, parsedTables){
            public static final long serialVersionUID = 0L;
            private final String contextIDValueStr$1;
            private final String nodeNameStr$1;
            private final ArrayBuffer parsedTables$1;

            public final void apply(String csTempTable) {
                CSTable table = CSTableParser$.MODULE$.getCSTable(csTempTable, this.contextIDValueStr$1, this.nodeNameStr$1);
                if (table == null) {
                    throw new ExecuteError(40007, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The csTable that name is ", " not found in cs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{csTempTable})));
                }
                CSTableParser$.MODULE$.registerTempTable(table);
                this.parsedTables$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{csTempTable}));
            }
            {
                this.contextIDValueStr$1 = contextIDValueStr$1;
                this.nodeNameStr$1 = nodeNameStr$1;
                this.parsedTables$1 = parsedTables$1;
            }
        });
        return StringUtils.replaceEach((String)code, (String[])csTempTables, (String[])((String[])parsedTables.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    public CSTable getCSTable(String csTempTable, String contextIDValueStr, String nodeNameStr) {
        return CSTableService.getInstance().getUpstreamSuitableTable(contextIDValueStr, nodeNameStr, csTempTable);
    }

    public void registerTempTable(CSTable csTable) {
        SparkSession spark = SparkSession$.MODULE$.builder().enableHiveSupport().getOrCreate();
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start to create  tempView to sparkSession viewName(", ") location(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{csTable.getName(), csTable.getLocation()})));
        DolphinToSpark$.MODULE$.createTempView(spark, csTable.getName(), csTable.getLocation(), true);
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished to create  tempView to sparkSession viewName(", ") location(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{csTable.getName(), csTable.getLocation()})));
    }

    public void org$apache$linkis$engineplugin$spark$cs$CSTableParser$$unRegisterTempTable(String tmpView) {
        SparkSession spark = SparkSession$.MODULE$.builder().enableHiveSupport().getOrCreate();
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to drop temp view ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpView})));
        spark.catalog().dropTempView(tmpView);
    }

    public void clearCSTmpView(String code, String contextIDValueStr, String nodeNameStr) {
        Utils$.MODULE$.tryAndWarnMsg((Function0)new Serializable(code){
            public static final long serialVersionUID = 0L;
            private final String code$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String[] tables = CSTableParser$.MODULE$.org$apache$linkis$engineplugin$spark$cs$CSTableParser$$getCSTempTable(this.code$1);
                Predef$.MODULE$.refArrayOps((Object[])tables).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String tmpView) {
                        CSTableParser$.MODULE$.org$apache$linkis$engineplugin$spark$cs$CSTableParser$$unRegisterTempTable(tmpView);
                    }
                });
            }
            {
                this.code$1 = code$1;
            }
        }, "Failed to clearCSTmpView", this.logger());
    }

    private CSTableParser$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.pb = Pattern.compile("cs_tmp_[^\\s\";'()]+[$\\s]{0,1}", 2);
        this.DB = "default.";
    }
}

