/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.imexport;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.imexport.CsvRelation$;
import org.apache.linkis.engineplugin.spark.imexport.util.BackGroundServiceUtils$;
import org.apache.linkis.engineplugin.spark.imexport.util.ImExportUtils$;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.hadoop.common.utils.HDFSUtils$;
import org.apache.linkis.storage.excel.XlsUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LoadData$ {
    public static final LoadData$ MODULE$;
    private final DefaultFormats$ formats;

    static {
        new LoadData$();
    }

    public DefaultFormats$ formats() {
        return this.formats;
    }

    public void loadDataToTable(SparkSession spark, String source, String destination) {
        this.create_table_from_a_file(spark, JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(source), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()), JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(destination), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
    }

    public void loadDataToTableByFile(SparkSession spark, String destinationPath, String source) {
        String destination = BackGroundServiceUtils$.MODULE$.exchangeExecutionCode(destinationPath);
        this.create_table_from_a_file(spark, JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(source), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()), JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(destination), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
    }

    public void create_table_from_a_file(SparkSession spark, JsonAST.JValue src, JsonAST.JValue dest) {
        block23: {
            Map source = (Map)package$.MODULE$.jvalue2extractable(src).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})));
            Map destination = (Map)package$.MODULE$.jvalue2extractable(dest).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})));
            String path = (String)this.getMapValue((Map<String, Object>)source, "path", this.getMapValue$default$3());
            String pathType = this.getMapValue((Map<String, Object>)source, "pathType", "share");
            boolean hasHeader = BoxesRunTime.unboxToBoolean((Object)this.getMapValue((Map<String, Object>)source, "hasHeader", BoxesRunTime.boxToBoolean((boolean)false)));
            String sheetName = this.getMapValue((Map<String, Object>)source, "sheet", "Sheet1");
            String dateFormat = this.getMapValue((Map<String, Object>)source, "dateFormat", "yyyy-MM-dd");
            String suffix = path.substring(path.lastIndexOf("."));
            java.util.List sheetNames = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(Predef$.MODULE$.refArrayOps((Object[])sheetName.split(",")).toBuffer()).asJava();
            FileSystem fs = null;
            String database = (String)this.getMapValue((Map<String, Object>)destination, "database", this.getMapValue$default$3());
            String tableName = (String)this.getMapValue((Map<String, Object>)destination, "tableName", this.getMapValue$default$3());
            boolean importData = BoxesRunTime.unboxToBoolean((Object)this.getMapValue((Map<String, Object>)destination, "importData", BoxesRunTime.boxToBoolean((boolean)true)));
            boolean isPartition = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)new Serializable(destination){
                public static final long serialVersionUID = 0L;
                private final Map destination$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return BoxesRunTime.unboxToBoolean((Object)LoadData$.MODULE$.getMapValue((Map<String, Object>)this.destination$1, "isPartition", BoxesRunTime.boxToBoolean((boolean)true)));
                }
                {
                    this.destination$1 = destination$1;
                }
            }, (Function1)new Serializable(destination){
                public static final long serialVersionUID = 0L;
                private final Map destination$1;

                public final boolean apply(Throwable x0$1) {
                    Throwable throwable = x0$1;
                    if (throwable instanceof Exception) {
                        BigInt flag = LoadData$.MODULE$.getMapValue((Map<String, Object>)this.destination$1, "isPartition", BigInt$.MODULE$.int2bigInt(0));
                        boolean bl = BoxesRunTime.equalsNumObject((Number)flag, (Object)BoxesRunTime.boxToInteger((int)1));
                        return bl;
                    }
                    throw new MatchError((Object)throwable);
                }
                {
                    this.destination$1 = destination$1;
                }
            }));
            boolean isOverwrite = BoxesRunTime.unboxToBoolean((Object)this.getMapValue((Map<String, Object>)destination, "isOverwrite", BoxesRunTime.boxToBoolean((boolean)false)));
            String partition = this.getMapValue((Map<String, Object>)destination, "partition", "ds");
            String partitionValue = this.getMapValue((Map<String, Object>)destination, "partitionValue", "1993-01-02");
            List columns = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(dest).$bslash("columns")).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
            List dateFormats = (List)((List)columns.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Map<String, Object> x$1) {
                    return x$1.get((Object)"dateFormat").get().toString();
                }
            }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String f) {
                    return f.isEmpty() ? "yyyy-MM-dd" : f;
                }
            }, List$.MODULE$.canBuildFrom());
            BooleanRef isFirst = BooleanRef.create((boolean)true);
            StringBuilder dateFormatsJson = new StringBuilder();
            dateFormats.foreach((Function1)new Serializable(isFirst, dateFormatsJson){
                public static final long serialVersionUID = 0L;
                private final BooleanRef isFirst$1;
                private final StringBuilder dateFormatsJson$1;

                public final StringBuilder apply(String f) {
                    StringBuilder stringBuilder;
                    if (this.isFirst$1.elem) {
                        this.isFirst$1.elem = false;
                        stringBuilder = BoxedUnit.UNIT;
                    } else {
                        stringBuilder = this.dateFormatsJson$1.append(";");
                    }
                    return this.dateFormatsJson$1.append(f);
                }
                {
                    this.isFirst$1 = isFirst$1;
                    this.dateFormatsJson$1 = dateFormatsJson$1;
                }
            });
            String indexesStr = String.join((CharSequence)",", (Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)columns.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Map<String, Object> x$2) {
                    return x$2.getOrElse((Object)"index", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    }).toString();
                }
            }, List$.MODULE$.canBuildFrom())).asJava());
            if ("hdfs".equalsIgnoreCase(pathType)) {
                if (".xls".equalsIgnoreCase(suffix)) {
                    Configuration config = HDFSUtils$.MODULE$.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue());
                    config.setBoolean("fs.hdfs.impl.disable.cache", true);
                    fs = HDFSUtils$.MODULE$.getHDFSUserFileSystem(System.getProperty("user.name"), config);
                    path = XlsUtils.excelToCsv((InputStream)fs.open(new Path(path)), (FileSystem)fs, (Boolean)Predef$.MODULE$.boolean2Boolean(hasHeader), (java.util.List)sheetNames);
                    hasHeader = false;
                } else {
                    path = BoxesRunTime.unboxToBoolean((Object)SparkConfiguration$.MODULE$.IS_VIEWFS_ENV().getValue()) ? path : new StringBuilder().append((Object)"hdfs://").append((Object)path).toString();
                }
            } else if (".xlsx".equalsIgnoreCase(suffix)) {
                path = new StringBuilder().append((Object)"file://").append((Object)path).toString();
            } else if (".xls".equalsIgnoreCase(suffix)) {
                Configuration config = HDFSUtils$.MODULE$.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue());
                config.setBoolean("fs.hdfs.impl.disable.cache", true);
                fs = HDFSUtils$.MODULE$.getHDFSUserFileSystem(System.getProperty("user.name"), config);
                path = XlsUtils.excelToCsv((InputStream)new FileInputStream(path), (FileSystem)fs, (Boolean)Predef$.MODULE$.boolean2Boolean(hasHeader), (java.util.List)sheetNames);
                hasHeader = false;
            } else {
                Configuration config = HDFSUtils$.MODULE$.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue());
                config.setBoolean("fs.hdfs.impl.disable.cache", true);
                fs = HDFSUtils$.MODULE$.getHDFSUserFileSystem(System.getProperty("user.name"), config);
                path = this.copyFileToHdfs(path, fs);
            }
            Dataset df = ".xlsx".equalsIgnoreCase(suffix) ? spark.read().format("com.webank.wedatasphere.spark.excel").option("useHeader", hasHeader).option("maxRowsInMemory", 100L).option("sheetName", sheetName).option("indexes", indexesStr).option("dateFormats", dateFormatsJson.toString()).schema(new StructType(this.getFields((List<Map<String, Object>>)columns))).load(path) : CsvRelation$.MODULE$.csvToDF(spark, new StructType(this.getFields((List<Map<String, Object>>)columns)), hasHeader, path, (Map<String, Object>)source, (List<Map<String, Object>>)columns);
            df.createOrReplaceTempView("tempTable");
            try {
                if (importData) {
                    if (isPartition) {
                        if (isOverwrite) {
                            spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT OVERWRITE TABLE  ", ".", " partition(", "='", "') select * from tempTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, partition, partitionValue})));
                        } else {
                            spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO  ", ".", " partition(", "='", "') select * from tempTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, partition, partitionValue})));
                        }
                    } else if (isOverwrite) {
                        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT OVERWRITE TABLE  ", ".", " select * from tempTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName})));
                    } else {
                        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO   ", ".", " select * from tempTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName})));
                    }
                } else {
                    Object object = spark.catalog().tableExists(database, tableName) ? spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName}))) : BoxedUnit.UNIT;
                    if (isPartition) {
                        String columnSql = this.getColumnSql((List<Map<String, Object>>)columns);
                        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create table ", ".", "(", ") PARTITIONED BY (`", "` string) stored as orc tblproperties ('orc.compress'='SNAPPY')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, columnSql, partition}));
                        spark.sql(sql);
                        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT OVERWRITE TABLE  ", ".", " partition(", "='", "') select * from tempTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, partition, partitionValue})));
                    } else {
                        String columnSql = this.getColumnSql((List<Map<String, Object>>)columns);
                        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create table ", ".", "(", ") stored as orc tblproperties ('orc.compress'='SNAPPY')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, columnSql}));
                        spark.sql(sql);
                        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT OVERWRITE TABLE  ", ".", " select * from tempTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName})));
                    }
                }
                if (fs == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    Object object = importData ? BoxedUnit.UNIT : ImExportUtils$.MODULE$.tryAndIngoreError(new Serializable(spark, database, tableName){
                        public static final long serialVersionUID = 0L;
                        private final SparkSession spark$1;
                        private final String database$1;
                        private final String tableName$1;

                        public final Dataset<Row> apply() {
                            return this.spark$1.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.database$1, this.tableName$1})));
                        }
                        {
                            this.spark$1 = spark$1;
                            this.database$1 = database$1;
                            this.tableName$1 = tableName$1;
                        }
                    });
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (fs != null) {
                        fs.delete(new Path(path), true);
                        fs.close();
                    }
                    throw throwable2;
                }
            }
            fs.delete(new Path(path), true);
            fs.close();
        }
    }

    public String copyFileToHdfs(String path, FileSystem fs) {
        File file = new File(path);
        if (file.isDirectory()) {
            throw new Exception("Import must be a file, not a directory(\u5bfc\u5165\u7684\u5fc5\u987b\u662f\u6587\u4ef6\uff0c\u4e0d\u80fd\u662f\u76ee\u5f55)");
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        String hdfsPath = new StringBuilder().append((Object)"/tmp/").append((Object)System.getProperty("user.name")).append((Object)"/").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).append((Object)file.getName()).toString();
        FSDataOutputStream out = fs.create(new Path(hdfsPath), true);
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)4096);
        out.hsync();
        IOUtils.closeStream((Closeable)in);
        IOUtils.closeStream((Closeable)out);
        return hdfsPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getNodeValue(JsonAST.JValue json, String node, T t, Manifest<T> m) {
        Object object;
        T t2;
        JsonAST.JValue jValue = package$.MODULE$.jvalue2monadic(json).$bslash(node);
        JsonAST.JNothing$ jNothing$ = package$.MODULE$.JNothing();
        JsonAST.JValue jValue2 = jValue;
        if (!(jNothing$ != null ? !jNothing$.equals(jValue2) : jValue2 != null)) {
            t2 = t;
            return t2;
        }
        if (jValue == null) throw new MatchError((Object)jValue);
        JsonAST.JValue jValue3 = jValue;
        if ("JString()".equals(jValue3.toString())) {
            object = t;
        } else {
            try {
                object = package$.MODULE$.jvalue2extractable(jValue3).extract((Formats)this.formats(), m);
            }
            catch (Throwable throwable) {
                object = t;
            }
        }
        t2 = object;
        return t2;
    }

    public <T> T getNodeValue$default$3() {
        return null;
    }

    public <T> T getMapValue(Map<String, Object> map, String key, T t) {
        Object value = map.get((Object)key).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final T apply(Object x$3) {
                return (T)x$3;
            }
        }).getOrElse((Function0)new Serializable(t){
            public static final long serialVersionUID = 0L;
            private final Object default$1;

            public final T apply() {
                return (T)this.default$1;
            }
            {
                this.default$1 = default$1;
            }
        });
        return (T)(StringUtils.isEmpty((CharSequence)value.toString()) ? t : value);
    }

    public <T> T getMapValue$default$3() {
        return null;
    }

    public String getColumnSql(List<Map<String, Object>> columns) {
        StringBuilder sql = new StringBuilder();
        columns.foreach((Function1)new Serializable(sql){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sql$1;

            public final StringBuilder apply(Map<String, Object> column) {
                BoxedUnit boxedUnit;
                if (column.apply((Object)"name") == null) {
                    throw new IllegalArgumentException("When create a table, the field name must be defined(\u5efa\u7acb\u65b0\u8868\u65f6\uff0c\u5b57\u6bb5\u540d\u5fc5\u987b\u5b9a\u4e49)");
                }
                String name = (String)column.apply((Object)"name");
                this.sql$1.append("`").append(name).append("` ");
                String dataType = ((String)column.getOrElse((Object)"type", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "string";
                    }
                })).toLowerCase();
                this.sql$1.append(dataType);
                String string = dataType;
                boolean bl = "char".equals(string) ? true : "varchar".equals(string);
                if (bl) {
                    int length = new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"length", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 20;
                        }
                    }).toString())).toInt();
                    boxedUnit = this.sql$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)})));
                } else if ("decimal".equals(string)) {
                    int precision = new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"precision", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 20;
                        }
                    }).toString())).toInt();
                    int scale = new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"scale", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 4;
                        }
                    }).toString())).toInt();
                    boxedUnit = this.sql$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)precision), BoxesRunTime.boxToInteger((int)scale)})));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                String comment = column.getOrElse((Object)"comment", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }).toString();
                Object object = StringUtils.isNotEmpty((CharSequence)comment) ? this.sql$1.append(" comment ").append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{comment}))) : BoxedUnit.UNIT;
                return this.sql$1.append(",");
            }
            {
                this.sql$1 = sql$1;
            }
        });
        return sql.toString().substring(0, sql.length() - 1);
    }

    public StructField[] getFields(List<Map<String, Object>> columns) {
        return (StructField[])((TraversableOnce)columns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(Map<String, Object> column) {
                if (column.apply((Object)"name") == null) {
                    throw new IllegalArgumentException("When create a table, the field name must be defined(\u5efa\u7acb\u65b0\u8868\u65f6\uff0c\u5b57\u6bb5\u540d\u5fc5\u987b\u5b9a\u4e49)");
                }
                String name = (String)column.apply((Object)"name");
                String dataType = (String)column.getOrElse((Object)"type", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "string";
                    }
                });
                int precision = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryCatch((Function0)new Serializable(this, column){
                    public static final long serialVersionUID = 0L;
                    private final Map column$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.column$1.getOrElse((Object)"precision", (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 20;
                            }
                        }).toString())).toInt();
                    }
                    {
                        this.column$1 = column$1;
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Throwable x0$2) {
                        Throwable throwable = x0$2;
                        if (throwable instanceof Exception) {
                            int n = 20;
                            return n;
                        }
                        throw new MatchError((Object)throwable);
                    }
                }));
                int scale = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryCatch((Function0)new Serializable(this, column){
                    public static final long serialVersionUID = 0L;
                    private final Map column$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.column$1.getOrElse((Object)"scale", (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 4;
                            }
                        }).toString())).toInt();
                    }
                    {
                        this.column$1 = column$1;
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Throwable x0$3) {
                        Throwable throwable = x0$3;
                        if (throwable instanceof Exception) {
                            int n = 4;
                            return n;
                        }
                        throw new MatchError((Object)throwable);
                    }
                }));
                return new StructField(name, LoadData$.MODULE$.toDataType(dataType.toLowerCase(), precision, scale), true, StructField$.MODULE$.apply$default$4());
            }
        }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class));
    }

    public DataType toDataType(String dataType, int precision, int scale) {
        block14: {
            NullType$ nullType$;
            block3: {
                String string;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            string = dataType;
                                                            boolean bl = "void".equals(string) ? true : "null".equals(string);
                                                            if (!bl) break block2;
                                                            nullType$ = NullType$.MODULE$;
                                                            break block3;
                                                        }
                                                        boolean bl = "string".equals(string) ? true : ("char".equals(string) ? true : "varchar".equals(string));
                                                        if (!bl) break block4;
                                                        nullType$ = StringType$.MODULE$;
                                                        break block3;
                                                    }
                                                    if (!"boolean".equals(string)) break block5;
                                                    nullType$ = BooleanType$.MODULE$;
                                                    break block3;
                                                }
                                                if (!"short".equals(string)) break block6;
                                                nullType$ = ShortType$.MODULE$;
                                                break block3;
                                            }
                                            boolean bl = "int".equals(string) ? true : ("tinyint".equals(string) ? true : ("integer".equals(string) ? true : "smallint".equals(string)));
                                            if (!bl) break block7;
                                            nullType$ = IntegerType$.MODULE$;
                                            break block3;
                                        }
                                        boolean bl = "long".equals(string) ? true : "bigint".equals(string);
                                        if (!bl) break block8;
                                        nullType$ = LongType$.MODULE$;
                                        break block3;
                                    }
                                    if (!"float".equals(string)) break block9;
                                    nullType$ = FloatType$.MODULE$;
                                    break block3;
                                }
                                if (!"double".equals(string)) break block10;
                                nullType$ = DoubleType$.MODULE$;
                                break block3;
                            }
                            if (!"date".equals(string)) break block11;
                            nullType$ = DateType$.MODULE$;
                            break block3;
                        }
                        if (!"timestamp".equals(string)) break block12;
                        nullType$ = TimestampType$.MODULE$;
                        break block3;
                    }
                    if (!"binary".equals(string)) break block13;
                    nullType$ = BinaryType$.MODULE$;
                    break block3;
                }
                if (!"decimal".equals(string)) break block14;
                nullType$ = new DecimalType(precision, scale);
            }
            return nullType$;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unknown dataType ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    private LoadData$() {
        MODULE$ = this;
        this.formats = DefaultFormats$.MODULE$;
    }
}

