/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.executor;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.linkis.engineplugin.spark.exception.SparkEngineException;
import org.apache.linkis.engineplugin.spark.utils.EngineUtils$;
import org.apache.linkis.governance.common.exception.LinkisJobRetryException;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType$;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;

public final class SQLSession$
implements Logging {
    public static final SQLSession$ MODULE$;
    private final NumberFormat nf;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SQLSession$();
    }

    private Logger logger$lzycompute() {
        SQLSession$ sQLSession$ = this;
        synchronized (sQLSession$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    public NumberFormat nf() {
        return this.nf;
    }

    public void showDF(SparkContext sc, String jobGroup, Dataset<Row> dataFrame, String alias, int maxResult, EngineExecutionContext engineExecutionContext) {
        if (sc.isStopped()) {
            this.logger().error("Spark application has already stopped in showDF, please restart it.");
            throw new LinkisJobRetryException("Spark application sc has already stopped, please restart it.");
        }
        long startTime = System.currentTimeMillis();
        Iterator iterator = (Iterator)Utils$.MODULE$.tryThrow((Function0)new Serializable(dataFrame){
            public static final long serialVersionUID = 0L;
            private final Dataset dataFrame$1;

            public final Iterator<Row> apply() {
                return this.dataFrame$1.toLocalIterator();
            }
            {
                this.dataFrame$1 = dataFrame$1;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Throwable t) {
                throw new SparkEngineException(SparkErrorCodeSummary.DATAFRAME_EXCEPTION.getErrorCode(), SparkErrorCodeSummary.DATAFRAME_EXCEPTION.getErrorDesc(), t);
            }
        });
        HashSet colSet = new HashSet();
        StructType schema = dataFrame.schema();
        StructType columnsSet = null;
        schema.foreach((Function1)new Serializable(colSet){
            public static final long serialVersionUID = 0L;
            private final HashSet colSet$1;

            public final boolean apply(StructField s) {
                return this.colSet$1.add(s.name());
            }
            {
                this.colSet$1 = colSet$1;
            }
        });
        if (colSet.size() < schema.size()) {
            ArrayBuffer arr = new ArrayBuffer();
            HashSet tmpSet = new HashSet();
            ArrayBuffer tmpArr = new ArrayBuffer();
            dataFrame.queryExecution().analyzed().output().foreach((Function1)new Serializable(tmpSet, tmpArr){
                public static final long serialVersionUID = 0L;
                private final HashSet tmpSet$1;
                private final ArrayBuffer tmpArr$1;

                public final ArrayBuffer<StructField> apply(Attribute attri) {
                    StructField tempAttri = new StructField(attri.qualifiedName(), attri.dataType(), attri.nullable(), attri.metadata());
                    this.tmpSet$1.add(tempAttri);
                    return this.tmpArr$1.$plus$eq((Object)tempAttri);
                }
                {
                    this.tmpSet$1 = tmpSet$1;
                    this.tmpArr$1 = tmpArr$1;
                }
            });
            if (tmpSet.size() < schema.size()) {
                dataFrame.queryExecution().analyzed().output().foreach((Function1)new Serializable(arr){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer arr$1;

                    public final ArrayBuffer<StructField> apply(Attribute attri) {
                        StructField tempAttri = new StructField(attri.toString(), attri.dataType(), attri.nullable(), attri.metadata());
                        return this.arr$1.$plus$eq((Object)tempAttri);
                    }
                    {
                        this.arr$1 = arr$1;
                    }
                });
            } else {
                tmpArr.foreach((Function1)new Serializable(arr){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer arr$1;

                    public final ArrayBuffer<StructField> apply(StructField x$1) {
                        return this.arr$1.$plus$eq((Object)x$1);
                    }
                    {
                        this.arr$1 = arr$1;
                    }
                });
            }
            columnsSet = new StructType((StructField[])arr.toArray(ClassTag$.MODULE$.apply(StructField.class)));
        } else {
            columnsSet = schema;
        }
        Column[] columns = (Column[])((TraversableOnce)columnsSet.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(StructField c) {
                return new Column(c.name(), DataType$.MODULE$.toDataType(c.dataType().typeName().toLowerCase(Locale.getDefault())), (String)c.getComment().orNull(Predef$.MODULE$.$conforms()));
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
        Predef$.MODULE$.refArrayOps((Object[])columns).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Column c) {
                SQLSession$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c is ", ", comment is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.columnName(), c.comment()})));
            }
        });
        if (columns == null || Predef$.MODULE$.refArrayOps((Object[])columns).isEmpty()) {
            return;
        }
        TableMetaData metaData = new TableMetaData(columns);
        ResultSetWriter writer = StringUtils.isNotBlank((CharSequence)alias) ? engineExecutionContext.createResultSetWriter(ResultSetFactory$.MODULE$.TABLE_TYPE(), alias) : engineExecutionContext.createResultSetWriter(ResultSetFactory$.MODULE$.TABLE_TYPE());
        writer.addMetaData((MetaData)metaData);
        IntRef index = IntRef.create((int)0);
        Utils$.MODULE$.tryThrow((Function0)new Serializable(maxResult, iterator, columns, writer, index){
            public static final long serialVersionUID = 0L;
            private final int maxResult$1;
            private final Iterator iterator$1;
            private final Column[] columns$1;
            private final ResultSetWriter writer$1;
            private final IntRef index$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (this.index$1.elem < this.maxResult$1 && this.iterator$1.hasNext()) {
                    Row row = (Row)this.iterator$1.next();
                    Object[] r = (Object[])((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.columns$1).indices().map((Function1)new Serializable(this, row){
                        public static final long serialVersionUID = 0L;
                        private final Row row$1;

                        public final String apply(int i) {
                            return SQLSession$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveString(this.row$1.apply(i));
                        }
                        {
                            this.row$1 = row$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
                    this.writer$1.addRecord((Record)new TableRecord(r));
                    ++this.index$1.elem;
                }
            }
            {
                this.maxResult$1 = maxResult$1;
                this.iterator$1 = iterator$1;
                this.columns$1 = columns$1;
                this.writer$1 = writer$1;
                this.index$1 = index$1;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Throwable t) {
                throw new SparkEngineException(SparkErrorCodeSummary.READ_RECORD_EXCEPTION.getErrorCode(), SparkErrorCodeSummary.READ_RECORD_EXCEPTION.getErrorDesc(), t);
            }
        });
        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", ", Fetched ", " row(s)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)), BoxesRunTime.boxToInteger((int)index.elem)})));
        engineExecutionContext.appendStdout(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >> Time taken: ", ", Fetched ", " row(s)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EngineUtils$.MODULE$.getName(), BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)), BoxesRunTime.boxToInteger((int)index.elem)})));
        engineExecutionContext.sendResultSet(writer);
    }

    public String org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveString(Object value) {
        String string;
        Object object = value;
        if (object instanceof String) {
            String string2 = (String)object;
            string = string2.replaceAll("\n|\t", " ");
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            string = this.nf().format(d);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            string = this.formatDecimal(bigDecimal);
        } else if (object instanceof Object) {
            Object object2 = object;
            string = object2.toString();
        } else {
            string = null;
        }
        return string;
    }

    private String formatDecimal(BigDecimal d) {
        return d == null || d.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.toPlainString() : d.stripTrailingZeros().toPlainString();
    }

    public void showHTML(SparkContext sc, String jobGroup, Object htmlContent, EngineExecutionContext engineExecutionContext) {
        long startTime = System.currentTimeMillis();
        ResultSetWriter writer = engineExecutionContext.createResultSetWriter(ResultSetFactory$.MODULE$.HTML_TYPE());
        LineMetaData metaData = new LineMetaData(null);
        writer.addMetaData((MetaData)metaData);
        writer.addRecord((Record)new LineRecord(htmlContent.toString()));
        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))})));
        engineExecutionContext.sendResultSet(writer);
    }

    private SQLSession$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.nf = NumberFormat.getInstance();
        this.nf().setGroupingUsed(false);
        this.nf().setMaximumFractionDigits(BoxesRunTime.unboxToInt((Object)SparkConfiguration$.MODULE$.SPARK_NF_FRACTION_LENGTH().getValue()));
    }
}

