/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.client.deployment;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.spark.client.context.ExecutionContext;
import org.apache.linkis.engineplugin.spark.client.context.SparkConfig;
import org.apache.linkis.engineplugin.spark.client.deployment.ClusterDescriptorAdapter;
import org.apache.spark.launcher.CustomSparkSubmitLauncher;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;

public class YarnApplicationClusterDescriptorAdapter
extends ClusterDescriptorAdapter {
    public YarnApplicationClusterDescriptorAdapter(ExecutionContext executionContext) {
        super(executionContext);
    }

    @Override
    public void deployCluster(String mainClass, String args, Map<String, String> confMap) throws IOException {
        SparkConfig sparkConfig = this.executionContext.getSparkConfig();
        this.sparkLauncher = new CustomSparkSubmitLauncher();
        this.sparkLauncher.setJavaHome(sparkConfig.getJavaHome()).setSparkHome(sparkConfig.getSparkHome()).setMaster(sparkConfig.getMaster()).setDeployMode(sparkConfig.getDeployMode()).setAppName(sparkConfig.getAppName()).setVerbose(true);
        this.sparkLauncher.setConf("spark.app.name", sparkConfig.getAppName());
        if (confMap != null) {
            confMap.forEach((k, v) -> this.sparkLauncher.setConf((String)k, (String)v));
        }
        this.addSparkArg(this.sparkLauncher, "--jars", sparkConfig.getJars());
        this.addSparkArg(this.sparkLauncher, "--packages", sparkConfig.getPackages());
        this.addSparkArg(this.sparkLauncher, "--exclude-packages", sparkConfig.getExcludePackages());
        this.addSparkArg(this.sparkLauncher, "--repositories", sparkConfig.getRepositories());
        this.addSparkArg(this.sparkLauncher, "--files", sparkConfig.getFiles());
        this.addSparkArg(this.sparkLauncher, "--archives", sparkConfig.getArchives());
        this.addSparkArg(this.sparkLauncher, "--driver-memory", sparkConfig.getDriverMemory());
        this.addSparkArg(this.sparkLauncher, "--driver-java-options", sparkConfig.getDriverJavaOptions());
        this.addSparkArg(this.sparkLauncher, "--driver-library-path", sparkConfig.getDriverLibraryPath());
        this.addSparkArg(this.sparkLauncher, "--driver-class-path", sparkConfig.getDriverClassPath());
        this.addSparkArg(this.sparkLauncher, "--executor-memory", sparkConfig.getExecutorMemory());
        this.addSparkArg(this.sparkLauncher, "--proxy-user", sparkConfig.getProxyUser());
        this.addSparkArg(this.sparkLauncher, "--driver-cores", sparkConfig.getDriverCores().toString());
        this.addSparkArg(this.sparkLauncher, "--total-executor-cores", sparkConfig.getTotalExecutorCores());
        this.addSparkArg(this.sparkLauncher, "--executor-cores", sparkConfig.getExecutorCores().toString());
        this.addSparkArg(this.sparkLauncher, "--num-executors", sparkConfig.getNumExecutors().toString());
        this.addSparkArg(this.sparkLauncher, "--principal", sparkConfig.getPrincipal());
        this.addSparkArg(this.sparkLauncher, "--keytab", sparkConfig.getKeytab());
        this.addSparkArg(this.sparkLauncher, "--queue", sparkConfig.getQueue());
        this.sparkLauncher.setAppResource(sparkConfig.getAppResource());
        this.sparkLauncher.setMainClass(mainClass);
        Arrays.stream(args.split("\\s+")).filter(StringUtils::isNotBlank).forEach(arg -> this.sparkLauncher.addAppArgs(new String[]{arg}));
        this.sparkAppHandle = this.sparkLauncher.startApplication(new SparkAppHandle.Listener[]{new SparkAppHandle.Listener(){

            public void stateChanged(SparkAppHandle sparkAppHandle) {
                YarnApplicationClusterDescriptorAdapter.this.jobState = sparkAppHandle.getState();
                if (sparkAppHandle.getAppId() != null) {
                    ClusterDescriptorAdapter.logger.info("{} stateChanged: {}", (Object)sparkAppHandle.getAppId(), (Object)YarnApplicationClusterDescriptorAdapter.this.jobState.toString());
                } else {
                    ClusterDescriptorAdapter.logger.info("stateChanged: {}", (Object)YarnApplicationClusterDescriptorAdapter.this.jobState.toString());
                }
            }

            public void infoChanged(SparkAppHandle sparkAppHandle) {
            }
        }});
        this.sparkLauncher.setSparkAppHandle(this.sparkAppHandle);
    }

    private void addSparkArg(SparkLauncher sparkLauncher, String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            sparkLauncher.addSparkArg(key, value);
        }
    }

    @Override
    public boolean initJobId() {
        this.applicationId = this.sparkAppHandle.getAppId();
        return null != this.getApplicationId() || this.jobState != null && this.jobState.isFinal();
    }
}

