/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.executor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.computation.executor.utlis.ProgressUtils$;
import org.apache.linkis.engineconn.core.exception.ExecutorHookFatalException;
import org.apache.linkis.engineconn.executor.entity.ResourceFetchExecutor;
import org.apache.linkis.engineplugin.spark.common.Kind;
import org.apache.linkis.engineplugin.spark.common.Kind$;
import org.apache.linkis.engineplugin.spark.common.SparkDataCalc;
import org.apache.linkis.engineplugin.spark.cs.CSSparkHelper$;
import org.apache.linkis.engineplugin.spark.extension.SparkPostExecutionHook$;
import org.apache.linkis.engineplugin.spark.extension.SparkPreExecutionHook;
import org.apache.linkis.engineplugin.spark.extension.SparkPreExecutionHook$;
import org.apache.linkis.engineplugin.spark.utils.JobProgressUtil$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.exception.LinkisJobRetryException;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.apache.linkis.manager.common.protocol.resource.ResourceWithStatus;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.CodeLanguageLabel;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.spark.SparkContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-e!B\u0015+\u0003\u00039\u0004\u0002\u0003*\u0001\u0005\u000b\u0007I\u0011A*\t\u0011e\u0003!\u0011!Q\u0001\nQC\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\u0006C\u0002!\tA\u0019\u0005\bO\u0002\u0001\r\u0011\"\u0003i\u0011\u001da\u0007\u00011A\u0005\n5Daa\u001d\u0001!B\u0013I\u0007\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0003v\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0015\u0005%\u0001\u00011A\u0001B\u0003&a\u000fC\u0005\u0002\f\u0001\u0011\r\u0011\"\u0001\u0002\u000e!A\u0011q\u0005\u0001!\u0002\u0013\ty\u0001C\u0006\u0002*\u0001\u0001\r\u00111A\u0005\n\u0005-\u0002bCA\u001a\u0001\u0001\u0007\t\u0019!C\u0005\u0003kA1\"!\u000f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002.!I\u00111\b\u0001A\u0002\u0013%\u0011Q\b\u0005\n\u0003g\u0002\u0001\u0019!C\u0005\u0003kB\u0001\"a\u0019\u0001A\u0003&\u0011q\b\u0005\f\u0003\u0007\u0003\u0001\u0019!a\u0001\n\u0013\t)\tC\u0006\u0002\u0014\u0002\u0001\r\u00111A\u0005\n\u0005U\u0005bCAM\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000fCq!a'\u0001\t\u0003\ni\nC\u0004\u0002 \u0002!\t%!)\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u0011q\u001a\u0001\u0005B\u0005E\u0007bBAn\u0001\u0011\u0005\u0013Q\u001c\u0005\b\u0003S\u0004A\u0011IAv\u0011\u001d\u0011)\u0001\u0001C!\u0005\u000fAqA!\u0006\u0001\t\u0003\u00129\u0002C\u0004\u0003*\u0001!\tEa\u000b\t\u000f\t\u0005\u0003\u0001\"\u0011\u0003D!9!q\u000b\u0001\u0005B\te\u0003b\u0002B.\u0001\u0011\u0005#Q\f\u0005\b\u0005?\u0002A\u0011\tB1\u0011\u0019\u0011\u0019\u0007\u0001D\tk\"9!Q\r\u0001\u0007\u0012\t\u001d\u0004b\u0002B:\u0001\u0019E!Q\u000f\u0005\b\u0005\u0003\u0003A\u0011\tBB\u0011\u001d\u00119\t\u0001C\t\u0003;CqA!#\u0001\t\u0003\niJA\fTa\u0006\u00148.\u00128hS:,7i\u001c8o\u000bb,7-\u001e;pe*\u00111\u0006L\u0001\tKb,7-\u001e;pe*\u0011QFL\u0001\u0006gB\f'o\u001b\u0006\u0003_A\nA\"\u001a8hS:,\u0007\u000f\\;hS:T!!\r\u001a\u0002\r1Lgn[5t\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001O\"L!\tI\u0014)D\u0001;\u0015\tYD(A\u0004fq\u0016\u001cW\u000f^3\u000b\u0005-j$B\u0001 @\u0003-\u0019w.\u001c9vi\u0006$\u0018n\u001c8\u000b\u0005\u0001\u0003\u0014AC3oO&tWmY8o]&\u0011!I\u000f\u0002\u0014\u0007>l\u0007/\u001e;bi&|g.\u0012=fGV$xN\u001d\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000bQ!\u001e;jYNT!\u0001\u0013\u0019\u0002\r\r|W.\\8o\u0013\tQUIA\u0004M_\u001e<\u0017N\\4\u0011\u00051\u0003V\"A'\u000b\u00059{\u0015AB3oi&$\u0018P\u0003\u0002,\u007f%\u0011\u0011+\u0014\u0002\u0016%\u0016\u001cx.\u001e:dK\u001a+Go\u00195Fq\u0016\u001cW\u000f^8s\u0003\t\u00198-F\u0001U!\t)v+D\u0001W\u0015\ti#'\u0003\u0002Y-\na1\u000b]1sW\u000e{g\u000e^3yi\u0006\u00191o\u0019\u0011\u0002\u0005%$\u0007C\u0001/`\u001b\u0005i&\"\u00010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001l&\u0001\u0002'p]\u001e\fa\u0001P5oSRtDcA2fMB\u0011A\rA\u0007\u0002U!)!\u000b\u0002a\u0001)\")!\f\u0002a\u00017\u0006Y\u0011N\\5uS\u0006d\u0017N_3e+\u0005I\u0007C\u0001/k\u0013\tYWLA\u0004C_>dW-\u00198\u0002\u001f%t\u0017\u000e^5bY&TX\rZ0%KF$\"A\\9\u0011\u0005q{\u0017B\u00019^\u0005\u0011)f.\u001b;\t\u000fI4\u0011\u0011!a\u0001S\u0006\u0019\u0001\u0010J\u0019\u0002\u0019%t\u0017\u000e^5bY&TX\r\u001a\u0011\u0002\u0011)|'m\u0012:pkB,\u0012A\u001e\t\u0003ozt!\u0001\u001f?\u0011\u0005elV\"\u0001>\u000b\u0005m4\u0014A\u0002\u001fs_>$h(\u0003\u0002~;\u00061\u0001K]3eK\u001aL1a`A\u0001\u0005\u0019\u0019FO]5oO*\u0011Q0X\u0001\rU>\u0014wI]8va~#S-\u001d\u000b\u0004]\u0006\u001d\u0001b\u0002:\n\u0003\u0003\u0005\rA^\u0001\nU>\u0014wI]8va\u0002\n\u0001\"];feftU/\\\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002$5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u00033\tY\"\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\b\u0002 \u0005!Q\u000f^5m\u0015\t\t\t#\u0001\u0003kCZ\f\u0017\u0002BA\u0013\u0003'\u0011!\"\u0011;p[&\u001cGj\u001c8h\u0003%\tX/\u001a:z\u001dVl\u0007%\u0001\ff]\u001eLg.Z#yK\u000e,H/[8o\u0007>tG/\u001a=u+\t\ti\u0003E\u0002:\u0003_I1!!\r;\u0005Y)enZ5oK\u0016CXmY;uS>t7i\u001c8uKb$\u0018AG3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;`I\u0015\fHc\u00018\u00028!A!ODA\u0001\u0002\u0004\ti#A\ff]\u001eLg.Z#yK\u000e,H/[8o\u0007>tG/\u001a=uA\u0005qQ\r_3dkR|'\u000fT1cK2\u001cXCAA !\u0019\t\t%a\u0011\u0002H5\u0011\u00111D\u0005\u0005\u0003\u000b\nYB\u0001\u0003MSN$\b\u0007BA%\u0003?\u0002b!a\u0013\u0002X\u0005mSBAA'\u0015\rq\u0015q\n\u0006\u0005\u0003#\n\u0019&A\u0003mC\n,GNC\u0002\u0002VA\nq!\\1oC\u001e,'/\u0003\u0003\u0002Z\u00055#!\u0002'bE\u0016d\u0007\u0003BA/\u0003?b\u0001\u0001B\u0006\u0002bI\t\t\u0011!A\u0003\u0002\u0005\u0015$aA0%c\u0005yQ\r_3dkR|'\u000fT1cK2\u001c\b%\u0005\u0003\u0002h\u00055\u0004c\u0001/\u0002j%\u0019\u00111N/\u0003\u000f9{G\u000f[5oOB\u0019A,a\u001c\n\u0007\u0005ETLA\u0002B]f\f!#\u001a=fGV$xN\u001d'bE\u0016d7o\u0018\u0013fcR\u0019a.a\u001e\t\u0011I\f\u0012\u0011!a\u0001\u0003s\u0002b!!\u0011\u0002D\u0005m\u0004\u0007BA?\u0003\u0003\u0003b!a\u0013\u0002X\u0005}\u0004\u0003BA/\u0003\u0003#A\"!\u0019\u0002x\u0005\u0005\t\u0011!B\u0001\u0003K\na\u0001\u001e5sK\u0006$WCAAD!\u0011\tI)a$\u000e\u0005\u0005-%\u0002BAG\u0003?\tA\u0001\\1oO&!\u0011\u0011SAF\u0005\u0019!\u0006N]3bI\u0006QA\u000f\u001b:fC\u0012|F%Z9\u0015\u00079\f9\n\u0003\u0005s)\u0005\u0005\t\u0019AAD\u0003\u001d!\bN]3bI\u0002\nA!\u001b8jiR\ta.A\u0006fq\u0016\u001cW\u000f^3MS:,GCBAR\u0003g\u000b9\f\u0005\u0003\u0002&\u0006=VBAAT\u0015\u0011\tI+a+\u0002\u0011\u0015DXmY;uKJT1!!,1\u0003%\u00198\r[3ek2,'/\u0003\u0003\u00022\u0006\u001d&aD#yK\u000e,H/\u001a*fgB|gn]3\t\u000f\u0005Uv\u00031\u0001\u0002.\u0005)RM\\4j]\u0016,\u00050Z2vi>\u00148i\u001c8uKb$\bBBA]/\u0001\u0007a/\u0001\u0003d_\u0012,\u0017aC4fi\"{wn\u001b(b[\u0016$2A^A`\u0011\u001d\t\t\r\u0007a\u0001\u0003\u0007\f1\"\u001a=fGV$X\rS8pWB!\u0011QYAf\u001b\t\t9MC\u0002\u0002J2\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u00055\u0017q\u0019\u0002\u0016'B\f'o\u001b)sK\u0016CXmY;uS>t\u0007j\\8l\u0003E)\u00070Z2vi\u0016\u001cu.\u001c9mKR,G.\u001f\u000b\t\u0003G\u000b\u0019.!6\u0002X\"9\u0011QW\rA\u0002\u00055\u0002BBA]3\u0001\u0007a\u000f\u0003\u0004\u0002Zf\u0001\rA^\u0001\u000eG>l\u0007\u000f\\3uK\u0012d\u0015N\\3\u0002\u0011A\u0014xn\u001a:fgN$B!a8\u0002fB\u0019A,!9\n\u0007\u0005\rXLA\u0003GY>\fG\u000f\u0003\u0004\u0002hj\u0001\rA^\u0001\u0007i\u0006\u001c8.\u0013#\u0002\u001f\u001d,G\u000f\u0015:pOJ,7o]%oM>$B!!<\u0003\u0004A)A,a<\u0002t&\u0019\u0011\u0011_/\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005U\u0018q`\u0007\u0003\u0003oTA!!?\u0002|\u00061QM\\4j]\u0016T1!!@1\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B\u0001\u0003o\u0014qBS8c!J|wM]3tg&sgm\u001c\u0005\u0007\u0003O\\\u0002\u0019\u0001<\u0002#\u001d,G/\u0012=fGV$xN\u001d'bE\u0016d7\u000f\u0006\u0002\u0003\nA1\u0011\u0011IA\"\u0005\u0017\u0001DA!\u0004\u0003\u0012A1\u00111JA,\u0005\u001f\u0001B!!\u0018\u0003\u0012\u0011Y!1\u0003\u000f\u0002\u0002\u0003\u0005)\u0011AA3\u0005\ryFeM\u0001\u0012g\u0016$X\t_3dkR|'\u000fT1cK2\u001cHc\u00018\u0003\u001a!9!1D\u000fA\u0002\tu\u0011A\u00027bE\u0016d7\u000f\u0005\u0004\u0002B\u0005\r#q\u0004\u0019\u0005\u0005C\u0011)\u0003\u0005\u0004\u0002L\u0005]#1\u0005\t\u0005\u0003;\u0012)\u0003\u0002\u0007\u0003(\te\u0011\u0011!A\u0001\u0006\u0003\t)GA\u0002`IQ\nqC]3rk\u0016\u001cH/\u0012=qK\u000e$X\r\u001a*fg>,(oY3\u0015\t\t5\"Q\b\t\u0005\u0005_\u0011I$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003!\u0011Xm]8ve\u000e,'b\u0001(\u00038)\u0019\u0001*a\u0015\n\t\tm\"\u0011\u0007\u0002\r\u001d>$WMU3t_V\u00148-\u001a\u0005\b\u0005\u007fq\u0002\u0019\u0001B\u0017\u0003A)\u0007\u0010]3di\u0016$'+Z:pkJ\u001cW-A\u0007GKR\u001c\u0007NU3t_V\u00148-Z\u000b\u0003\u0005\u000b\u0002r!!\u0011\u0003HY\u0014Y%\u0003\u0003\u0003J\u0005m!a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0005\u001b\u0012\u0019&\u0004\u0002\u0003P)!!1\u0007B)\u0015\u0011\tiPa\u000e\n\t\tU#q\n\u0002\u0013%\u0016\u001cx.\u001e:dK^KG\u000f[*uCR,8/\u0001\fhKR\u001cUO\u001d:f]Rtu\u000eZ3SKN|WO]2f)\t\u0011i#A\ntkB\u0004xN\u001d;DC2d')Y2l\u0019><7\u000fF\u0001j\u0003\u00159W\r^%e)\u00051\u0018aE4fi\u0016CXmY;u_JLE\r\u0015:f\r&D\u0018aB4fi.Kg\u000eZ\u000b\u0003\u0005S\u0002BAa\u001b\u0003p5\u0011!Q\u000e\u0006\u0003\u00112JAA!\u001d\u0003n\t!1*\u001b8e\u0003\u001d\u0011XO\\\"pI\u0016$\"\"a)\u0003x\te$1\u0010B@\u0011\u0015YS\u00051\u0001d\u0011\u0019\tI,\na\u0001m\"9!QP\u0013A\u0002\u00055\u0012aB2p]R,\u0007\u0010\u001e\u0005\u0006i\u0016\u0002\rA^\u0001\tW&dG\u000eV1tWR\u0019aN!\"\t\r\u0005\u001dh\u00051\u0001w\u0003=Y\u0017\u000e\u001c7Sk:t\u0017N\\4UCN\\\u0017!B2m_N,\u0007")
public abstract class SparkEngineConnExecutor
extends ComputationExecutor
implements ResourceFetchExecutor {
    private final SparkContext sc;
    private final long id;
    private boolean initialized;
    private String jobGroup;
    private final AtomicLong queryNum;
    private EngineExecutionContext engineExecutionContext;
    private List<Label<?>> executorLabels;
    private Thread thread;

    public SparkContext sc() {
        return this.sc;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private String jobGroup() {
        return this.jobGroup;
    }

    private void jobGroup_$eq(String x$1) {
        this.jobGroup = x$1;
    }

    public AtomicLong queryNum() {
        return this.queryNum;
    }

    private EngineExecutionContext engineExecutionContext() {
        return this.engineExecutionContext;
    }

    private void engineExecutionContext_$eq(EngineExecutionContext x$1) {
        this.engineExecutionContext = x$1;
    }

    private List<Label<?>> executorLabels() {
        return this.executorLabels;
    }

    private void executorLabels_$eq(List<Label<?>> x$1) {
        this.executorLabels = x$1;
    }

    private Thread thread() {
        return this.thread;
    }

    private void thread_$eq(Thread x$1) {
        this.thread = x$1;
    }

    public void init() {
        this.logger().info("Ready to change engine state!");
        super.init();
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutorContext, String code) {
        return (ExecuteResponse)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
            this.engineExecutionContext_$eq(engineExecutorContext);
            this.thread_$eq(Thread.currentThread());
            if (this.sc().isStopped()) {
                this.logger().error("Spark application has already stopped, please restart it.");
                this.transition(NodeStatus.Failed);
                throw new LinkisJobRetryException("Spark application sc has already stopped, please restart it.");
            }
            Kind kind = this.getKind();
            ObjectRef preCode = ObjectRef.create((Object)code);
            engineExecutorContext.appendStdout(LogUtils$.MODULE$.generateInfo(new StringBuilder(21).append("yarn application id: ").append(this.sc().applicationId()).toString()));
            ObjectRef executionHook = ObjectRef.create(null);
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkPreExecutionHook$.MODULE$.getSparkPreExecutionHooks())).foreach((Function1 & Serializable & scala.Serializable)hook -> {
                SparkEngineConnExecutor.$anonfun$executeLine$3(executionHook, preCode, engineExecutorContext, hook);
                return BoxedUnit.UNIT;
            }), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                SparkEngineConnExecutor.$anonfun$executeLine$4(this, executionHook, x0$1);
                return BoxedUnit.UNIT;
            });
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CSSparkHelper$.MODULE$.setContextIDInfoToSparkConf(engineExecutorContext, this.sc()), this.logger());
            Kind kind2 = kind;
            String _code = kind2 instanceof SparkDataCalc ? (String)preCode.elem : Kind$.MODULE$.getRealCode((String)preCode.elem);
            this.logger().info(new StringBuilder(29).append("Ready to run code with kind ").append(kind).append(".").toString());
            String jobId = JobUtils$.MODULE$.getJobIdFromMap(engineExecutorContext.getProperties());
            String jobGroupId = StringUtils.isNotBlank((CharSequence)jobId) ? jobId : BoxesRunTime.boxToLong((long)this.queryNum().incrementAndGet());
            this.jobGroup_$eq(String.valueOf(new StringBuilder(22).append("linkis-spark-mix-code-").append((Object)jobGroupId).toString()));
            this.logger().info(new StringBuilder(16).append("Set jobGroup to ").append(this.jobGroup()).toString());
            this.sc().setJobGroup(this.jobGroup(), _code, true);
            ExecuteResponse response = (ExecuteResponse)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> this.runCode(this, _code, engineExecutorContext, this.jobGroup()), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.jobGroup_$eq(null);
                this.sc().clearJobGroup();
            });
            Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkPostExecutionHook$.MODULE$.getSparkPostExecutionHooks())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.callPostExecutionHook(engineExecutorContext, response, code);
                return BoxedUnit.UNIT;
            }));
            return response;
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.engineExecutionContext_$eq(null));
    }

    private String getHookName(SparkPreExecutionHook executeHook) {
        if (executeHook == null) {
            return "empty hook";
        }
        return executeHook.getClass().getName();
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutorContext, String code, String completedLine) {
        String newcode = new StringBuilder(0).append(completedLine).append(code).toString();
        this.logger().info(new StringBuilder(11).append("newcode is ").append(newcode).toString());
        return this.executeLine(engineExecutorContext, newcode);
    }

    public float progress(String taskID) {
        float oldProgress;
        if (this.jobGroup() == null || this.engineExecutionContext().getTotalParagraph() == 0) {
            return ProgressUtils$.MODULE$.getOldProgress(this.engineExecutionContext());
        }
        float newProgress = ((float)this.engineExecutionContext().getCurrentParagraph() * 1.0f - 1.0f) / (float)this.engineExecutionContext().getTotalParagraph() + JobProgressUtil$.MODULE$.progress(this.sc(), this.jobGroup()) / (float)this.engineExecutionContext().getTotalParagraph();
        float normalizedProgress = newProgress >= 1.0f ? GovernanceCommonConf$.MODULE$.FAKE_PROGRESS() : newProgress;
        if (normalizedProgress < (oldProgress = ProgressUtils$.MODULE$.getOldProgress(this.engineExecutionContext()))) {
            return oldProgress;
        }
        ProgressUtils$.MODULE$.putProgress(normalizedProgress, this.engineExecutionContext());
        return normalizedProgress;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        if (this.jobGroup() == null) {
            return (JobProgressInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(JobProgressInfo.class));
        }
        this.logger().debug(new StringBuilder(42).append("request new progress info for jobGroup is ").append(this.jobGroup()).toString());
        ArrayBuffer progressInfoArray = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        progressInfoArray.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])JobProgressUtil$.MODULE$.getActiveJobProgressInfo(this.sc(), this.jobGroup()))));
        progressInfoArray.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])JobProgressUtil$.MODULE$.getCompletedJobProgressInfo(this.sc(), this.jobGroup()))));
        return (JobProgressInfo[])progressInfoArray.toArray(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels();
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        this.executorLabels_$eq(labels);
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public HashMap<String, ResourceWithStatus> FetchResource() {
        HashMap<String, ResourceWithStatus> resourceMap = new HashMap<String, ResourceWithStatus>();
        JobProgressInfo[] activeJobs = JobProgressUtil$.MODULE$.getActiveJobProgressInfo(this.sc(), this.jobGroup());
        String applicationStatus = activeJobs == null || activeJobs.length == 0 ? "RUNNING" : "COMPLETED";
        Resource resource = this.getCurrentNodeResource().getUsedResource();
        if (resource instanceof DriverAndYarnResource) {
            DriverAndYarnResource driverAndYarnResource = (DriverAndYarnResource)resource;
            resourceMap.put(this.sc().applicationId(), new ResourceWithStatus(driverAndYarnResource.getYarnResource().getQueueMemory(), driverAndYarnResource.getYarnResource().getQueueCores(), driverAndYarnResource.getYarnResource().getQueueInstances(), applicationStatus, driverAndYarnResource.getYarnResource().getQueueName()));
        } else {
            resourceMap.put(this.sc().applicationId(), new ResourceWithStatus(0L, 0, 0, "UNKNOWN", "UNKNOWN"));
        }
        return resourceMap;
    }

    public NodeResource getCurrentNodeResource() {
        this.logger().info("Begin to get actual used resources!");
        return (NodeResource)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            int executorNum = new StringOps(Predef$.MODULE$.augmentString(this.sc().getConf().get("spark.executor.instances"))).toInt();
            long executorMem = ByteTimeUtils.byteStringAsBytes((String)this.sc().getConf().get("spark.executor.memory")) * (long)executorNum;
            long driverMem = ByteTimeUtils.byteStringAsBytes((String)this.sc().getConf().get("spark.driver.memory"));
            int sparkExecutorCores = new StringOps(Predef$.MODULE$.augmentString(this.sc().getConf().get("spark.executor.cores", "2"))).toInt() * executorNum;
            int sparkDriverCores = new StringOps(Predef$.MODULE$.augmentString(this.sc().getConf().get("spark.driver.cores", "1"))).toInt();
            String queue = this.sc().getConf().get("spark.yarn.queue");
            this.logger().info(new StringBuilder(91).append("Current actual used resources is driverMem:").append(driverMem).append(",driverCores:").append(sparkDriverCores).append(",executorMem:").append(executorMem).append(",executorCores:").append(sparkExecutorCores).append(",queue:").append(queue).toString());
            DriverAndYarnResource uesdResource = new DriverAndYarnResource(new LoadInstanceResource(driverMem, sparkDriverCores, 1), new YarnResource(executorMem, sparkExecutorCores, 0, queue, this.sc().applicationId()));
            CommonNodeResource nodeResource = new CommonNodeResource();
            nodeResource.setUsedResource((Resource)uesdResource);
            return nodeResource;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            this.logger().warn("Get actual used resource exception", t);
            return null;
        });
    }

    public boolean supportCallBackLogs() {
        return true;
    }

    public String getId() {
        return new StringBuilder(0).append(this.getExecutorIdPreFix()).append(this.id).toString();
    }

    public abstract String getExecutorIdPreFix();

    public abstract Kind getKind();

    public abstract ExecuteResponse runCode(SparkEngineConnExecutor var1, String var2, EngineExecutionContext var3, String var4);

    public void killTask(String taskID) {
        if (!this.sc().isStopped()) {
            this.sc().cancelAllJobs();
            Object object = this.thread() != null ? Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.thread().interrupt(), this.logger()) : BoxedUnit.UNIT;
            this.killRunningTask();
        }
        super.killTask(taskID);
    }

    public void killRunningTask() {
        ObjectRef runType = ObjectRef.create((Object)"");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getExecutorLabels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)l -> {
            SparkEngineConnExecutor.$anonfun$killRunningTask$1(runType, l);
            return BoxedUnit.UNIT;
        });
        this.logger().warn(new StringBuilder(22).append("Kill running job of ").append((String)runType.elem).append(" .").toString());
    }

    public void close() {
        super.close();
    }

    public static final /* synthetic */ void $anonfun$executeLine$3(ObjectRef executionHook$1, ObjectRef preCode$1, EngineExecutionContext engineExecutorContext$1, SparkPreExecutionHook hook) {
        executionHook$1.elem = hook;
        preCode$1.elem = hook.callPreExecutionHook(engineExecutorContext$1, (String)preCode$1.elem);
    }

    public static final /* synthetic */ void $anonfun$executeLine$4(SparkEngineConnExecutor $this, ObjectRef executionHook$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof ExecutorHookFatalException) {
            ExecutorHookFatalException executorHookFatalException = (ExecutorHookFatalException)throwable;
            String hookName = $this.getHookName((SparkPreExecutionHook)executionHook$1.elem);
            $this.logger().error(new StringBuilder(36).append("execute preExecution hook : ").append(hookName).append(" failed.").toString());
            throw executorHookFatalException;
        }
        if (throwable instanceof Exception) {
            String hookName = $this.getHookName((SparkPreExecutionHook)executionHook$1.elem);
            $this.logger().error(new StringBuilder(36).append("execute preExecution hook : ").append(hookName).append(" failed.").toString());
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$killRunningTask$1(ObjectRef runType$1, Label l) {
        Label label = l;
        if (label instanceof CodeLanguageLabel) {
            CodeLanguageLabel codeLanguageLabel = (CodeLanguageLabel)label;
            runType$1.elem = codeLanguageLabel.getCodeType();
            return;
        }
    }

    public SparkEngineConnExecutor(SparkContext sc, long id) {
        this.sc = sc;
        this.id = id;
        super(ComputationExecutor$.MODULE$.$lessinit$greater$default$1());
        this.initialized = false;
        this.queryNum = new AtomicLong(0L);
        this.executorLabels = new ArrayList();
    }
}

