/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.executor;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineplugin.spark.common.Kind;
import org.apache.linkis.engineplugin.spark.common.SparkSQL;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.entity.SparkEngineSession;
import org.apache.linkis.engineplugin.spark.executor.SQLSession$;
import org.apache.linkis.engineplugin.spark.executor.SparkEngineConnExecutor;
import org.apache.linkis.engineplugin.spark.extension.SparkSqlExtension;
import org.apache.linkis.engineplugin.spark.extension.SparkSqlExtension$;
import org.apache.linkis.engineplugin.spark.utils.EngineUtils$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.SQLCodeParser;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00114A\u0001C\u0005\u0001-!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0011\u0015I\u0003\u0001\"\u0001+\u0011\u0015q\u0003\u0001\"\u00110\u0011\u0015\u0019\u0004\u0001\"\u00155\u0011\u0015Y\u0004\u0001\"\u0015=\u0011\u0015\u0011\u0007\u0001\"\u0015d\u0005A\u0019\u0006/\u0019:l'FdW\t_3dkR|'O\u0003\u0002\u000b\u0017\u0005AQ\r_3dkR|'O\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\rK:<\u0017N\\3qYV<\u0017N\u001c\u0006\u0003!E\ta\u0001\\5oW&\u001c(B\u0001\n\u0014\u0003\u0019\t\u0007/Y2iK*\tA#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001$G\u0007\u0002\u0013%\u0011!$\u0003\u0002\u0018'B\f'o[#oO&tWmQ8o]\u0016CXmY;u_J\f!c\u001d9be.,enZ5oKN+7o]5p]B\u0011Q\u0004I\u0007\u0002=)\u0011qdC\u0001\u0007K:$\u0018\u000e^=\n\u0005\u0005r\"AE*qCJ\\WI\\4j]\u0016\u001cVm]:j_:\f!!\u001b3\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007-bS\u0006\u0005\u0002\u0019\u0001!)1d\u0001a\u00019!)!e\u0001a\u0001G\u0005!\u0011N\\5u)\u0005\u0001\u0004C\u0001\u00132\u0013\t\u0011TE\u0001\u0003V]&$\u0018aB4fi.Kg\u000eZ\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001hC\u0001\u0007G>lWn\u001c8\n\u0005i:$\u0001B&j]\u0012\fqA];o\u0007>$W\rF\u0003>\u000b\u001a\u001b\u0006\r\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006AQ\r_3dkR,'O\u0003\u0002C\u001f\u0005I1o\u00195fIVdWM]\u0005\u0003\t~\u0012q\"\u0012=fGV$XMU3ta>t7/\u001a\u0005\u0006\u0015\u0019\u0001\ra\u0006\u0005\u0006\u000f\u001a\u0001\r\u0001S\u0001\u0005G>$W\r\u0005\u0002J!:\u0011!J\u0014\t\u0003\u0017\u0016j\u0011\u0001\u0014\u0006\u0003\u001bV\ta\u0001\u0010:p_Rt\u0014BA(&\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011K\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=+\u0003\"\u0002+\u0007\u0001\u0004)\u0016AF3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005YsV\"A,\u000b\u0005aK\u0016aB3yK\u000e,H/\u001a\u0006\u0003\u0015iS!a\u0017/\u0002\u0017\r|W\u000e];uCRLwN\u001c\u0006\u0003;>\t!\"\u001a8hS:,7m\u001c8o\u0013\tyvK\u0001\fF]\u001eLg.Z#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015\tg\u00011\u0001I\u0003!QwNY$s_V\u0004\u0018aE4fi\u0016CXmY;u_JLE\r\u0015:f\r&DX#\u0001%")
public class SparkSqlExecutor
extends SparkEngineConnExecutor {
    private final SparkEngineSession sparkEngineSession;

    @Override
    public void init() {
        this.setCodeParser((CodeParser)new SQLCodeParser());
        super.init();
        this.logger().info("spark sql executor start");
    }

    @Override
    public Kind getKind() {
        return new SparkSQL();
    }

    @Override
    public ExecuteResponse runCode(SparkEngineConnExecutor executor, String code, EngineExecutionContext engineExecutionContext, String jobGroup) {
        ErrorExecuteResponse errorExecuteResponse;
        this.logger().info(new StringBuilder(23).append("SQLExecutor run query: ").append(code).toString());
        engineExecutionContext.appendStdout(new StringBuilder(4).append(EngineUtils$.MODULE$.getName()).append(" >> ").append(code).toString());
        ClassLoader standInClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                long sqlStartTime = System.currentTimeMillis();
                Thread.currentThread().setContextClassLoader((ClassLoader)this.sparkEngineSession.sparkSession().sharedState().jarClassLoader());
                SparkSqlExtension[] extensions = SparkSqlExtension$.MODULE$.getSparkSqlExtensions();
                Dataset df = this.sparkEngineSession.sqlContext().sql(code);
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])extensions)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.afterExecutingSQL(this.sparkEngineSession.sqlContext(), code, (Dataset<Row>)df, BoxesRunTime.unboxToLong((Object)SparkConfiguration$.MODULE$.SQL_EXTENSION_TIMEOUT().getValue()), sqlStartTime);
                    return BoxedUnit.UNIT;
                }));
                SQLSession$.MODULE$.showDF(this.sparkEngineSession.sparkContext(), jobGroup, (Dataset<Row>)df, null, BoxesRunTime.unboxToInt((Object)SparkConfiguration$.MODULE$.SHOW_DF_MAX_RES().getValue()), engineExecutionContext);
                errorExecuteResponse = new SuccessExecuteResponse();
            }
            catch (InvocationTargetException e) {
                Throwable cause = ExceptionUtils.getCause((Throwable)e);
                if (cause == null) {
                    cause = e;
                }
                errorExecuteResponse = new ErrorExecuteResponse(ExceptionUtils.getRootCauseMessage((Throwable)e), cause);
            }
            catch (Exception ite) {
                errorExecuteResponse = new ErrorExecuteResponse(ExceptionUtils.getRootCauseMessage((Throwable)ite), (Throwable)ite);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(standInClassLoader);
        }
        return errorExecuteResponse;
    }

    @Override
    public String getExecutorIdPreFix() {
        return "SparkSqlExecutor_";
    }

    public SparkSqlExecutor(SparkEngineSession sparkEngineSession, long id) {
        this.sparkEngineSession = sparkEngineSession;
        super(sparkEngineSession.sparkContext(), id);
    }
}

