/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.factory;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.utils.JsonUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.common.engineconn.EngineConn;
import org.apache.linkis.engineconn.launch.EngineConnServer$;
import org.apache.linkis.engineplugin.spark.client.context.ExecutionContext;
import org.apache.linkis.engineplugin.spark.client.context.SparkConfig;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.config.SparkResourceConfiguration$;
import org.apache.linkis.engineplugin.spark.context.EnvironmentContext;
import org.apache.linkis.engineplugin.spark.context.SparkEngineConnContext;
import org.apache.linkis.engineplugin.spark.entity.SparkEngineSession;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.linkis.engineplugin.spark.exception.SparkCreateFileException;
import org.apache.linkis.engineplugin.spark.exception.SparkSessionNullException;
import org.apache.linkis.engineplugin.spark.factory.SparkDataCalcExecutorFactory;
import org.apache.linkis.engineplugin.spark.factory.SparkOnceExecutorFactory;
import org.apache.linkis.engineplugin.spark.factory.SparkPythonExecutorFactory;
import org.apache.linkis.engineplugin.spark.factory.SparkScalaExecutorFactory;
import org.apache.linkis.engineplugin.spark.factory.SparkSqlExecutorFactory;
import org.apache.linkis.manager.engineplugin.common.conf.EnvConfiguration$;
import org.apache.linkis.manager.engineplugin.common.creation.AbstractEngineConnFactory;
import org.apache.linkis.manager.engineplugin.common.creation.ExecutorFactory;
import org.apache.linkis.manager.engineplugin.common.creation.MultiExecutorEngineConnFactory;
import org.apache.linkis.manager.engineplugin.common.launch.process.Environment$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineConnModeLabel;
import org.apache.linkis.manager.label.entity.engine.EngineType$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.SparkUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\t\u0013\u0001}AQ\u0001\u000f\u0001\u0005\u0002eBQ\u0001\u0010\u0001\u0005RuBQa\u0013\u0001\u0005\u00021CQ\u0001\u0016\u0001\u0005\u0012UCQA\u0017\u0001\u0005\u0002mCQ\u0001\u001f\u0001\u0005\u0002eDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u0013\u0005-\u0003!%A\u0005\u0002\u00055\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\t)\u000b\u0001C)\u0003OCq!a2\u0001\t#\nI\rC\u0005\u0002t\u0002\u0011\r\u0011\"\u0003\u0002v\"A\u0011Q \u0001!\u0002\u0013\t9\u0010C\u0004\u0002\u0000\u0002!\t%!>\u0003-M\u0003\u0018M]6F]\u001eLg.Z\"p]:4\u0015m\u0019;pefT!a\u0005\u000b\u0002\u000f\u0019\f7\r^8ss*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\tA\"\u001a8hS:,\u0007\u000f\\;hS:T!!\u0007\u000e\u0002\r1Lgn[5t\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\t\u00142!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fMB\u0011qeL\u0007\u0002Q)\u0011\u0011FK\u0001\tGJ,\u0017\r^5p]*\u00111\u0006L\u0001\u0007G>lWn\u001c8\u000b\u0005]i#B\u0001\u0018\u0019\u0003\u001di\u0017M\\1hKJL!\u0001\r\u0015\u0003=5+H\u000e^5Fq\u0016\u001cW\u000f^8s\u000b:<\u0017N\\3D_:tg)Y2u_JL\bC\u0001\u001a7\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0015)H/\u001b7t\u0015\tY\u0003$\u0003\u00028g\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001;!\tY\u0004!D\u0001\u0013\u0003]\u0019'/Z1uK\u0016sw-\u001b8f\u0007>tgnU3tg&|g\u000e\u0006\u0002?\u0003B\u0011\u0011eP\u0005\u0003\u0001\n\u00121!\u00118z\u0011\u0015\u0011%\u00011\u0001D\u0003U)gnZ5oK\u000e\u0013X-\u0019;j_:\u001cuN\u001c;fqR\u0004\"\u0001R%\u000e\u0003\u0015S!!\u000b$\u000b\u0005-:%B\u0001%\u0019\u0003))gnZ5oK\u000e|gN\\\u0005\u0003\u0015\u0016\u0013Q#\u00128hS:,7I]3bi&|gnQ8oi\u0016DH/\u0001\u0011de\u0016\fG/Z*qCJ\\wJ\\2f\u000b:<\u0017N\\3D_:t7i\u001c8uKb$HCA'T!\tq\u0015+D\u0001P\u0015\t\u0001F#A\u0004d_:$X\r\u001f;\n\u0005I{%AF*qCJ\\WI\\4j]\u0016\u001cuN\u001c8D_:$X\r\u001f;\t\u000b\t\u001b\u0001\u0019A\"\u00021\r\u0014X-\u0019;f\u000b:4\u0018N]8o[\u0016tGoQ8oi\u0016DH\u000f\u0006\u0002W3B\u0011ajV\u0005\u00031>\u0013!#\u00128wSJ|g.\\3oi\u000e{g\u000e^3yi\")!\t\u0002a\u0001\u0007\u0006qq-\u001a;Ta\u0006\u00148nQ8oM&<GC\u0001/d!\ti\u0016-D\u0001_\u0015\t\u0001vL\u0003\u0002a)\u000511\r\\5f]RL!A\u00190\u0003\u0017M\u0003\u0018M]6D_:4\u0017n\u001a\u0005\u0006I\u0016\u0001\r!Z\u0001\b_B$\u0018n\u001c8t!\u001117.\\7\u000e\u0003\u001dT!\u0001[5\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0006!!.\u0019<b\u0013\tawMA\u0002NCB\u0004\"A\\;\u000f\u0005=\u001c\bC\u00019#\u001b\u0005\t(B\u0001:\u001f\u0003\u0019a$o\\8u}%\u0011AOI\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002uE\u000512M]3bi\u0016,\u00050Z2vi&|gnQ8oi\u0016DH\u000fF\u0002{{z\u0004\"!X>\n\u0005qt&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015!g\u00011\u0001f\u0011\u0015yh\u00011\u0001W\u0003I)gN^5s_:lWM\u001c;D_:$X\r\u001f;\u00021\r\u0014X-\u0019;f'B\f'o[#oO&tWmU3tg&|g\u000e\u0006\u0003\u0002\u0006\u0005E\u0001\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-A#\u0001\u0004f]RLG/_\u0005\u0005\u0003\u001f\tIA\u0001\nTa\u0006\u00148.\u00128hS:,7+Z:tS>t\u0007\"\u0002\"\b\u0001\u0004\u0019\u0015AE2sK\u0006$Xm\u00159be.\u001cVm]:j_:$\u0002\"a\u0006\u0002&\u0005U\u0012\u0011\t\t\u0005\u00033\t\t#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+iIA!a\t\u0002\u001c\ta1\u000b]1sWN+7o]5p]\"9\u0011q\u0005\u0005A\u0002\u0005%\u0012!C8viB,H\u000fR5s!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018S\u0006\u0011\u0011n\\\u0005\u0005\u0003g\tiC\u0001\u0003GS2,\u0007bBA\u001c\u0011\u0001\u0007\u0011\u0011H\u0001\u0005G>tg\r\u0005\u0003\u0002<\u0005uRBAA\u0010\u0013\u0011\ty$a\b\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"CA\"\u0011A\u0005\t\u0019AA#\u0003A\tG\r\u001a)zi\"|gnU;qa>\u0014H\u000fE\u0002\"\u0003\u000fJ1!!\u0013#\u0005\u001d\u0011un\u001c7fC:\fAd\u0019:fCR,7\u000b]1sWN+7o]5p]\u0012\"WMZ1vYR$3'\u0006\u0002\u0002P)\"\u0011QIA)W\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA/E\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0014q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E2sK\u0006$XmU)M\u0007>tG/\u001a=u)!\t9'!\u001c\u0002x\u0005m\u0005\u0003BA\r\u0003SJA!a\u001b\u0002\u001c\tQ1+\u0015'D_:$X\r\u001f;\t\u000f\u0005=$\u00021\u0001\u0002r\u0005\u00111o\u0019\t\u0005\u0003w\t\u0019(\u0003\u0003\u0002v\u0005}!\u0001D*qCJ\\7i\u001c8uKb$\bB\u00023\u000b\u0001\u0004\tI\b\u0005\u0004\u0002|\u0005UU.\u001c\b\u0005\u0003{\nyI\u0004\u0003\u0002\u0000\u0005-e\u0002BAA\u0003\u0013sA!a!\u0002\b:\u0019\u0001/!\"\n\u0003uI!a\u0007\u000f\n\u0005eQ\u0012bAAG1\u000511/\u001a:wKJLA!!%\u0002\u0014\u00069\u0001/Y2lC\u001e,'bAAG1%!\u0011qSAM\u0005\u0011QU*\u00199\u000b\t\u0005E\u00151\u0013\u0005\b\u0003;S\u0001\u0019AA\f\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o\u0003=\u0019'/Z1uK>+H\u000f];u\t&\u0014H\u0003BA\u0015\u0003GCq!a\u000e\f\u0001\u0004\tI$\u0001\u0010hKR$UMZ1vYR,\u00050Z2vi>\u0014h)Y2u_JL8\t\\1tgV\u0011\u0011\u0011\u0016\u0019\u0005\u0003W\u000b)\fE\u0003o\u0003[\u000b\t,C\u0002\u00020^\u0014Qa\u00117bgN\u0004B!a-\u000262\u0001AaCA\\\u0019\u0005\u0005\t\u0011!B\u0001\u0003s\u00131a\u0018\u00133#\u0011\tY,!1\u0011\u0007\u0005\ni,C\u0002\u0002@\n\u0012qAT8uQ&tw\rE\u0002(\u0003\u0007L1!!2)\u0005=)\u00050Z2vi>\u0014h)Y2u_JL\u0018!E4fi\u0016sw-\u001b8f\u0007>tg\u000eV=qKV\u0011\u00111\u001a\t\u0005\u0003\u001b\fiO\u0004\u0003\u0002P\u0006\u001dh\u0002BAi\u0003CtA!a5\u0002^:!\u0011Q[Am\u001d\u0011\ty(a6\n\u00059B\u0012bAAn[\u0005)A.\u00192fY&!\u00111BAp\u0015\r\tY.L\u0005\u0005\u0003G\f)/\u0001\u0004f]\u001eLg.\u001a\u0006\u0005\u0003\u0017\ty.\u0003\u0003\u0002j\u0006-\u0018AC#oO&tW\rV=qK*!\u00111]As\u0013\u0011\ty/!=\u0003\u0015\u0015sw-\u001b8f)f\u0004XM\u0003\u0003\u0002j\u0006-\u0018\u0001F3yK\u000e,Ho\u001c:GC\u000e$xN]=BeJ\f\u00170\u0006\u0002\u0002xB)\u0011%!?\u0002B&\u0019\u00111 \u0012\u0003\u000b\u0005\u0013(/Y=\u0002+\u0015DXmY;u_J4\u0015m\u0019;pef\f%O]1zA\u0005!r-\u001a;Fq\u0016\u001cW\u000f^8s\r\u0006\u001cGo\u001c:jKN\u0004")
public class SparkEngineConnFactory
implements MultiExecutorEngineConnFactory {
    private final ExecutorFactory[] executorFactoryArray;
    private Logger logger;
    private volatile boolean bitmap$0;

    public ExecutorFactory getDefaultExecutorFactory() {
        return MultiExecutorEngineConnFactory.getDefaultExecutorFactory$((MultiExecutorEngineConnFactory)this);
    }

    public EngineConnModeLabel getEngineConnModeLabel(List<Label<?>> labels) {
        return MultiExecutorEngineConnFactory.getEngineConnModeLabel$((MultiExecutorEngineConnFactory)this, labels);
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    public EngineConn createEngineConn(EngineCreationContext engineCreationContext) {
        return AbstractEngineConnFactory.createEngineConn$((AbstractEngineConnFactory)this, (EngineCreationContext)engineCreationContext);
    }

    private Logger logger$lzycompute() {
        SparkEngineConnFactory sparkEngineConnFactory = this;
        synchronized (sparkEngineConnFactory) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Object createEngineConnSession(EngineCreationContext engineCreationContext) {
        if (EngineConnServer$.MODULE$.isOnceMode()) {
            return this.createSparkOnceEngineConnContext(engineCreationContext);
        }
        return this.createSparkEngineSession(engineCreationContext);
    }

    public SparkEngineConnContext createSparkOnceEngineConnContext(EngineCreationContext engineCreationContext) {
        EnvironmentContext environmentContext = this.createEnvironmentContext(engineCreationContext);
        SparkEngineConnContext sparkEngineConnContext = new SparkEngineConnContext(environmentContext);
        ExecutionContext executionContext = this.createExecutionContext(engineCreationContext.getOptions(), environmentContext);
        sparkEngineConnContext.setExecutionContext(executionContext);
        return sparkEngineConnContext;
    }

    public EnvironmentContext createEnvironmentContext(EngineCreationContext engineCreationContext) {
        Map options = engineCreationContext.getOptions();
        String hadoopConfDir = (String)EnvConfiguration$.MODULE$.HADOOP_CONF_DIR().getValue(options);
        String sparkHome = (String)SparkConfiguration$.MODULE$.SPARK_HOME().getValue(options);
        String sparkConfDir = (String)SparkConfiguration$.MODULE$.SPARK_CONF_DIR().getValue(options);
        SparkConfig sparkConfig = this.getSparkConfig(options);
        EnvironmentContext context = new EnvironmentContext(sparkConfig, hadoopConfDir, sparkConfDir, sparkHome, null);
        return context;
    }

    public SparkConfig getSparkConfig(Map<String, String> options) {
        this.logger().info(new StringBuilder(9).append("options: ").append(JsonUtils$.MODULE$.jackson().writeValueAsString(options)).toString());
        SparkConfig sparkConfig = new SparkConfig();
        sparkConfig.setJavaHome(Environment$.MODULE$.variable(Environment$.MODULE$.JAVA_HOME()));
        sparkConfig.setSparkHome((String)SparkConfiguration$.MODULE$.SPARK_HOME().getValue(options));
        String master = (String)SparkConfiguration$.MODULE$.SPARK_MASTER().getValue(options);
        sparkConfig.setMaster(master);
        if (master.startsWith("k8s")) {
            sparkConfig.setK8sConfigFile((String)SparkConfiguration$.MODULE$.SPARK_K8S_CONFIG_FILE().getValue(options));
            sparkConfig.setK8sServiceAccount((String)SparkConfiguration$.MODULE$.SPARK_K8S_SERVICE_ACCOUNT().getValue(options));
            sparkConfig.setK8sMasterUrl((String)SparkConfiguration$.MODULE$.SPARK_K8S_MASTER_URL().getValue(options));
            sparkConfig.setK8sUsername((String)SparkConfiguration$.MODULE$.SPARK_K8S_USERNAME().getValue(options));
            sparkConfig.setK8sPassword((String)SparkConfiguration$.MODULE$.SPARK_K8S_PASSWORD().getValue(options));
            sparkConfig.setK8sImage((String)SparkConfiguration$.MODULE$.SPARK_K8S_IMAGE().getValue(options));
            sparkConfig.setK8sNamespace((String)SparkConfiguration$.MODULE$.SPARK_K8S_NAMESPACE().getValue(options));
            sparkConfig.setK8sFileUploadPath((String)SparkConfiguration$.MODULE$.SPARK_KUBERNETES_FILE_UPLOAD_PATH().getValue(options));
            sparkConfig.setK8sSparkVersion((String)SparkConfiguration$.MODULE$.SPARK_K8S_SPARK_VERSION().getValue(options));
            sparkConfig.setK8sRestartPolicy((String)SparkConfiguration$.MODULE$.SPARK_K8S_RESTART_POLICY().getValue(options));
            sparkConfig.setK8sLanguageType((String)SparkConfiguration$.MODULE$.SPARK_K8S_LANGUAGE_TYPE().getValue(options));
            sparkConfig.setK8sImagePullPolicy((String)SparkConfiguration$.MODULE$.SPARK_K8S_IMAGE_PULL_POLICY().getValue(options));
        }
        sparkConfig.setDeployMode((String)SparkConfiguration$.MODULE$.SPARK_DEPLOY_MODE().getValue(options));
        sparkConfig.setAppResource((String)SparkConfiguration$.MODULE$.SPARK_APP_RESOURCE().getValue(options));
        sparkConfig.setAppName((String)SparkConfiguration$.MODULE$.SPARK_APP_NAME().getValue(options));
        sparkConfig.setJars((String)SparkConfiguration$.MODULE$.SPARK_EXTRA_JARS().getValue(options));
        sparkConfig.setDriverMemory((String)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_DRIVER_MEMORY().getValue(options));
        sparkConfig.setDriverJavaOptions((String)SparkConfiguration$.MODULE$.SPARK_DRIVER_EXTRA_JAVA_OPTIONS().getValue(options));
        sparkConfig.setDriverClassPath((String)SparkConfiguration$.MODULE$.SPARK_DRIVER_CLASSPATH().getValue(options));
        sparkConfig.setExecutorMemory((String)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_MEMORY().getValue(options));
        sparkConfig.setProxyUser((String)SparkConfiguration$.MODULE$.PROXY_USER().getValue(options));
        sparkConfig.setDriverCores(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_DRIVER_CORES().getValue(options))));
        sparkConfig.setExecutorCores(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_CORES().getValue(options))));
        sparkConfig.setNumExecutors(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_INSTANCES().getValue(options))));
        sparkConfig.setQueue((String)SparkResourceConfiguration$.MODULE$.LINKIS_QUEUE_NAME().getValue(options));
        this.logger().info(new StringBuilder(12).append("spark_info: ").append(sparkConfig).toString());
        return sparkConfig;
    }

    public ExecutionContext createExecutionContext(Map<String, String> options, EnvironmentContext environmentContext) {
        ExecutionContext context = new ExecutionContext();
        context.setSparkConfig(environmentContext.getSparkConfig());
        return context;
    }

    public SparkEngineSession createSparkEngineSession(EngineCreationContext engineCreationContext) {
        BoxedUnit boxedUnit;
        Map options = engineCreationContext.getOptions();
        SparkConf sparkConf = new SparkConf(true);
        String master = (String)sparkConf.getOption("spark.master").getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)CommonVars$.MODULE$.apply("spark.master", (Object)"yarn").getValue());
        this.logger().info(new StringBuilder(41).append("------ Create new SparkContext {").append(master).append("} -------").toString());
        String pysparkBasePath = (String)SparkConfiguration$.MODULE$.SPARK_HOME().getValue();
        File pysparkPath = new File(pysparkBasePath, new StringBuilder(9).append("python").append(File.separator).append("lib").toString());
        String[] pythonLibUris = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pysparkPath.listFiles())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toURI().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.endsWith(".zip")));
        if (pythonLibUris.length == 2) {
            String sparkConfValue1 = (String)Utils$.MODULE$.tryQuietly((Function0 & Serializable & scala.Serializable)() -> (String)CommonVars$.MODULE$.apply("spark.yarn.dist.files", (Object)"").getValue());
            String sparkConfValue2 = (String)Utils$.MODULE$.tryQuietly((Function0 & Serializable & scala.Serializable)() -> sparkConf.get("spark.yarn.dist.files"));
            if (StringUtils.isNotBlank((CharSequence)sparkConfValue2)) {
                String string = sparkConfValue2;
                pythonLibUris = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pythonLibUris)).$plus$colon((Object)string, ClassTag$.MODULE$.apply(String.class));
            }
            if (StringUtils.isNotBlank((CharSequence)sparkConfValue1)) {
                String string = sparkConfValue1;
                pythonLibUris = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pythonLibUris)).$plus$colon((Object)string, ClassTag$.MODULE$.apply(String.class));
            }
            boxedUnit = sparkConf.set("spark.yarn.dist.files", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pythonLibUris)).mkString(","));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = master.contains("yarn") ? sparkConf.set("spark.yarn.isPython", "true") : BoxedUnit.UNIT;
        File outputDir = this.createOutputDir(sparkConf);
        this.logger().info(new StringBuilder(26).append("print current thread name ").append(Thread.currentThread().getContextClassLoader().toString()).toString());
        SparkSession sparkSession = this.createSparkSession(outputDir, sparkConf, this.createSparkSession$default$3());
        if (sparkSession == null) {
            throw new SparkSessionNullException(SparkErrorCodeSummary.CAN_NOT_NULL.getErrorCode(), SparkErrorCodeSummary.CAN_NOT_NULL.getErrorDesc());
        }
        SparkContext sc = sparkSession.sparkContext();
        SQLContext sqlContext = this.createSQLContext(sc, (HashMap)options, sparkSession);
        if (BoxesRunTime.unboxToBoolean((Object)SparkConfiguration$.MODULE$.MAPRED_OUTPUT_COMPRESS().getValue(options))) {
            sc.hadoopConfiguration().set("mapred.output.compress", SparkConfiguration$.MODULE$.MAPRED_OUTPUT_COMPRESS().getValue(options).toString());
            sc.hadoopConfiguration().set("mapred.output.compression.codec", (String)SparkConfiguration$.MODULE$.MAPRED_OUTPUT_COMPRESSION_CODEC().getValue(options));
        }
        return new SparkEngineSession(sc, sqlContext, sparkSession, outputDir);
    }

    public SparkSession createSparkSession(File outputDir, SparkConf conf, boolean addPythonSupport) {
        Seq seq;
        String execUri = System.getenv("SPARK_EXECUTOR_URI");
        Option sparkJars = conf.getOption("spark.jars");
        String master = (String)conf.getOption("spark.master").getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)SparkConfiguration$.MODULE$.SPARK_MASTER().getValue());
        this.logger().info(new StringBuilder(41).append("------ Create new SparkContext {").append(master).append("} -------").toString());
        Object object = StringUtils.isNotEmpty((CharSequence)master) ? conf.setMaster(master) : BoxedUnit.UNIT;
        if (conf.get("spark.master").contains("yarn")) {
            Option yarnJars = conf.getOption("spark.yarn.dist.jars");
            seq = SparkEngineConnFactory.unionFileLists$1(sparkJars, yarnJars).toSeq();
        } else {
            seq = (Seq)Option$.MODULE$.option2Iterable(sparkJars.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.split(",")).map((Function1 & Serializable & scala.Serializable)x$7 -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$7)).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)SparkEngineConnFactory.$anonfun$createSparkSession$7(x$8))))).toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)));
        }
        Seq jars = seq;
        Object object2 = outputDir != null ? conf.set("spark.repl.class.outputDir", outputDir.getAbsolutePath()) : BoxedUnit.UNIT;
        Object object3 = jars.nonEmpty() ? conf.setJars(jars) : BoxedUnit.UNIT;
        Object object4 = execUri != null ? conf.set("spark.executor.uri", execUri) : BoxedUnit.UNIT;
        Object object5 = System.getenv("SPARK_HOME") != null ? conf.setSparkHome(System.getenv("SPARK_HOME")) : BoxedUnit.UNIT;
        conf.set("spark.scheduler.mode", "FAIR");
        Object object6 = BoxesRunTime.unboxToBoolean((Object)SparkConfiguration$.MODULE$.LINKIS_SPARK_ETL_SUPPORT_HUDI().getValue()) ? conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer") : BoxedUnit.UNIT;
        SparkSession.Builder builder = SparkSession$.MODULE$.builder().config(conf);
        return builder.enableHiveSupport().getOrCreate();
    }

    public boolean createSparkSession$default$3() {
        return false;
    }

    public SQLContext createSQLContext(SparkContext sc, HashMap<String, String> options, SparkSession sparkSession) {
        Object object;
        ObjectRef sqlc = ObjectRef.create(null);
        if (BoxesRunTime.unboxToBoolean((Object)SparkConfiguration$.MODULE$.LINKIS_SPARK_USEHIVECONTEXT().getValue(options))) {
            String name = "org.apache.spark.sql.hive.HiveContext";
            ObjectRef hc = ObjectRef.create(null);
            object = Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                hc$1.elem = this.getClass().getClassLoader().loadClass(name).getConstructor(SparkContext.class);
                sqlc$1.elem = (SQLContext)((Constructor)hc$1.elem).newInstance(sc);
            }, (Function1 & Serializable & scala.Serializable)e -> {
                SparkEngineConnFactory.$anonfun$createSQLContext$2(this, sqlc, sparkSession, e);
                return BoxedUnit.UNIT;
            });
        } else {
            sqlc.elem = sparkSession.sqlContext();
            object = BoxedUnit.UNIT;
        }
        return (SQLContext)sqlc.elem;
    }

    public File createOutputDir(SparkConf conf) {
        String rootDir = conf.get("spark.repl.classdir", System.getProperty("java.io.tmpdir"));
        return (File)Utils$.MODULE$.tryThrow((Function0 & Serializable & scala.Serializable)() -> {
            File output = SparkUtils$.MODULE$.createTempDir(rootDir, "repl");
            this.logger().info(new StringBuilder(15).append("outputDir====> ").append(output).toString());
            output.deleteOnExit();
            conf.set("spark.repl.class.outputDir", output.getAbsolutePath());
            return output;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            this.logger().warn("create spark repl classdir failed", t);
            throw new SparkCreateFileException(SparkErrorCodeSummary.SPARK_CREATE_EXCEPTION.getErrorCode(), SparkErrorCodeSummary.SPARK_CREATE_EXCEPTION.getErrorDesc(), (Throwable)t);
        });
    }

    public Class<? extends ExecutorFactory> getDefaultExecutorFactoryClass() {
        return SparkSqlExecutorFactory.class;
    }

    public Enumeration.Value getEngineConnType() {
        return EngineType$.MODULE$.SPARK();
    }

    private ExecutorFactory[] executorFactoryArray() {
        return this.executorFactoryArray;
    }

    public ExecutorFactory[] getExecutorFactories() {
        return this.executorFactoryArray();
    }

    public static final /* synthetic */ boolean $anonfun$createSparkSession$3(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    private static final Set unionFileLists$1(Option leftList, Option rightList) {
        ObjectRef allFiles = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        leftList.foreach((Function1 & Serializable & scala.Serializable)value -> {
            allFiles.elem = (Set)((Set)allFiles.elem).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value.split(","))));
            return BoxedUnit.UNIT;
        });
        rightList.foreach((Function1 & Serializable & scala.Serializable)value -> {
            allFiles.elem = (Set)((Set)allFiles.elem).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value.split(","))));
            return BoxedUnit.UNIT;
        });
        return (Set)((Set)allFiles.elem).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SparkEngineConnFactory.$anonfun$createSparkSession$3(x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$createSparkSession$7(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$createSQLContext$2(SparkEngineConnFactory $this, ObjectRef sqlc$1, SparkSession sparkSession$1, Throwable e) {
        $this.logger().warn("Can't create HiveContext. Fallback to SQLContext", e);
        sqlc$1.elem = sparkSession$1.sqlContext();
    }

    public SparkEngineConnFactory() {
        AbstractEngineConnFactory.$init$((AbstractEngineConnFactory)this);
        Logging.$init$((Logging)this);
        MultiExecutorEngineConnFactory.$init$((MultiExecutorEngineConnFactory)this);
        this.executorFactoryArray = (ExecutorFactory[])((Object[])new ExecutorFactory[]{new SparkSqlExecutorFactory(), new SparkPythonExecutorFactory(), new SparkScalaExecutorFactory(), new SparkDataCalcExecutorFactory(), new SparkOnceExecutorFactory()});
    }
}

