/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.imexport;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.imexport.CsvRelation$;
import org.apache.linkis.engineplugin.spark.imexport.util.BackGroundServiceUtils$;
import org.apache.linkis.engineplugin.spark.imexport.util.ImExportUtils$;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.hadoop.common.utils.HDFSUtils$;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.apache.linkis.storage.excel.XlsUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class LoadData$ {
    public static LoadData$ MODULE$;

    static {
        new LoadData$();
    }

    public void loadDataToTable(SparkSession spark, String source, String destination) {
        scala.collection.immutable.Map src = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)BDPJettyServerHelper$.MODULE$.jacksonJson().readValue(source, HashMap.class)).asScala()).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map dst = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)BDPJettyServerHelper$.MODULE$.jacksonJson().readValue(destination, HashMap.class)).asScala()).toMap(Predef$.MODULE$.$conforms());
        this.create_table_from_a_file(spark, (scala.collection.immutable.Map<String, Object>)src, (scala.collection.immutable.Map<String, Object>)dst);
    }

    public void loadDataToTableByFile(SparkSession spark, String destinationPath, String source) {
        String destination = BackGroundServiceUtils$.MODULE$.exchangeExecutionCode(destinationPath);
        scala.collection.immutable.Map src = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)BDPJettyServerHelper$.MODULE$.jacksonJson().readValue(source, HashMap.class)).asScala()).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map dst = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)BDPJettyServerHelper$.MODULE$.jacksonJson().readValue(destination, HashMap.class)).asScala()).toMap(Predef$.MODULE$.$conforms());
        this.create_table_from_a_file(spark, (scala.collection.immutable.Map<String, Object>)src, (scala.collection.immutable.Map<String, Object>)dst);
    }

    public void create_table_from_a_file(SparkSession spark, scala.collection.immutable.Map<String, Object> source, scala.collection.immutable.Map<String, Object> destination) {
        String path = source.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> "").toString();
        String pathType = source.getOrElse((Object)"pathType", (Function0 & Serializable & scala.Serializable)() -> "share").toString();
        boolean hasHeader = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(source.getOrElse((Object)"hasHeader", (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false).toString())).toBoolean(), (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LoadData$.$anonfun$create_table_from_a_file$5(x0$1))));
        String sheetName = source.getOrElse((Object)"sheet", (Function0 & Serializable & scala.Serializable)() -> "Sheet1").toString();
        String dateFormat = source.getOrElse((Object)"dateFormat", (Function0 & Serializable & scala.Serializable)() -> "yyyy-MM-dd").toString();
        String suffix = path.substring(path.lastIndexOf("."));
        java.util.List sheetNames = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sheetName.split(","))).toBuffer()).asJava();
        FileSystem fs = null;
        String database = destination.getOrElse((Object)"database", (Function0 & Serializable & scala.Serializable)() -> "").toString();
        String tableName = destination.getOrElse((Object)"tableName", (Function0 & Serializable & scala.Serializable)() -> "").toString();
        boolean importData = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(destination.getOrElse((Object)"importData", (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true).toString())).toBoolean(), (Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LoadData$.$anonfun$create_table_from_a_file$12(x0$2))));
        boolean isPartition = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(destination.getOrElse((Object)"isPartition", (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true).toString())).toBoolean(), (Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)LoadData$.$anonfun$create_table_from_a_file$15(destination, x0$3))));
        boolean isOverwrite = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(destination.getOrElse((Object)"isOverwrite", (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false).toString())).toBoolean(), (Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)LoadData$.$anonfun$create_table_from_a_file$19(x0$4))));
        String partition = destination.getOrElse((Object)"partition", (Function0 & Serializable & scala.Serializable)() -> "ds").toString();
        String partitionValue = destination.getOrElse((Object)"partitionValue", (Function0 & Serializable & scala.Serializable)() -> "1993-01-02").toString();
        java.util.List columnsJava = (java.util.List)destination.getOrElse((Object)"columns", (Function0 & Serializable & scala.Serializable)() -> "");
        List columns = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(columnsJava).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)x$1).asScala()).toMap(Predef$.MODULE$.$conforms()), List$.MODULE$.canBuildFrom());
        List dateFormats = (List)columns.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getOrElse((Object)"dateFormat", (Function0 & Serializable & scala.Serializable)() -> "yyyy-MM-dd").toString(), List$.MODULE$.canBuildFrom());
        BooleanRef isFirst = BooleanRef.create((boolean)true);
        StringBuilder dateFormatsJson = new StringBuilder();
        dateFormats.foreach((Function1 & Serializable & scala.Serializable)f -> {
            StringBuilder stringBuilder;
            if (isFirst$1.elem) {
                isFirst$1.elem = false;
                stringBuilder = BoxedUnit.UNIT;
            } else {
                stringBuilder = dateFormatsJson.append(";");
            }
            return dateFormatsJson.append(f);
        });
        String indexesStr = String.join((CharSequence)",", (Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)columns.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getOrElse((Object)"index", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0).toString(), List$.MODULE$.canBuildFrom())).asJava());
        if ("hdfs".equalsIgnoreCase(pathType)) {
            if (".xls".equalsIgnoreCase(suffix)) {
                Configuration config = HDFSUtils$.MODULE$.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue());
                config.setBoolean("fs.hdfs.impl.disable.cache", true);
                fs = HDFSUtils$.MODULE$.getHDFSUserFileSystem(System.getProperty("user.name"), config);
                path = XlsUtils.excelToCsv((InputStream)fs.open(new Path(path)), (FileSystem)fs, (Boolean)Predef$.MODULE$.boolean2Boolean(hasHeader), (java.util.List)sheetNames);
                hasHeader = false;
            } else {
                path = BoxesRunTime.unboxToBoolean((Object)SparkConfiguration$.MODULE$.IS_VIEWFS_ENV().getValue()) ? path : new java.lang.StringBuilder(7).append("hdfs://").append(path).toString();
            }
        } else if (".xlsx".equalsIgnoreCase(suffix)) {
            path = new java.lang.StringBuilder(7).append("file://").append(path).toString();
        } else if (".xls".equalsIgnoreCase(suffix)) {
            Configuration config = HDFSUtils$.MODULE$.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue());
            config.setBoolean("fs.hdfs.impl.disable.cache", true);
            fs = HDFSUtils$.MODULE$.getHDFSUserFileSystem(System.getProperty("user.name"), config);
            path = XlsUtils.excelToCsv((InputStream)new FileInputStream(path), (FileSystem)fs, (Boolean)Predef$.MODULE$.boolean2Boolean(hasHeader), (java.util.List)sheetNames);
            hasHeader = false;
        } else {
            Configuration config = HDFSUtils$.MODULE$.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue());
            config.setBoolean("fs.hdfs.impl.disable.cache", true);
            fs = HDFSUtils$.MODULE$.getHDFSUserFileSystem(System.getProperty("user.name"), config);
            path = this.copyFileToHdfs(path, fs);
        }
        Dataset df = ".xlsx".equalsIgnoreCase(suffix) ? spark.read().format("com.webank.wedatasphere.spark.excel").option("useHeader", hasHeader).option("maxRowsInMemory", 100L).option("sheetName", sheetName).option("indexes", indexesStr).option("dateFormats", dateFormatsJson.toString()).schema(new StructType(this.getFields((List<scala.collection.immutable.Map<String, Object>>)columns))).load(path) : CsvRelation$.MODULE$.csvToDF(spark, new StructType(this.getFields((List<scala.collection.immutable.Map<String, Object>>)columns)), hasHeader, path, source, (List<scala.collection.immutable.Map<String, Object>>)columns);
        df.createOrReplaceTempView("tempTable");
        try {
            try {
                if (importData) {
                    if (isPartition) {
                        if (isOverwrite) {
                            spark.sql(new java.lang.StringBuilder(64).append("INSERT OVERWRITE TABLE  ").append(database).append(".").append(tableName).append(" partition(").append(partition).append("='").append(partitionValue).append("') select * from tempTable").toString());
                        } else {
                            spark.sql(new java.lang.StringBuilder(53).append("INSERT INTO  ").append(database).append(".").append(tableName).append(" partition(").append(partition).append("='").append(partitionValue).append("') select * from tempTable").toString());
                        }
                    } else if (isOverwrite) {
                        spark.sql(new java.lang.StringBuilder(49).append("INSERT OVERWRITE TABLE  ").append(database).append(".").append(tableName).append(" select * from tempTable").toString());
                    } else {
                        spark.sql(new java.lang.StringBuilder(39).append("INSERT INTO   ").append(database).append(".").append(tableName).append(" select * from tempTable").toString());
                    }
                } else {
                    Object object = spark.catalog().tableExists(database, tableName) ? spark.sql(new java.lang.StringBuilder(22).append("drop table if exists ").append(database).append(".").append(tableName).toString()) : BoxedUnit.UNIT;
                    if (isPartition) {
                        String columnSql = this.getColumnSql((List<scala.collection.immutable.Map<String, Object>>)columns);
                        String sql = new java.lang.StringBuilder(97).append("create table ").append(database).append(".").append(tableName).append("(").append(columnSql).append(") PARTITIONED BY (`").append(partition).append("` string) stored as orc tblproperties ('orc.compress'='SNAPPY')").toString();
                        spark.sql(sql);
                        spark.sql(new java.lang.StringBuilder(64).append("INSERT OVERWRITE TABLE  ").append(database).append(".").append(tableName).append(" partition(").append(partition).append("='").append(partitionValue).append("') select * from tempTable").toString());
                    } else {
                        String columnSql = this.getColumnSql((List<scala.collection.immutable.Map<String, Object>>)columns);
                        String sql = new java.lang.StringBuilder(70).append("create table ").append(database).append(".").append(tableName).append("(").append(columnSql).append(") stored as orc tblproperties ('orc.compress'='SNAPPY')").toString();
                        spark.sql(sql);
                        spark.sql(new java.lang.StringBuilder(49).append("INSERT OVERWRITE TABLE  ").append(database).append(".").append(tableName).append(" select * from tempTable").toString());
                    }
                }
            }
            catch (Throwable t) {
                Object object = !importData ? ImExportUtils$.MODULE$.tryAndIngoreError((Function0 & Serializable & scala.Serializable)() -> spark.sql(new java.lang.StringBuilder(12).append("drop table ").append(database).append(".").append(tableName).toString())) : BoxedUnit.UNIT;
                throw t;
            }
        }
        finally {
            if (fs != null) {
                fs.delete(new Path(path), true);
                fs.close();
            }
        }
    }

    public String copyFileToHdfs(String path, FileSystem fs) {
        File file = new File(path);
        if (file.isDirectory()) {
            throw new Exception("Import must be a file, not a directory(\u5bfc\u5165\u7684\u5fc5\u987b\u662f\u6587\u4ef6\uff0c\u4e0d\u80fd\u662f\u76ee\u5f55)");
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        String hdfsPath = new java.lang.StringBuilder(6).append("/tmp/").append(System.getProperty("user.name")).append("/").append(System.currentTimeMillis()).append(file.getName()).toString();
        FSDataOutputStream out = fs.create(new Path(hdfsPath), true);
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)4096);
        out.hsync();
        IOUtils.closeStream((Closeable)in);
        IOUtils.closeStream((Closeable)out);
        return hdfsPath;
    }

    public <T> T getMapValue(scala.collection.immutable.Map<String, Object> map, String key, T t) {
        Object value = map.get((Object)key).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4).getOrElse((Function0 & Serializable & scala.Serializable)() -> t);
        if (StringUtils.isEmpty((CharSequence)value.toString())) {
            return t;
        }
        return (T)value;
    }

    public <T> T getMapValue$default$3() {
        return null;
    }

    public String getColumnSql(List<scala.collection.immutable.Map<String, Object>> columns) {
        StringBuilder sql = new StringBuilder();
        columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
            if (column.apply((Object)"name") == null) {
                throw new IllegalArgumentException("When create a table, the field name must be defined(\u5efa\u7acb\u65b0\u8868\u65f6\uff0c\u5b57\u6bb5\u540d\u5fc5\u987b\u5b9a\u4e49)");
            }
            String name = (String)column.apply((Object)"name");
            sql.append("`").append(name).append("` ");
            String dataType = ((String)column.getOrElse((Object)"type", (Function0 & Serializable & scala.Serializable)() -> "string")).toLowerCase(Locale.getDefault());
            sql.append(dataType);
            String string = dataType;
            if ("char".equals(string) ? true : "varchar".equals(string)) {
                int length = new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"length", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 20).toString())).toInt();
                sql.append(new java.lang.StringBuilder(2).append("(").append(length).append(")").toString());
            } else if ("decimal".equals(string)) {
                int precision = new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"precision", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 20).toString())).toInt();
                int scale = new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"scale", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 4).toString())).toInt();
                sql.append(new java.lang.StringBuilder(3).append("(").append(precision).append(",").append(scale).append(")").toString());
            }
            String comment = column.getOrElse((Object)"comment", (Function0 & Serializable & scala.Serializable)() -> "").toString();
            Object object = StringUtils.isNotEmpty((CharSequence)comment) ? sql.append(" comment ").append(new java.lang.StringBuilder(3).append("'").append(comment).append("' ").toString()) : BoxedUnit.UNIT;
            return sql.append(",");
        });
        return sql.toString().substring(0, sql.length() - 1);
    }

    public StructField[] getFields(List<scala.collection.immutable.Map<String, Object>> columns) {
        return (StructField[])((TraversableOnce)columns.map((Function1 & Serializable & scala.Serializable)column -> {
            if (column.apply((Object)"name") == null) {
                throw new IllegalArgumentException("When create a table, the field name must be defined(\u5efa\u7acb\u65b0\u8868\u65f6\uff0c\u5b57\u6bb5\u540d\u5fc5\u987b\u5b9a\u4e49)");
            }
            String name = (String)column.apply((Object)"name");
            String dataType = (String)column.getOrElse((Object)"type", (Function0 & Serializable & scala.Serializable)() -> "string");
            int precision = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"precision", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 20).toString())).toInt(), (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)LoadData$.$anonfun$getFields$5(x0$1))));
            int scale = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(column.getOrElse((Object)"scale", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 4).toString())).toInt(), (Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)LoadData$.$anonfun$getFields$8(x0$2))));
            return new StructField(name, MODULE$.toDataType(dataType.toLowerCase(Locale.getDefault()), precision, scale), true, StructField$.MODULE$.apply$default$4());
        }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class));
    }

    public DataType toDataType(String dataType, int precision, int scale) {
        String string = dataType;
        if ("void".equals(string) ? true : "null".equals(string)) {
            return NullType$.MODULE$;
        }
        if ("string".equals(string) ? true : ("char".equals(string) ? true : "varchar".equals(string))) {
            return StringType$.MODULE$;
        }
        if ("boolean".equals(string)) {
            return BooleanType$.MODULE$;
        }
        if ("short".equals(string)) {
            return ShortType$.MODULE$;
        }
        if ("int".equals(string) ? true : ("tinyint".equals(string) ? true : ("integer".equals(string) ? true : "smallint".equals(string)))) {
            return IntegerType$.MODULE$;
        }
        if ("long".equals(string) ? true : "bigint".equals(string)) {
            return LongType$.MODULE$;
        }
        if ("float".equals(string)) {
            return FloatType$.MODULE$;
        }
        if ("double".equals(string)) {
            return DoubleType$.MODULE$;
        }
        if ("date".equals(string)) {
            return DateType$.MODULE$;
        }
        if ("timestamp".equals(string)) {
            return TimestampType$.MODULE$;
        }
        if ("binary".equals(string)) {
            return BinaryType$.MODULE$;
        }
        if ("decimal".equals(string)) {
            return new DecimalType(precision, scale);
        }
        throw new IllegalArgumentException(new java.lang.StringBuilder(18).append("unknown dataType ").append(dataType).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$create_table_from_a_file$5(Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            return false;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ boolean $anonfun$create_table_from_a_file$12(Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof Exception) {
            return true;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ boolean $anonfun$create_table_from_a_file$15(scala.collection.immutable.Map destination$1, Throwable x0$3) {
        Throwable throwable = x0$3;
        if (throwable instanceof Exception) {
            BigInt flag = package$.MODULE$.BigInt().apply(destination$1.getOrElse((Object)"isPartition", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0).toString());
            return BoxesRunTime.equalsNumObject((Number)flag, (Object)BoxesRunTime.boxToInteger((int)1));
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ boolean $anonfun$create_table_from_a_file$19(Throwable x0$4) {
        Throwable throwable = x0$4;
        if (throwable instanceof Exception) {
            return false;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ int $anonfun$getFields$5(Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            return 20;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ int $anonfun$getFields$8(Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof Exception) {
            return 4;
        }
        throw new MatchError((Object)throwable);
    }

    private LoadData$() {
        MODULE$ = this;
    }
}

