/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.launch;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.config.SparkResourceConfiguration$;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.linkis.engineplugin.spark.exception.SparkEngineException;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.engineplugin.common.conf.EnvConfiguration$;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnBuildRequest;
import org.apache.linkis.manager.engineplugin.common.launch.process.Environment$;
import org.apache.linkis.manager.engineplugin.common.launch.process.JavaProcessEngineConnLaunchBuilder;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngingeConnRuntimeModeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.protocol.UserWithCreator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001\u0002\u0005\n\u0001YA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006c\u0001!\tA\r\u0005\u0006m\u0001!\ta\u000e\u0005\u0006)\u0002!\t!\u0016\u0005\u0006S\u0002!IA\u001b\u0005\u0006[\u0002!IA\u001c\u0005\u0007[\u0002!I!a\u0007\u0003SM\u0003\u0018M]6Tk\nl\u0017\u000e\u001e)s_\u000e,7o]#oO&tWmQ8o]2\u000bWO\\2i\u0005VLG\u000eZ3s\u0015\tQ1\"\u0001\u0004mCVt7\r\u001b\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\u0019\u0015tw-\u001b8fa2,x-\u001b8\u000b\u0005A\t\u0012A\u00027j].L7O\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005)Q\u000f^5mg*\u0011!eD\u0001\u0007G>lWn\u001c8\n\u0005\u0011z\"a\u0002'pO\u001eLgnZ\u0001\bEVLG\u000eZ3s!\t9s&D\u0001)\u0015\tI#&A\u0004qe>\u001cWm]:\u000b\u0005)Y#B\u0001\u0012-\u0015\tqQF\u0003\u0002/\u001f\u00059Q.\u00198bO\u0016\u0014\u0018B\u0001\u0019)\u0005\tR\u0015M^1Qe>\u001cWm]:F]\u001eLg.Z\"p]:d\u0015-\u001e8dQ\n+\u0018\u000e\u001c3fe\u00061A(\u001b8jiz\"\"aM\u001b\u0011\u0005Q\u0002Q\"A\u0005\t\u000b\u0015\u0012\u0001\u0019\u0001\u0014\u0002\u0017\u001d,GoQ8n[\u0006tGm\u001d\u000b\u0006q\u0019s\u0005K\u0015\t\u00041eZ\u0014B\u0001\u001e\u001a\u0005\u0015\t%O]1z!\ta4I\u0004\u0002>\u0003B\u0011a(G\u0007\u0002\u007f)\u0011\u0001)F\u0001\u0007yI|w\u000e\u001e \n\u0005\tK\u0012A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n11\u000b\u001e:j]\u001eT!AQ\r\t\u000b\u001d\u001b\u0001\u0019\u0001%\u0002-\u0015tw-\u001b8f\u0007>tgNQ;jY\u0012\u0014V-];fgR\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u0016\u0002\r\u0015tG/\u001b;z\u0013\ti%J\u0001\fF]\u001eLg.Z\"p]:\u0014U/\u001b7e%\u0016\fX/Z:u\u0011\u0015y5\u00011\u0001<\u0003%i\u0017-\u001b8DY\u0006\u001c8\u000fC\u0003R\u0007\u0001\u00071(\u0001\u0005hG2{w\rR5s\u0011\u0015\u00196\u00011\u0001<\u0003\u0019awn\u001a#je\u00069q-\u001a;D_:4G#\u0002,bE\u000e$\u0007cA,]=6\t\u0001L\u0003\u0002Z5\u00069Q.\u001e;bE2,'BA.\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003;b\u00131\"\u0011:sCf\u0014UO\u001a4feB!\u0001dX\u001e<\u0013\t\u0001\u0017D\u0001\u0004UkBdWM\r\u0005\u0006\u000f\u0012\u0001\r\u0001\u0013\u0005\u0006#\u0012\u0001\ra\u000f\u0005\u0006'\u0012\u0001\ra\u000f\u0005\u0006K\u0012\u0001\rAZ\u0001\u0012SNL\u0016M\u001d8DYV\u001cH/\u001a:N_\u0012,\u0007C\u0001\rh\u0013\tA\u0017DA\u0004C_>dW-\u00198\u0002\u001d%\u001chj\u001c;CY\u0006t7\u000eU1uQR\u0011am\u001b\u0005\u0006Y\u0016\u0001\raO\u0001\u0005a\u0006$\b.A\thKR4\u0016\r\\;f\u0003:$'+Z7pm\u0016,\"a\u001c:\u0015\tA\\\u00181\u0002\t\u0003cJd\u0001\u0001B\u0003t\r\t\u0007AOA\u0001U#\t)\b\u0010\u0005\u0002\u0019m&\u0011q/\u0007\u0002\b\u001d>$\b.\u001b8h!\tA\u00120\u0003\u0002{3\t\u0019\u0011I\\=\t\u000bq4\u0001\u0019A?\u0002\u0015A\u0014x\u000e]3si&,7\u000fE\u0003\u007f\u0003\u000fY4(D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B@\u0003\u00075\u000b\u0007\u000fC\u0004\u0002\u000e\u0019\u0001\r!a\u0004\u0002\u0015\r|W.\\8o-\u0006\u00148\u000fE\u0003\u0002\u0012\u0005]\u0001/\u0004\u0002\u0002\u0014)\u0019\u0011QC\u0011\u0002\t\r|gNZ\u0005\u0005\u00033\t\u0019B\u0001\u0006D_6lwN\u001c,beN$raOA\u000f\u0003?\t\u0019\u0003C\u0003}\u000f\u0001\u0007Q\u0010\u0003\u0004\u0002\"\u001d\u0001\raO\u0001\u0004W\u0016L\bBBA\u0013\u000f\u0001\u00071(\u0001\u0007eK\u001a\fW\u000f\u001c;WC2,X\r")
public class SparkSubmitProcessEngineConnLaunchBuilder
implements Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SparkSubmitProcessEngineConnLaunchBuilder sparkSubmitProcessEngineConnLaunchBuilder = this;
        synchronized (sparkSubmitProcessEngineConnLaunchBuilder) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String[] getCommands(EngineConnBuildRequest engineConnBuildRequest, String mainClass, String gcLogDir, String logDir) {
        BoxedUnit boxedUnit;
        boolean isYarnClusterMode;
        Map properties = engineConnBuildRequest.engineConnCreationDesc().properties();
        String sparkConf = this.getValueAndRemove(properties, SparkConfiguration$.MODULE$.LINKIS_SPARK_CONF());
        if (StringUtils.isNotBlank((CharSequence)sparkConf)) {
            List strArrary = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.split(";"))).toList();
            strArrary.foreach((Function1 & Serializable & scala.Serializable)keyAndValue -> {
                String key = keyAndValue.split("=")[0].trim();
                String value = keyAndValue.split("=")[1].trim();
                if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
                    return engineConnBuildRequest.engineConnCreationDesc().properties().put(key, value);
                }
                this.logger().warn(new java.lang.StringBuilder(40).append("spark conf has empty value, key:").append(key).append(", value:").append(value).toString());
                return BoxedUnit.UNIT;
            });
        }
        String className = this.getValueAndRemove(properties, "className", mainClass);
        int driverCores = BoxesRunTime.unboxToInt((Object)this.getValueAndRemove(properties, SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_DRIVER_CORES()));
        String driverMemory = this.getValueAndRemove(properties, SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_DRIVER_MEMORY());
        int executorCores = BoxesRunTime.unboxToInt((Object)this.getValueAndRemove(properties, SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_CORES()));
        String executorMemory = this.getValueAndRemove(properties, SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_MEMORY());
        int numExecutors = BoxesRunTime.unboxToInt((Object)this.getValueAndRemove(properties, SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_INSTANCES()));
        NodeResource userEngineResource = engineConnBuildRequest.engineResource();
        DriverAndYarnResource darResource = (DriverAndYarnResource)userEngineResource.getLockedResource();
        ArrayBuffer files = (ArrayBuffer)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getValueAndRemove(properties, "files", "").split(","))).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)this.isNotBlankPath(path))))).toBuffer();
        ArrayBuffer jars = new ArrayBuffer();
        jars.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getValueAndRemove(properties, "jars", "").split(","))).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)this.isNotBlankPath(path))))));
        jars.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getValueAndRemove(properties, SparkConfiguration$.MODULE$.SPARK_DEFAULT_EXTERNAL_JARS_PATH()).split(","))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)SparkSubmitProcessEngineConnLaunchBuilder.$anonfun$getCommands$4(this, x))))));
        String[] pyFiles = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getValueAndRemove(properties, "py-files", "").split(","))).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)this.isNotBlankPath(path)));
        String[] archives = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getValueAndRemove(properties, "archives", "").split(","))).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)this.isNotBlankPath(path)));
        String queue = darResource != null ? darResource.getYarnResource().getQueueName() : "default";
        String[] driverClassPath = (String[])((Object[])new String[]{this.getValueAndRemove(properties, SparkConfiguration$.MODULE$.SPARK_DRIVER_CLASSPATH()), Environment$.MODULE$.variable(Environment$.MODULE$.CLASSPATH())});
        ObjectRef userWithCreator = ObjectRef.create((Object)new UserWithCreator("DefaultUser", "DefaultCreator"));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(engineConnBuildRequest.labels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkSubmitProcessEngineConnLaunchBuilder.$anonfun$getCommands$7(userWithCreator, x0$1);
            return BoxedUnit.UNIT;
        });
        String appName = new java.lang.StringBuilder(1).append(this.getValueAndRemove(properties, SparkConfiguration$.MODULE$.SPARK_APP_NAME())).append("_").append(((UserWithCreator)userWithCreator.elem).creator()).toString();
        ArrayBuffer commandLine = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        commandLine.$plus$eq(SparkConfiguration$.MODULE$.SPARK_SUBMIT_PATH().getValue());
        String deployMode = SparkConfiguration$.MODULE$.SPARK_YARN_CLIENT();
        EngingeConnRuntimeModeLabel label = LabelUtil$.MODULE$.getEngingeConnRuntimeModeLabel(engineConnBuildRequest.labels());
        boolean bl = isYarnClusterMode = label != null && label.getModeValue().equals("yarnCluster");
        if (isYarnClusterMode) {
            deployMode = SparkConfiguration$.MODULE$.SPARK_YARN_CLUSTER();
            files.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{new java.lang.StringBuilder(34).append(Environment$.MODULE$.variable(Environment$.MODULE$.PWD())).append("/conf/linkis-engineconn.properties").toString()})));
            String clusterJars = this.getValueAndRemove(properties, SparkConfiguration$.MODULE$.SPARK_YARN_CLUSTER_JARS());
            if (StringUtils.isBlank((CharSequence)clusterJars)) {
                throw new SparkEngineException(SparkErrorCodeSummary.LINKIS_SPARK_YARN_CLUSTER_JARS_ERROR.getErrorCode(), SparkErrorCodeSummary.LINKIS_SPARK_YARN_CLUSTER_JARS_ERROR.getErrorDesc());
            }
            if (clusterJars.endsWith("/")) {
                clusterJars = (String)new StringOps(Predef$.MODULE$.augmentString(clusterJars)).dropRight(1);
            }
            boxedUnit = jars.$plus$eq((Object)new java.lang.StringBuilder(2).append(clusterJars).append("/*").toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--master", "yarn", commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--deploy-mode", deployMode, commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--name", appName, commandLine);
        this.addProxyUser$1(properties, userWithCreator, commandLine);
        Object object = jars.isEmpty() ? jars.$plus$eq((Object)"") : BoxedUnit.UNIT;
        jars.$plus$eq((Object)Environment$.MODULE$.variable(Environment$.MODULE$.UDF_JARS()));
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--jars", jars.mkString(","), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--py-files", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pyFiles)).mkString(","), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--files", files.mkString(","), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--archives", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])archives)).mkString(","), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--driver-class-path", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])driverClassPath)).mkString(":"), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--driver-memory", SparkSubmitProcessEngineConnLaunchBuilder.getMemory$1(driverMemory), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--driver-cores", Integer.toString(driverCores), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--executor-memory", SparkSubmitProcessEngineConnLaunchBuilder.getMemory$1(executorMemory), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--executor-cores", Integer.toString(executorCores), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--num-executors", Integer.toString(numExecutors), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--queue", queue, commandLine);
        this.getConf(engineConnBuildRequest, gcLogDir, logDir, isYarnClusterMode).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            SparkSubmitProcessEngineConnLaunchBuilder.$anonfun$getCommands$8(commandLine, x0$2);
            return BoxedUnit.UNIT;
        });
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--class", className, commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("1>", new java.lang.StringBuilder(7).append(Environment$.MODULE$.variable(Environment$.MODULE$.LOG_DIRS())).append("/stdout").toString(), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("2>>", new java.lang.StringBuilder(7).append(Environment$.MODULE$.variable(Environment$.MODULE$.LOG_DIRS())).append("/stderr").toString(), commandLine);
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("", new java.lang.StringBuilder(6).append(" ").append(Environment$.MODULE$.variable(Environment$.MODULE$.PWD())).append("/lib/").append(SparkConfiguration$.MODULE$.ENGINE_JAR().getValue()).toString(), commandLine);
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commandLine.toArray(ClassTag$.MODULE$.apply(String.class)))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkSubmitProcessEngineConnLaunchBuilder.$anonfun$getCommands$9(x$1)));
    }

    public ArrayBuffer<Tuple2<String, String>> getConf(EngineConnBuildRequest engineConnBuildRequest, String gcLogDir, String logDir, boolean isYarnClusterMode) {
        StringBuilder driverJavaSet = new StringBuilder(" -server");
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)EnvConfiguration$.MODULE$.ENGINE_CONN_DEFAULT_JAVA_OPTS().getValue()))) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)EnvConfiguration$.MODULE$.ENGINE_CONN_DEFAULT_JAVA_OPTS().getValue())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gcLogDir})).split("\\s+"))).foreach((Function1 & Serializable & scala.Serializable)l -> driverJavaSet.append(" ").append(l));
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDir.trim().split(" "))).foreach((Function1 & Serializable & scala.Serializable)l -> driverJavaSet.append(" ").append(l));
        StringBuilder stringBuilder = isYarnClusterMode ? driverJavaSet.append(" -Djava.io.tmpdir=/tmp") : driverJavaSet.append(new java.lang.StringBuilder(18).append(" -Djava.io.tmpdir=").append(Environment$.MODULE$.variable(Environment$.MODULE$.TEMP_DIRS())).toString());
        Object object = BoxesRunTime.unboxToBoolean((Object)EnvConfiguration$.MODULE$.ENGINE_CONN_DEBUG_ENABLE().getValue()) ? driverJavaSet.append(new java.lang.StringBuilder(63).append(" -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=").append(Environment$.MODULE$.variable(Environment$.MODULE$.RANDOM_PORT())).toString()) : BoxedUnit.UNIT;
        ArrayBuffer conf = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        conf.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkConfiguration$.MODULE$.SPARK_DRIVER_EXTRA_JAVA_OPTIONS().key()), (Object)driverJavaSet.toString()));
        Map properties = engineConnBuildRequest.engineConnCreationDesc().properties();
        Iterator iterator = properties.entrySet().iterator();
        ArrayBuffer sparkConfKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (iterator.hasNext()) {
            BoxedUnit boxedUnit;
            Map.Entry keyValue = iterator.next();
            if (!SparkConfiguration$.MODULE$.SPARK_PYTHON_VERSION().key().equals(keyValue.getKey()) && !SparkConfiguration$.MODULE$.SPARK_DEPLOY_MODE().key().equals(keyValue.getKey()) && ((String)keyValue.getKey()).startsWith("spark.") && StringUtils.isNotBlank((CharSequence)((CharSequence)keyValue.getValue()))) {
                conf.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(keyValue.getKey()), keyValue.getValue()));
                boxedUnit = sparkConfKeys.$plus$eq(keyValue.getKey());
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        sparkConfKeys.foreach((Function1 & Serializable & scala.Serializable)x$1 -> (String)properties.remove(x$1));
        return conf;
    }

    private boolean isNotBlankPath(String path) {
        return StringUtils.isNotBlank((CharSequence)path) && !"/".equals(path.trim()) && !"hdfs:///".equals(path.trim()) && !"file:///".equals(path.trim());
    }

    private <T> T getValueAndRemove(Map<String, String> properties, CommonVars<T> commonVars) {
        Object value = commonVars.getValue(properties);
        properties.remove(commonVars.key());
        return (T)value;
    }

    private String getValueAndRemove(Map<String, String> properties, String key, String defaultValue) {
        if (properties.containsKey(key)) {
            return properties.remove(key);
        }
        return defaultValue;
    }

    public static final /* synthetic */ boolean $anonfun$getCommands$4(SparkSubmitProcessEngineConnLaunchBuilder $this, String x) {
        boolean isPath = $this.isNotBlankPath(x);
        $this.logger().info(new java.lang.StringBuilder(20).append("file:").append(x).append(", check isPath:").append(isPath).toString());
        return isPath;
    }

    public static final /* synthetic */ void $anonfun$getCommands$7(ObjectRef userWithCreator$1, Label x0$1) {
        Label label = x0$1;
        if (label instanceof UserCreatorLabel) {
            UserCreatorLabel userCreatorLabel = (UserCreatorLabel)label;
            userWithCreator$1.elem = new UserWithCreator(userCreatorLabel.getUser(), userCreatorLabel.getCreator());
            return;
        }
    }

    private static final void addOpt$1(String option, String value, ArrayBuffer commandLine$1) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            commandLine$1.$plus$eq((Object)option);
            commandLine$1.$plus$eq((Object)value);
            return;
        }
    }

    private final void addProxyUser$1(Map properties$1, ObjectRef userWithCreator$1, ArrayBuffer commandLine$1) {
        if (!BoxesRunTime.unboxToBoolean((Object)HadoopConf$.MODULE$.KEYTAB_PROXYUSER_ENABLED().getValue())) {
            return;
        }
        String proxyUser = this.getValueAndRemove(properties$1, "proxyUser", "");
        if (StringUtils.isNotBlank((CharSequence)proxyUser)) {
            SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--proxy-user", proxyUser, commandLine$1);
            return;
        }
        SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--proxy-user", ((UserWithCreator)userWithCreator$1.elem).user(), commandLine$1);
    }

    private static final String getMemory$1(String memory) {
        if (StringUtils.isNumeric((CharSequence)memory)) {
            return new java.lang.StringBuilder(1).append(memory).append("g").toString();
        }
        return memory;
    }

    public static final /* synthetic */ void $anonfun$getCommands$8(ArrayBuffer commandLine$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            SparkSubmitProcessEngineConnLaunchBuilder.addOpt$1("--conf", new java.lang.StringBuilder(3).append(key).append("=\"").append(value).append("\"").toString(), commandLine$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getCommands$9(CharSequence x$1) {
        return StringUtils.isNotEmpty((CharSequence)x$1);
    }

    public SparkSubmitProcessEngineConnLaunchBuilder(JavaProcessEngineConnLaunchBuilder builder) {
        Logging.$init$((Logging)this);
    }
}

