/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineplugin.spark.common.LineBufferedProcess;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.storage.FSFactory;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.resultset.ResultSetReaderFactory;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

public final class EngineUtils$
implements Logging {
    public static EngineUtils$ MODULE$;
    private final String user;
    private String sparkVersion;
    private Fs fileSystem;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new EngineUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        EngineUtils$ engineUtils$ = this;
        synchronized (engineUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String user() {
        return this.user;
    }

    private String sparkVersion() {
        return this.sparkVersion;
    }

    private void sparkVersion_$eq(String x$1) {
        this.sparkVersion = x$1;
    }

    private Fs fileSystem() {
        return this.fileSystem;
    }

    private void fileSystem_$eq(Fs x$1) {
        this.fileSystem = x$1;
    }

    public String getName() {
        return Sender$.MODULE$.getThisServiceInstance().getInstance();
    }

    public int findAvailPort() {
        ServerSocket socket = new ServerSocket(0);
        return BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> socket.getLocalPort(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> socket.close())));
    }

    public String sparkSubmitVersion() {
        if (this.sparkVersion() != null) {
            return this.sparkVersion();
        }
        CommonVars sparkVersionVar = CommonVars$.MODULE$.apply("wds.linkis.engine.spark.version", (Object)"");
        if (StringUtils.isNotBlank((CharSequence)((String)sparkVersionVar.getValue()).trim())) {
            String string;
            String output = ((String)sparkVersionVar.getValue()).trim();
            UnanchoredRegex regex = new StringOps(Predef$.MODULE$.augmentString("([\\d.]*)")).r().unanchored();
            Option option = ((Regex)regex).unapplySeq((CharSequence)(string = output));
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                String arg$macro$1 = output;
                throw new IOException(new StringOps("spark version  is invalid :\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
            }
            String version = (String)((LinearSeqOptimized)option.get()).apply(0);
            this.sparkVersion_$eq(version);
        } else {
            String sparkSubmit = (String)CommonVars$.MODULE$.apply("wds.linkis.server.spark-submit", (Object)"spark-submit").getValue();
            ProcessBuilder pb = new ProcessBuilder(sparkSubmit, "--version");
            pb.redirectErrorStream(true);
            pb.redirectInput(ProcessBuilder.Redirect.PIPE);
            LineBufferedProcess process = new LineBufferedProcess(pb.start());
            int exitCode = process.waitFor();
            String output = process.inputIterator().mkString("\n");
            UnanchoredRegex regex = new StringOps(Predef$.MODULE$.augmentString("version ([\\d.]*)")).r().unanchored();
            String string = output;
            Option option = ((Regex)regex).unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)exitCode);
                String arg$macro$3 = output;
                throw new IOException(new StringOps("Unable to determing spark-submit version [%s]:\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2, arg$macro$3})));
            }
            String version = (String)((LinearSeqOptimized)option.get()).apply(0);
            this.sparkVersion_$eq(version);
        }
        this.logger().info(new StringBuilder(17).append("spark version is ").append(this.sparkVersion()).toString());
        return this.sparkVersion();
    }

    public Option<String> jarOfClass(Class<?> cls) {
        URL uri = cls.getResource(new StringBuilder(7).append("/").append(cls.getName().replace('.', '/')).append(".class").toString());
        if (uri != null) {
            String uriStr = uri.toString();
            if (uriStr.startsWith("jar:file:")) {
                return new Some((Object)uriStr.substring("jar:file:".length(), uriStr.indexOf("!")));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public OutputStream createOutputStream(String path) {
        if (this.fileSystem() == null) {
            EngineUtils$ engineUtils$ = this;
            synchronized (engineUtils$) {
                if (this.fileSystem() == null) {
                    this.fileSystem_$eq(FSFactory.getFs((String)"hdfs"));
                    this.fileSystem().init(new HashMap());
                }
            }
        }
        OutputStream outputStream = this.fileSystem().write(new FsPath(path), true);
        return outputStream;
    }

    public InputStream createInputStream(String path) {
        if (this.fileSystem() == null) {
            EngineUtils$ engineUtils$ = this;
            synchronized (engineUtils$) {
                if (this.fileSystem() == null) {
                    this.fileSystem_$eq(FSFactory.getFs((String)"hdfs"));
                    this.fileSystem().init(new HashMap());
                }
            }
        }
        InputStream inputStream = this.fileSystem().read(new FsPath(path));
        return inputStream;
    }

    public String getResultStrByDolphinTextContent(String dolphinContent) {
        String string;
        ResultSetReader resultSetReader = ResultSetReaderFactory.getResultSetReader((String)dolphinContent);
        MetaData metaData = resultSetReader.getMetaData();
        if (metaData instanceof LineMetaData) {
            scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
            while (resultSetReader.hasNext()) {
                sb.append((Object)resultSetReader.getRecord()).append("\n");
            }
            string = sb.toString();
        } else {
            string = dolphinContent;
        }
        String errorMsg = string;
        return errorMsg;
    }

    private EngineUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.user = System.getProperty("user.name");
    }
}

