/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.storage.resultset.ResultSetReaderFactory;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DolphinToSpark$ {
    public static DolphinToSpark$ MODULE$;
    private final int bigDecimalPrecision;
    private final int bigDecimalScale;

    static {
        new DolphinToSpark$();
    }

    private int bigDecimalPrecision() {
        return this.bigDecimalPrecision;
    }

    private int bigDecimalScale() {
        return this.bigDecimalScale;
    }

    public void createTempView(SparkSession spark, String tableName, String res) {
        this.createTempView(spark, tableName, res, false);
    }

    public void createTempView(SparkSession spark, String tableName, String res, boolean forceReplace) {
        if (forceReplace || spark.sessionState().catalog().getTempView(tableName).isEmpty()) {
            ResultSetReader reader = ResultSetReaderFactory.getTableResultReader((String)res);
            TableMetaData metadata = (TableMetaData)reader.getMetaData();
            ArrayList<Row> rowList = new ArrayList<Row>();
            for (int len = BoxesRunTime.unboxToInt((Object)SparkConfiguration$.MODULE$.DOLPHIN_LIMIT_LEN().getValue()); reader.hasNext() && len > 0; --len) {
                rowList.add(Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.wrapRefArray(((TableRecord)reader.getRecord()).row)));
            }
            Dataset df = spark.createDataFrame(rowList, this.metadataToSchema(metadata));
            df.createOrReplaceTempView(tableName);
            return;
        }
    }

    public StructType metadataToSchema(TableMetaData metaData) {
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metaData.columns)).map((Function1 & Serializable & scala.Serializable)field -> new StructField(field.columnName, MODULE$.toSparkType(field.dataType), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public DataType toSparkType(org.apache.linkis.storage.domain.DataType dataType) {
        org.apache.linkis.storage.domain.DataType dataType2 = dataType;
        if (org.apache.linkis.storage.domain.DataType.NullType.equals(dataType2)) {
            return NullType$.MODULE$;
        }
        if (org.apache.linkis.storage.domain.DataType.BooleanType.equals(dataType2)) {
            return BooleanType$.MODULE$;
        }
        if (org.apache.linkis.storage.domain.DataType.ShortIntType.equals(dataType2)) {
            return ShortType$.MODULE$;
        }
        if (org.apache.linkis.storage.domain.DataType.IntType.equals(dataType2)) {
            return IntegerType$.MODULE$;
        }
        if (org.apache.linkis.storage.domain.DataType.LongType.equals(dataType2)) {
            return LongType$.MODULE$;
        }
        if (org.apache.linkis.storage.domain.DataType.BigIntType.equals(dataType2)) {
            return LongType$.MODULE$;
        }
        if (org.apache.linkis.storage.domain.DataType.FloatType.equals(dataType2)) {
            return FloatType$.MODULE$;
        }
        if (org.apache.linkis.storage.domain.DataType.DoubleType.equals(dataType2)) {
            return DoubleType$.MODULE$;
        }
        if (org.apache.linkis.storage.domain.DataType.DecimalType.equals(dataType2)) {
            return new DecimalType(this.bigDecimalPrecision(), this.bigDecimalScale());
        }
        if (org.apache.linkis.storage.domain.DataType.DateType.equals(dataType2)) {
            return DateType$.MODULE$;
        }
        if (org.apache.linkis.storage.domain.DataType.BinaryType.equals(dataType2)) {
            return BinaryType$.MODULE$;
        }
        return StringType$.MODULE$;
    }

    private DolphinToSpark$() {
        MODULE$ = this;
        this.bigDecimalPrecision = BoxesRunTime.unboxToInt((Object)CommonVars$.MODULE$.apply("wds.linkis.dolphin.decimal.precision", (Object)BoxesRunTime.boxToInteger((int)32)).getValue());
        this.bigDecimalScale = BoxesRunTime.unboxToInt((Object)CommonVars$.MODULE$.apply("wds.linkis.dolphin.decimal.scale", (Object)BoxesRunTime.boxToInteger((int)10)).getValue());
    }
}

