/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.source;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.linkis.engineplugin.spark.datacalc.model.SourceConfig;

public class DataLakeSourceConfig
extends SourceConfig {
    @NotBlank
    @Pattern(regexp="^(((file|hdfs)://)|/).*", message="Invalid path URI, please set the following allowed schemas: 'file://' or 'hdfs://'(default).")
    private @NotBlank @Pattern(regexp="^(((file|hdfs)://)|/).*", message="Invalid path URI, please set the following allowed schemas: 'file://' or 'hdfs://'(default).") String path;
    @NotBlank
    @Pattern(regexp="^(delta|hudi)$", message="Unknown table format: {saveMode}. Accepted save modes are 'delta', 'hudi'.")
    private @NotBlank @Pattern(regexp="^(delta|hudi)$", message="Unknown table format: {saveMode}. Accepted save modes are 'delta', 'hudi'.") String tableFormat = "delta";

    public String getPath() {
        if (this.path.startsWith("/")) {
            return "hdfs://" + this.path;
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTableFormat() {
        return this.tableFormat;
    }

    public void setTableFormat(String tableFormat) {
        this.tableFormat = tableFormat;
    }
}

