/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.executor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.linkis.engineplugin.spark.exception.SparkEngineException;
import org.apache.linkis.engineplugin.spark.utils.EngineUtils$;
import org.apache.linkis.governance.common.exception.LinkisJobRetryException;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class SQLSession$
implements Logging {
    public static SQLSession$ MODULE$;
    private final NumberFormat nf;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SQLSession$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SQLSession$ sQLSession$ = this;
        synchronized (sQLSession$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public NumberFormat nf() {
        return this.nf;
    }

    public void showDF(SparkContext sc, String jobGroup, Dataset<Row> dataFrame, String alias, int maxResult, EngineExecutionContext engineExecutionContext) {
        if (sc.isStopped()) {
            this.logger().error("Spark application has already stopped in showDF, please restart it.");
            throw new LinkisJobRetryException("Spark application sc has already stopped, please restart it.");
        }
        long startTime = System.currentTimeMillis();
        Iterator iterator = (Iterator)Utils$.MODULE$.tryThrow((Function0 & Serializable & scala.Serializable)() -> dataFrame.toLocalIterator(), (Function1 & Serializable & scala.Serializable)t -> {
            throw new SparkEngineException(SparkErrorCodeSummary.DATAFRAME_EXCEPTION.getErrorCode(), SparkErrorCodeSummary.DATAFRAME_EXCEPTION.getErrorDesc(), (Throwable)t);
        });
        HashSet colSet = new HashSet();
        StructType schema = dataFrame.schema();
        ObjectRef columnsSet = ObjectRef.create(null);
        schema.foreach((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)colSet.add(s.name())));
        if (colSet.size() < schema.size()) {
            ArrayBuffer arr = new ArrayBuffer();
            HashSet tmpSet = new HashSet();
            ArrayBuffer tmpArr = new ArrayBuffer();
            dataFrame.queryExecution().analyzed().output().foreach((Function1 & Serializable & scala.Serializable)attri -> {
                StructField tempAttri = new StructField(attri.qualifiedName(), attri.dataType(), attri.nullable(), attri.metadata());
                tmpSet.add(tempAttri);
                return tmpArr.$plus$eq((Object)tempAttri);
            });
            if (tmpSet.size() < schema.size()) {
                dataFrame.queryExecution().analyzed().output().foreach((Function1 & Serializable & scala.Serializable)attri -> {
                    StructField tempAttri = new StructField(attri.toString(), attri.dataType(), attri.nullable(), attri.metadata());
                    return arr.$plus$eq((Object)tempAttri);
                });
            } else {
                tmpArr.foreach((Function1 & Serializable & scala.Serializable)x$1 -> arr.$plus$eq(x$1));
            }
            columnsSet.elem = new StructType((StructField[])arr.toArray(ClassTag$.MODULE$.apply(StructField.class)));
        } else {
            columnsSet.elem = schema;
        }
        Column[] columns = (Column[])((TraversableOnce)((StructType)columnsSet.elem).map((Function1 & Serializable & scala.Serializable)c -> new Column(c.name(), org.apache.linkis.storage.domain.DataType.toDataType((String)c.dataType().typeName().toLowerCase(Locale.getDefault())), (String)c.getComment().orNull(Predef$.MODULE$.$conforms())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).foreach((Function1 & Serializable & scala.Serializable)c -> {
            SQLSession$.$anonfun$showDF$8(c);
            return BoxedUnit.UNIT;
        });
        if (columns == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).isEmpty()) {
            return;
        }
        TableMetaData metaData = new TableMetaData(columns);
        ResultSetWriter writer = StringUtils.isNotBlank((CharSequence)alias) ? engineExecutionContext.createResultSetWriter("2", alias) : engineExecutionContext.createResultSetWriter("2");
        writer.addMetaData((MetaData)metaData);
        IntRef index = IntRef.create((int)0);
        Utils$.MODULE$.tryThrow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (index$1.elem < maxResult && iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Object[] r = (Object[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).indices().map((Function1 & Serializable & scala.Serializable)i -> SQLSession$.MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(row.apply(BoxesRunTime.unboxToInt((Object)i)), (Object)((StructType)columnsSet.elem).fields()[BoxesRunTime.unboxToInt((Object)i)].dataType())), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
                writer.addRecord((Record)new TableRecord(r));
                ++index$1.elem;
            }
        }, (Function1 & Serializable & scala.Serializable)t -> {
            throw new SparkEngineException(SparkErrorCodeSummary.READ_RECORD_EXCEPTION.getErrorCode(), SparkErrorCodeSummary.READ_RECORD_EXCEPTION.getErrorDesc(), (Throwable)t);
        });
        String taken = ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime));
        this.logger().info(new StringBuilder(29).append("Time taken: ").append(taken).append(", Fetched ").append(index.elem).append(" row(s)").toString());
        engineExecutionContext.appendStdout(new StringBuilder(43).append(EngineUtils$.MODULE$.getName()).append(" >> Time taken: ").append(taken).append(", Fetched ").append(columns.length).append(" col(s) : ").append(index.elem).append(" row(s)").toString());
        engineExecutionContext.sendResultSet(writer);
    }

    private String toHiveString(Tuple2<Object, DataType> a2) {
        Object other;
        Tuple2<Object, DataType> tuple2 = a2;
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object v = tuple2._1();
                            StructField t = (StructField)tuple2._2();
                            return new StringBuilder(3).append("\"").append(t.name()).append("\":").append(this.toHiveStructString$1(new Tuple2(v, (Object)t.dataType()))).toString();
                        }
                        throw new MatchError((Object)tuple2);
                    }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((TraversableOnce)((TraversableLike)seq2.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, (Object)typ), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> this.toHiveStructString$1((Tuple2)a), Seq$.MODULE$.canBuildFrom())).mkString("[\"", "\",\"", "\"]");
                }
            }
        }
        if (tuple2 != null) {
            Object map = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (map instanceof Map) {
                Map map2 = (Map)map;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((TraversableOnce)((TraversableOnce)map2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object key = tuple2._1();
                            Object value = tuple2._2();
                            return new StringBuilder(1).append(this.toHiveStructString$1(new Tuple2(key, (Object)kType))).append(":").append(this.toHiveStructString$1(new Tuple2(value, (Object)vType))).toString();
                        }
                        throw new MatchError((Object)tuple2);
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object object = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                if (DoubleType$.MODULE$.equals(dataType)) {
                    if (Double.isNaN(d)) {
                        return "NaN";
                    }
                    return this.nf().format(d);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (DecimalType$.MODULE$.unapply(dataType)) {
                    return SQLSession$.formatDecimal$1(bigDecimal);
                }
            }
        }
        if (tuple2 != null && (other = tuple2._1()) instanceof Object) {
            Object object = other;
            return object.toString();
        }
        return null;
    }

    public void showHTML(SparkContext sc, String jobGroup, Object htmlContent, EngineExecutionContext engineExecutionContext) {
        long startTime = System.currentTimeMillis();
        ResultSetWriter writer = engineExecutionContext.createResultSetWriter("5");
        LineMetaData metaData = new LineMetaData(null);
        writer.addMetaData((MetaData)metaData);
        writer.addRecord((Record)new LineRecord(htmlContent.toString()));
        this.logger().warn(new StringBuilder(12).append("Time taken: ").append(ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))).toString());
        engineExecutionContext.sendResultSet(writer);
    }

    public static final /* synthetic */ void $anonfun$showDF$8(Column c) {
        MODULE$.logger().info(new StringBuilder(18).append("c is ").append(c.columnName).append(", comment is ").append(c.comment).toString());
    }

    private static final String formatDecimal$1(BigDecimal d) {
        if (d.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO.toPlainString();
        }
        return d.stripTrailingZeros().toPlainString();
    }

    private final String toHiveStructString$1(Tuple2 a2) {
        Object other;
        Object object;
        Tuple2 tuple2 = a2;
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object v = tuple2._1();
                            StructField t = (StructField)tuple2._2();
                            return new StringBuilder(3).append("\"").append(t.name()).append("\":").append(this.toHiveStructString$1(new Tuple2(v, (Object)t.dataType()))).toString();
                        }
                        throw new MatchError((Object)tuple2);
                    }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((TraversableOnce)((TraversableLike)seq2.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, (Object)typ), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> this.toHiveStructString$1((Tuple2)a), Seq$.MODULE$.canBuildFrom())).mkString("[\"", "\",\"", "\"]");
                }
            }
        }
        if (tuple2 != null) {
            Object map = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (map instanceof Map) {
                Map map2 = (Map)map;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((TraversableOnce)((TraversableOnce)map2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object key = tuple2._1();
                            Object value = tuple2._2();
                            return new StringBuilder(1).append(this.toHiveStructString$1(new Tuple2(key, (Object)kType))).append(":").append(this.toHiveStructString$1(new Tuple2(value, (Object)vType))).toString();
                        }
                        throw new MatchError((Object)tuple2);
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return "null";
        }
        if (tuple2 != null) {
            Object object2 = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (object2 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object2);
                if (DoubleType$.MODULE$.equals(dataType)) {
                    return this.nf().format(d);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (DecimalType$.MODULE$.unapply(dataType)) {
                    return SQLSession$.formatDecimal$1(bigDecimal);
                }
            }
        }
        if (tuple2 != null && (other = tuple2._1()) instanceof Object) {
            Object object3 = other;
            return object3.toString();
        }
        return null;
    }

    private SQLSession$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.nf = NumberFormat.getInstance();
        this.nf().setGroupingUsed(false);
        this.nf().setMaximumFractionDigits(BoxesRunTime.unboxToInt((Object)SparkConfiguration$.MODULE$.SPARK_NF_FRACTION_LENGTH().getValue()));
    }
}

