/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.executor;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.computation.executor.rs.RsOutputStream;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineplugin.spark.common.Kind;
import org.apache.linkis.engineplugin.spark.common.SparkScala;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.entity.SparkEngineSession;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.linkis.engineplugin.spark.exception.ApplicationAlreadyStoppedException;
import org.apache.linkis.engineplugin.spark.exception.ExecuteError;
import org.apache.linkis.engineplugin.spark.exception.SparkSessionNullException;
import org.apache.linkis.engineplugin.spark.executor.EngineExecutionContextFactory;
import org.apache.linkis.engineplugin.spark.executor.SparkEngineConnExecutor;
import org.apache.linkis.engineplugin.spark.executor.SparkScalaExecutor$;
import org.apache.linkis.engineplugin.spark.utils.EngineUtils$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.ScalaCodeParser;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.IncompleteExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.linkis.storage.resultset.ResultSetWriterFactory;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.repl.SparkILoop;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.SparkUtils$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.tools.nsc.GenericRunnerSettings;
import scala.tools.nsc.Settings;
import scala.tools.nsc.interpreter.ILoop;
import scala.tools.nsc.interpreter.ILoop$;
import scala.tools.nsc.interpreter.IMain;
import scala.tools.nsc.interpreter.InteractiveReader;
import scala.tools.nsc.interpreter.Results;
import scala.tools.nsc.interpreter.Results$Error$;
import scala.tools.nsc.interpreter.SimpleReader$;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0001\tue\u0001\u0002\u001d:\u0001\u0019C\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\")\u0011\f\u0001C\u00015\"9a\f\u0001b\u0001\n\u0013y\u0006BB3\u0001A\u0003%\u0001\rC\u0004g\u0001\t\u0007I\u0011B4\t\r9\u0004\u0001\u0015!\u0003i\u0011\u001dy\u0007A1A\u0005\nADa\u0001\u001e\u0001!\u0002\u0013\t\bbB;\u0001\u0005\u0004%IA\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B<\t\u0013m\u0004\u0001\u0019!a\u0001\n\u0013a\bbCA\u0004\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013A!\"!\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003~\u0011%\t9\u0002\u0001a\u0001\n\u0013\tI\u0002C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$!A\u0011q\u0005\u0001!B\u0013\tY\u0002C\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,!A\u00111\u0007\u0001!\u0002\u0013\ti\u0003C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u00028!A\u0011q\n\u0001!\u0002\u0013\tI\u0004C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T!A\u0011Q\r\u0001!\u0002\u0013\t)\u0006C\u0005\u0002h\u0001\u0011\r\u0011\"\u0003\u0002j!A\u0011q\u000f\u0001!\u0002\u0013\tY\u0007C\u0005\u0002z\u0001\u0001\r\u0011\"\u0003\u0002|!I\u00111\u0011\u0001A\u0002\u0013%\u0011Q\u0011\u0005\t\u0003\u0013\u0003\u0001\u0015)\u0003\u0002~!I\u00111\u0012\u0001A\u0002\u0013\u0005\u0011\u0011\u0004\u0005\n\u0003\u001b\u0003\u0001\u0019!C\u0001\u0003\u001fC\u0001\"a%\u0001A\u0003&\u00111\u0004\u0005\n\u0003+\u0003!\u0019!C\u0005\u0003/C\u0001\"a(\u0001A\u0003%\u0011\u0011\u0014\u0005\n\u0003C\u0003!\u0019!C\u0005\u0003GC\u0001\"!-\u0001A\u0003%\u0011Q\u0015\u0005\tu\u0001\u0011\r\u0011b\u0005\u00024\"A\u0011\u0011\u0019\u0001!\u0002\u0013\t)\fC\u0004\u0002D\u0002!\t%!2\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002F\"9\u0011\u0011\u001a\u0001\u0005R\u0005-\u0007bBAm\u0001\u0011E\u00131\u001c\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GAqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0004\u0003.\u0001!I!!2\t\u000f\t=\u0002\u0001\"\u0003\u0003,!9!\u0011\u0007\u0001\u0005\u0012\tM\u0002b\u0002B\"\u0001\u0011\u0005!1\u0006\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0011\u001d\u0011\u0019\u0006\u0001C)\u0005+:qAa\u0016:\u0011\u0003\u0011IF\u0002\u00049s!\u0005!1\f\u0005\u00073R\"\tAa\u0019\t\u000f\t\u0015D\u0007\"\u0003\u0003h!9!1\u000e\u001b\u0005\u0002\t5$AE*qCJ\\7kY1mC\u0016CXmY;u_JT!AO\u001e\u0002\u0011\u0015DXmY;u_JT!\u0001P\u001f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yz\u0014\u0001D3oO&tW\r\u001d7vO&t'B\u0001!B\u0003\u0019a\u0017N\\6jg*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0007\u0001\u0019\"\u0001A$\u0011\u0005!KU\"A\u001d\n\u0005)K$aF*qCJ\\WI\\4j]\u0016\u001cuN\u001c8Fq\u0016\u001cW\u000f^8s\u0003I\u0019\b/\u0019:l\u000b:<\u0017N\\3TKN\u001c\u0018n\u001c8\u0011\u00055\u0003V\"\u0001(\u000b\u0005=[\u0014AB3oi&$\u00180\u0003\u0002R\u001d\n\u00112\u000b]1sW\u0016sw-\u001b8f'\u0016\u001c8/[8o\u0003\tIG\r\u0005\u0002U/6\tQKC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAVK\u0001\u0003M_:<\u0017A\u0002\u001fj]&$h\bF\u0002\\9v\u0003\"\u0001\u0013\u0001\t\u000b-\u001b\u0001\u0019\u0001'\t\u000bI\u001b\u0001\u0019A*\u0002\u0019M\u0004\u0018M]6D_:$X\r\u001f;\u0016\u0003\u0001\u0004\"!Y2\u000e\u0003\tT!\u0001P!\n\u0005\u0011\u0014'\u0001D*qCJ\\7i\u001c8uKb$\u0018!D:qCJ\\7i\u001c8uKb$\b%A\u0006`gFd7i\u001c8uKb$X#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-\u0014\u0017aA:rY&\u0011QN\u001b\u0002\u000b'Fc5i\u001c8uKb$\u0018\u0001D0tc2\u001cuN\u001c;fqR\u0004\u0013\u0001D:qCJ\\7+Z:tS>tW#A9\u0011\u0005%\u0014\u0018BA:k\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u00035\u0019\b/\u0019:l'\u0016\u001c8/[8oA\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0002oB\u0011\u0011\r_\u0005\u0003s\n\u0014\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015M\u0004\u0018M]6D_:4\u0007%\u0001\u0006ta\u0006\u00148.\u0013'p_B,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005!-\u0001\u0003sKBd\u0017bAA\u0003\u007f\nQ1\u000b]1sW&cun\u001c9\u0002\u001dM\u0004\u0018M]6J\u0019>|\u0007o\u0018\u0013fcR!\u00111BA\t!\r!\u0016QB\u0005\u0004\u0003\u001f)&\u0001B+oSRD\u0001\"a\u0005\u000e\u0003\u0003\u0005\r!`\u0001\u0004q\u0012\n\u0014aC:qCJ\\\u0017\nT8pa\u0002\n\u0001BY5oI\u001ac\u0017mZ\u000b\u0003\u00037\u00012\u0001VA\u000f\u0013\r\ty\"\u0016\u0002\b\u0005>|G.Z1o\u00031\u0011\u0017N\u001c3GY\u0006<w\fJ3r)\u0011\tY!!\n\t\u0013\u0005M\u0001#!AA\u0002\u0005m\u0011!\u00032j]\u00124E.Y4!\u0003u)gnZ5oK\u0016CXmY;uS>t7i\u001c8uKb$h)Y2u_JLXCAA\u0017!\rA\u0015qF\u0005\u0004\u0003cI$!H#oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;GC\u000e$xN]=\u0002=\u0015tw-\u001b8f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR4\u0015m\u0019;pef\u0004\u0013\u0001\u00057j]\u0016|U\u000f\u001e9viN#(/Z1n+\t\tI\u0004\u0005\u0003\u0002<\u0005-SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u0005I\u001c(b\u0001\u001e\u0002D)!\u0011QIA$\u0003-\u0019w.\u001c9vi\u0006$\u0018n\u001c8\u000b\u0007\u0005%s(\u0001\u0006f]\u001eLg.Z2p]:LA!!\u0014\u0002>\tq!k](viB,Ho\u0015;sK\u0006l\u0017!\u00057j]\u0016|U\u000f\u001e9viN#(/Z1nA\u0005!!nT;u+\t\t)\u0006\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\u0005%|'BAA0\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0014\u0011\f\u0002\f!JLg\u000e^,sSR,'/A\u0003k\u001fV$\b%\u0001\u0005k_\n<%o\\;q+\t\tY\u0007\u0005\u0003\u0002n\u0005MTBAA8\u0015\u0011\t\t(!\u0018\u0002\t1\fgnZ\u0005\u0005\u0003k\nyGA\u0007TiJLgn\u001a\"vS2$WM]\u0001\nU>\u0014wI]8va\u0002\nA\"\u001a=fGV$XmQ8v]R,\"!! \u0011\u0007Q\u000by(C\u0002\u0002\u0002V\u00131!\u00138u\u0003A)\u00070Z2vi\u0016\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005\u001d\u0005\"CA\n7\u0005\u0005\t\u0019AA?\u00035)\u00070Z2vi\u0016\u001cu.\u001e8uA\u0005\u00012\u000f]1sW&cun\u001c9J]&$X\rZ\u0001\u0015gB\f'o[%M_>\u0004\u0018J\\5uK\u0012|F%Z9\u0015\t\u0005-\u0011\u0011\u0013\u0005\n\u0003'q\u0012\u0011!a\u0001\u00037\t\u0011c\u001d9be.LEj\\8q\u0013:LG/\u001a3!\u0003%yW\u000f\u001e9vi\u0012K'/\u0006\u0002\u0002\u001aB!\u0011qKAN\u0013\u0011\ti*!\u0017\u0003\t\u0019KG.Z\u0001\u000b_V$\b/\u001e;ESJ\u0004\u0013!\u00034bi\u0006dGj\\4t+\t\t)\u000bE\u0003U\u0003O\u000bY+C\u0002\u0002*V\u0013Q!\u0011:sCf\u0004B!!\u001c\u0002.&!\u0011qVA8\u0005\u0019\u0019FO]5oO\u0006Qa-\u0019;bY2{wm\u001d\u0011\u0016\u0005\u0005U\u0006\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005mV+\u0001\u0006d_:\u001cWO\u001d:f]RLA!a0\u0002:\nyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013\u0001B5oSR$\"!a\u0003\u0002#1\f'0_%oSRdu.\u00193J\u0019>|\u0007/A\u0004hKR\\\u0015N\u001c3\u0016\u0005\u00055\u0007\u0003BAh\u0003+l!!!5\u000b\u0007\u0005M7(\u0001\u0004d_6lwN\\\u0005\u0005\u0003/\f\tN\u0001\u0003LS:$\u0017a\u0002:v]\u000e{G-\u001a\u000b\u000b\u0003;\fi/a<\u0003\b\t]\u0001\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\tKb,7-\u001e;fe*\u0019\u0011q] \u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\u0002BAv\u0003C\u0014q\"\u0012=fGV$XMU3ta>t7/\u001a\u0005\u0006u%\u0002\ra\u0012\u0005\b\u0003cL\u0003\u0019AAz\u0003\u0011\u0019w\u000eZ3\u0011\t\u0005U(1\u0001\b\u0005\u0003o\fy\u0010E\u0002\u0002zVk!!a?\u000b\u0007\u0005uX)\u0001\u0004=e>|GOP\u0005\u0004\u0005\u0003)\u0016A\u0002)sK\u0012,g-\u0003\u0003\u00020\n\u0015!b\u0001B\u0001+\"9!\u0011B\u0015A\u0002\t-\u0011AF3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\t\t5!1C\u0007\u0003\u0005\u001fQAA!\u0005\u0002B\u00059Q\r_3dkR,\u0017\u0002\u0002B\u000b\u0005\u001f\u0011a#\u00128hS:,W\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003OJ\u0003\u0019AAz\u0003-)\u00070Z2vi\u0016d\u0015N\\3\u0015\r\u0005u'Q\u0004B\u0010\u0011\u001d\t\tP\u000ba\u0001\u0003gDqA!\u0003+\u0001\u0004\u0011Y!A\u0007nCR\u001c\u0007NR1uC2dun\u001a\u000b\u0005\u00037\u0011)\u0003C\u0004\u0003(-\u0002\r!a=\u0002\u0011\u0015\u0014(o\u001c:Ng\u001e\f\u0001c\u0019:fCR,7\u000b]1sW&cun\u001c9\u0016\u0005\u0005-\u0011A\u00053p\u0005&tGm\u00159be.\u001cVm]:j_:\fa\"\u001b8jiN\u0003\u0018M]6J\u0019>|\u0007/\u0001\u0005hKR4\u0015.\u001a7e)\u0019\u0011)Da\u000f\u0003@A!\u0011Q\u000eB\u001c\u0013\u0011\u0011I$a\u001c\u0003\r=\u0013'.Z2u\u0011\u001d\u0011id\fa\u0001\u0005k\t1a\u001c2k\u0011\u001d\u0011\te\fa\u0001\u0003g\fAA\\1nK\u0006\u0001\"-\u001b8e'B\f'o[*fgNLwN\\\u0001\nO\u0016$x\n\u001d;j_:$BA!\u0013\u0003PA)AKa\u0013\u0002t&\u0019!QJ+\u0003\r=\u0003H/[8o\u0011\u001d\u0011\t&\ra\u0001\u0003g\f1a[3z\u0003M9W\r^#yK\u000e,Ho\u001c:JIB\u0013XMR5y+\t\t\u00190\u0001\nTa\u0006\u00148nU2bY\u0006,\u00050Z2vi>\u0014\bC\u0001%5'\r!$Q\f\t\u0004)\n}\u0013b\u0001B1+\n1\u0011I\\=SK\u001a$\"A!\u0017\u0002\u00191|w\u000e\u001d)pgRLe.\u001b;\u0015\t\u0005-!\u0011\u000e\u0005\u0006wZ\u0002\r!`\u0001\u000bG\u0006dG.T3uQ>$GC\u0003B\u001b\u0005_\u0012\tHa\u001d\u0003\u0018\"9!QH\u001cA\u0002\tU\u0002b\u0002B!o\u0001\u0007\u00111\u001f\u0005\b\u0005k:\u0004\u0019\u0001B<\u00039\u0001\u0018M]1nKR,'\u000fV=qKN\u0004R\u0001VAT\u0005s\u0002DAa\u001f\u0003\u0006B1\u0011Q\u001fB?\u0005\u0003KAAa \u0003\u0006\t)1\t\\1tgB!!1\u0011BC\u0019\u0001!ABa\"\u0003t\u0005\u0005\t\u0011!B\u0001\u0005\u0013\u00131a\u0018\u00132#\u0011\u0011YI!%\u0011\u0007Q\u0013i)C\u0002\u0003\u0010V\u0013qAT8uQ&tw\rE\u0002U\u0005'K1A!&V\u0005\r\te.\u001f\u0005\b\u00053;\u0004\u0019\u0001BN\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0006)\u0006\u001d&Q\u0007")
public class SparkScalaExecutor
extends SparkEngineConnExecutor {
    private final SparkContext sparkContext;
    private final SQLContext _sqlContext;
    private final SparkSession sparkSession;
    private final SparkConf sparkConf;
    private SparkILoop sparkILoop;
    private boolean bindFlag;
    private final EngineExecutionContextFactory engineExecutionContextFactory;
    private final RsOutputStream lineOutputStream;
    private final PrintWriter jOut;
    private final StringBuilder jobGroup;
    private int executeCount;
    private boolean sparkILoopInited;
    private final File outputDir;
    private final String[] fatalLogs;
    private final ExecutionContextExecutorService executor;

    public static Object callMethod(Object object, String string, Class<?>[] classArray, Object[] objectArray) {
        return SparkScalaExecutor$.MODULE$.callMethod(object, string, classArray, objectArray);
    }

    private SparkContext sparkContext() {
        return this.sparkContext;
    }

    private SQLContext _sqlContext() {
        return this._sqlContext;
    }

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private SparkILoop sparkILoop() {
        return this.sparkILoop;
    }

    private void sparkILoop_$eq(SparkILoop x$1) {
        this.sparkILoop = x$1;
    }

    private boolean bindFlag() {
        return this.bindFlag;
    }

    private void bindFlag_$eq(boolean x$1) {
        this.bindFlag = x$1;
    }

    private EngineExecutionContextFactory engineExecutionContextFactory() {
        return this.engineExecutionContextFactory;
    }

    private RsOutputStream lineOutputStream() {
        return this.lineOutputStream;
    }

    private PrintWriter jOut() {
        return this.jOut;
    }

    private StringBuilder jobGroup() {
        return this.jobGroup;
    }

    private int executeCount() {
        return this.executeCount;
    }

    private void executeCount_$eq(int x$1) {
        this.executeCount = x$1;
    }

    public boolean sparkILoopInited() {
        return this.sparkILoopInited;
    }

    public void sparkILoopInited_$eq(boolean x$1) {
        this.sparkILoopInited = x$1;
    }

    private File outputDir() {
        return this.outputDir;
    }

    private String[] fatalLogs() {
        return this.fatalLogs;
    }

    public ExecutionContextExecutorService executor() {
        return this.executor;
    }

    @Override
    public void init() {
        System.setProperty("scala.repl.name.line", new StringBuilder(5).append("$line").append(this.hashCode()).toString().replace('-', '0'));
        this.setCodeParser((CodeParser)new ScalaCodeParser());
        super.init();
        this.logger().info("spark scala executor start");
    }

    public void lazyInitLoadILoop() {
        if (this.sparkILoop() == null) {
            SparkScalaExecutor sparkScalaExecutor = this;
            synchronized (sparkScalaExecutor) {
                if (this.sparkILoop() == null) {
                    this.createSparkILoop();
                }
            }
        }
        if (this.sparkILoop() != null) {
            if (!this.sparkILoopInited()) {
                SparkILoop sparkILoop = this.sparkILoop();
                synchronized (sparkILoop) {
                    if (!this.sparkILoopInited()) {
                        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.initSparkILoop(), (Function1 & Serializable & scala.Serializable)t -> {
                            SparkScalaExecutor.$anonfun$lazyInitLoadILoop$2(this, t);
                            return BoxedUnit.UNIT;
                        });
                        this.sparkILoopInited_$eq(true);
                    }
                }
            }
        } else {
            throw new SparkSessionNullException(SparkErrorCodeSummary.SPARK_IS_NULL.getErrorCode(), SparkErrorCodeSummary.SPARK_IS_NULL.getErrorDesc());
        }
        Utils$.MODULE$.waitUntil((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.sparkILoopInited() && this.sparkILoop().intp() != null, (Duration)((TimeType)SparkConfiguration$.MODULE$.SPARK_LOOP_INIT_TIME().getValue()).toDuration());
        super.init();
    }

    @Override
    public Kind getKind() {
        return new SparkScala();
    }

    @Override
    public ExecuteResponse runCode(SparkEngineConnExecutor executor, String code, EngineExecutionContext engineExecutionContext, String jobGroup) {
        ExecuteResponse executeResponse;
        Object object = new Object();
        try {
            this.jobGroup().append(jobGroup);
            this.lazyInitLoadILoop();
            if (this.sparkILoop().intp() != null && this.sparkILoop().intp().classLoader() != null) {
                Thread.currentThread().setContextClassLoader((ClassLoader)this.sparkILoop().intp().classLoader());
            }
            EngineExecutionContext engineExecutionContext2 = engineExecutionContext;
            EngineExecutionContext engineExecutionContext3 = this.engineExecutionContextFactory().getEngineExecutionContext();
            if (engineExecutionContext2 == null ? engineExecutionContext3 != null : !engineExecutionContext2.equals(engineExecutionContext3)) {
                this.lineOutputStream().reset(engineExecutionContext);
            }
            this.doBindSparkSession();
            this.lineOutputStream().ready();
            if (this.sparkILoopInited()) {
                this.engineExecutionContextFactory().setEngineExecutionContext(engineExecutionContext);
            }
            ObjectRef res = ObjectRef.create(null);
            if (Thread.currentThread().isInterrupted()) {
                this.logger().error("The thread of execution has been interrupted and the task should be terminated");
                return new ErrorExecuteResponse("The thread of execution has been interrupted and the task should be terminated", null);
            }
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                res$1.elem = this.executeLine(code, engineExecutionContext);
            }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                SparkScalaExecutor.$anonfun$runCode$2(this, object, x0$1);
                return BoxedUnit.UNIT;
            });
            ExecuteResponse executeResponse2 = (ExecuteResponse)res.elem;
            if (executeResponse2 instanceof SuccessExecuteResponse) {
            } else if (executeResponse2 instanceof IncompleteExecuteResponse) {
            } else {
                this.sparkContext().clearJobGroup();
                return (ExecuteResponse)res.elem;
            }
            executeResponse = (ExecuteResponse)res.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                executeResponse = (ExecuteResponse)ex.value();
            }
            throw ex;
        }
        return executeResponse;
    }

    public ExecuteResponse executeLine(String code, EngineExecutionContext engineExecutionContext) {
        if (this.sparkContext().isStopped()) {
            this.logger().error("Spark application has already stopped, please restart it.");
            throw new ApplicationAlreadyStoppedException(SparkErrorCodeSummary.SPARK_STOPPED.getErrorCode(), SparkErrorCodeSummary.SPARK_STOPPED.getErrorDesc());
        }
        this.executeCount_$eq(this.executeCount() + 1);
        PrintStream originalOut = System.out;
        Product result = (Product)Console$.MODULE$.withOut((OutputStream)this.lineOutputStream(), (Function0 & Serializable & scala.Serializable)() -> {
            Results.Result result = (Results.Result)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret(code), (Function1 & Serializable & scala.Serializable)t -> {
                Object object;
                this.logger().error("task error info:", t);
                String msg = ExceptionUtils.getRootCauseMessage((Throwable)t);
                if (this.matchFatalLog(msg)) {
                    this.logger().error("engine oom now to set status to shutdown");
                    object = BoxesRunTime.boxToBoolean((boolean)ExecutorManager$.MODULE$.getInstance().getReportExecutor().tryShutdown());
                } else {
                    object = BoxedUnit.UNIT;
                }
                engineExecutionContext.appendStdout(new StringBuilder(17).append("task error info: ").append(msg).toString());
                return Results$Error$.MODULE$;
            });
            if (Results.Success$.MODULE$.equals(result)) {
                this.lineOutputStream().flush();
                engineExecutionContext.appendStdout(new StringBuilder(7).append("scala> ").append(code).toString());
                String outStr = this.lineOutputStream().toString();
                if (outStr.length() > 0) {
                    String res;
                    Record[] output = (Record[])Utils$.MODULE$.tryQuietly((Function0 & Serializable & scala.Serializable)() -> ResultSetWriterFactory.getRecordByRes((String)outStr, (long)BoxesRunTime.unboxToInt((Object)SparkConfiguration$.MODULE$.SPARK_CONSOLE_OUTPUT_NUM().getValue())));
                    String string = res = output != null ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output)).map((Function1 & Serializable & scala.Serializable)x -> x.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList().mkString("\n") : "";
                    if (res.length() > 0) {
                        engineExecutionContext.appendStdout(res);
                    }
                }
                return new SuccessExecuteResponse();
            }
            if (Results.Incomplete$.MODULE$.equals(result)) {
                return new IncompleteExecuteResponse(null);
            }
            if (Results$Error$.MODULE$.equals(result)) {
                Object object;
                if (Thread.currentThread().isInterrupted()) {
                    this.logger().error("The thread of execution has been interrupted and the task should be terminated");
                    Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((OutputStream)this.lineOutputStream()));
                    return new ErrorExecuteResponse("The thread of execution has been interrupted and the task should be terminated", null);
                }
                this.lineOutputStream().flush();
                String output = this.lineOutputStream().toString();
                IOUtils.closeQuietly((OutputStream)this.lineOutputStream());
                String errorMsg = null;
                if (StringUtils.isNotBlank((CharSequence)output)) {
                    errorMsg = (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> EngineUtils$.MODULE$.getResultStrByDolphinTextContent(output), (Function1 & Serializable & scala.Serializable)t -> t.getMessage());
                    this.logger().error(new StringBuilder(23).append("Execute code error for ").append(errorMsg).toString());
                    engineExecutionContext.appendStdout(new StringBuilder(23).append("Execute code error for ").append(errorMsg).toString());
                    if (this.matchFatalLog(errorMsg)) {
                        this.logger().error("engine log fatal logs now to set status to shutdown");
                        object = BoxesRunTime.boxToBoolean((boolean)ExecutorManager$.MODULE$.getInstance().getReportExecutor().tryShutdown());
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    this.logger().error("No error message is captured, please see the detailed log");
                    object = BoxedUnit.UNIT;
                }
                return new ErrorExecuteResponse(errorMsg, (Throwable)((Object)new ExecuteError(SparkErrorCodeSummary.EXECUTE_SPARKSCALA_FAILED.getErrorCode(), SparkErrorCodeSummary.EXECUTE_SPARKSCALA_FAILED.getErrorDesc())));
            }
            throw new MatchError((Object)result);
        });
        System.setOut(originalOut);
        return (ExecuteResponse)result;
    }

    private boolean matchFatalLog(String errorMsg) {
        BooleanRef flag;
        block0: {
            flag = BooleanRef.create((boolean)false);
            if (!StringUtils.isNotBlank((CharSequence)errorMsg)) break block0;
            String errorMsgLowCase = errorMsg.toLowerCase(Locale.getDefault());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fatalLogs())).foreach((Function1 & Serializable & scala.Serializable)fatalLog -> {
                SparkScalaExecutor.$anonfun$matchFatalLog$1(this, errorMsgLowCase, flag, fatalLog);
                return BoxedUnit.UNIT;
            });
        }
        return flag.elem;
    }

    private void createSparkILoop() {
        this.logger().info(new StringBuilder(15).append("outputDir====> ").append(this.outputDir()).toString());
        this.sparkILoop_$eq((SparkILoop)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> new SparkILoop((Option)None$.MODULE$, this.jOut()), (Function1 & Serializable & scala.Serializable)t -> {
            this.logger().error("create ILoop failed", t);
            return null;
        }));
    }

    private void doBindSparkSession() {
        if (!this.bindFlag()) {
            this.bindSparkSession();
            return;
        }
    }

    private void initSparkILoop() {
        Seq seq;
        GenericRunnerSettings settings = new GenericRunnerSettings((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.error((Function0 & Serializable & scala.Serializable)() -> x$1);
            return BoxedUnit.UNIT;
        });
        Option sparkJars = this.sparkConf().getOption("spark.jars");
        if (this.sparkConf().get("spark.master").contains("yarn")) {
            Option yarnJars = this.sparkConf().getOption("spark.yarn.dist.jars");
            seq = SparkUtils$.MODULE$.unionFileLists((Option<String>)sparkJars, (Option<String>)yarnJars).toSeq();
        } else {
            seq = (Seq)Option$.MODULE$.option2Iterable(sparkJars.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split(",")).map((Function1 & Serializable & scala.Serializable)x$3 -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3)).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SparkScalaExecutor.$anonfun$initSparkILoop$5(x$4))))).toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)));
        }
        Seq jars = seq;
        String[] classpathJars = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])System.getProperty("java.class.path").split(":"))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.endsWith(".jar")));
        String classpath = new StringBuilder(0).append(jars.mkString(File.pathSeparator)).append(File.pathSeparator).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classpathJars)).mkString(File.pathSeparator)).toString();
        this.logger().debug(new StringBuilder(22).append("Spark shell add jars: ").append(classpath).toString());
        settings.processArguments((List)new .colon.colon((Object)"-Yrepl-class-based", (List)new .colon.colon((Object)"-Yrepl-outdir", (List)new .colon.colon((Object)String.valueOf(this.outputDir().getAbsolutePath()), (List)new .colon.colon((Object)"-classpath", (List)new .colon.colon((Object)classpath, (List)Nil$.MODULE$))))), true);
        settings.usejavacp().value_$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        settings.embeddedDefaults(SparkUtils$.MODULE$.getClass().getClassLoader());
        this.sparkILoop().settings_$eq((Settings)settings);
        this.sparkILoop().createInterpreter();
        boolean isScala211 = Properties$.MODULE$.versionNumberString().startsWith("2.11");
        Option in0 = isScala211 ? (Option)this.getField(this.sparkILoop(), "scala$tools$nsc$interpreter$ILoop$$in0") : (Option)FieldUtils.readDeclaredField((Object)this.sparkILoop(), (String)"in0", (boolean)true);
        InteractiveReader reader = (InteractiveReader)in0.fold((Function0 & Serializable & scala.Serializable)() -> this.sparkILoop().chooseReader((Settings)settings), (Function1 & Serializable & scala.Serializable)r -> SimpleReader$.MODULE$.apply(r, this.jOut(), true));
        this.sparkILoop().in_$eq(reader);
        ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).initializeSynchronous();
        SparkScalaExecutor$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SparkScalaExecutor$$loopPostInit(this.sparkILoop());
    }

    public Object getField(Object obj, String name) {
        Field field = obj.getClass().getField(name);
        field.setAccessible(true);
        return field.get(obj);
    }

    public void bindSparkSession() {
        Predef$.MODULE$.require(this.sparkContext() != null);
        Predef$.MODULE$.require(this.sparkSession() != null);
        Predef$.MODULE$.require(this._sqlContext() != null);
        long startTime = System.currentTimeMillis();
        Utils$.MODULE$.waitUntil((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.sparkILoop().intp() != null && this.sparkILoop().intp().isInitializeComplete(), (Duration)((TimeType)SparkConfiguration$.MODULE$.SPARK_LANGUAGE_REPL_INIT_TIME().getValue()).toDuration());
        this.logger().warn(new StringBuilder(31).append("Start to init sparkILoop cost ").append(ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))).append(".").toString());
        ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).beSilentDuring((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sparkILoop().command(":silent");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).bind("sc", "org.apache.spark.SparkContext", (Object)this.sparkContext(), (List)new .colon.colon((Object)"@transient", (List)Nil$.MODULE$));
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).bind("spark", "org.apache.spark.sql.SparkSession", (Object)this.sparkSession(), (List)new .colon.colon((Object)"@transient", (List)Nil$.MODULE$));
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).bind("sqlContext", "org.apache.spark.sql.SQLContext", (Object)this._sqlContext(), (List)new .colon.colon((Object)"@transient", (List)Nil$.MODULE$));
            IMain qual$1 = ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop());
            String x$1 = "engineExecutionContextFactory";
            String x$2 = "org.apache.linkis.engineplugin.spark.executor.EngineExecutionContextFactory";
            EngineExecutionContextFactory x$3 = this.engineExecutionContextFactory();
            List x$4 = qual$1.bind$default$4();
            qual$1.bind(x$1, x$2, (Object)x$3, x$4);
            IMain qual$2 = ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop());
            String x$5 = "jobGroup";
            String x$6 = "java.lang.StringBuilder";
            StringBuilder x$7 = this.jobGroup();
            List x$8 = qual$2.bind$default$4();
            qual$2.bind(x$5, x$6, (Object)x$7, x$8);
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.spark.SparkContext");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.spark.SparkContext._");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.spark.sql.SparkSession");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.spark.sql.SQLContext");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.spark.sql.DataFrame");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.linkis.engineplugin.spark.executor.SQLSession.showDF");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.linkis.engineplugin.spark.executor.SQLSession.showHTML");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import sqlContext.sql");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import sqlContext._");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import spark.implicits._");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import spark.sql");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.spark.sql.functions._");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.linkis.engineplugin.spark.executor.EngineExecutionContextFactory");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("def showAlias(df: DataFrame, alias:String): Unit = showDF(sparkContext, jobGroup.toString, df, alias,10000, engineExecutionContextFactory.getEngineExecutionContext)");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("def show(df: DataFrame): Unit = showDF(sparkContext, jobGroup.toString, df,\"\",10000, engineExecutionContextFactory.getEngineExecutionContext)");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("def showHtml(content: Any): Unit = showHTML(sparkContext, jobGroup.toString, content, engineExecutionContextFactory.getEngineExecutionContext)");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.spark.sql.execution.datasources.csv._");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("import org.apache.spark.sql.UDFRegistration");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("val udf = UDF");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("implicit def toUDFMethod(udf: UDF.type): UDFRegistration = sqlContext.udf");
            ILoop$.MODULE$.loopToInterpreter((ILoop)this.sparkILoop()).interpret("implicit val sparkSession = spark");
            this.bindFlag_$eq(true);
            this.logger().warn(new StringBuilder(34).append("Finished to init sparkILoop cost ").append(ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))).append(".").toString());
        });
    }

    public Option<String> getOption(String key) {
        String value = (String)SparkConfiguration$.MODULE$.SPARK_REPL_CLASSDIR().getValue();
        return new Some((Object)value);
    }

    @Override
    public String getExecutorIdPreFix() {
        return "SparkScalaExecutor_";
    }

    public static final /* synthetic */ void $anonfun$lazyInitLoadILoop$2(SparkScalaExecutor $this, Throwable t) {
        $this.logger().error("init failed: ", t);
    }

    public static final /* synthetic */ void $anonfun$runCode$2(SparkScalaExecutor $this, Object nonLocalReturnKey1$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.sparkContext().clearJobGroup();
            $this.logger().error("Interpreter exception", (Throwable)exception);
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new ErrorExecuteResponse("Interpreter exception", (Throwable)exception));
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$matchFatalLog$1(SparkScalaExecutor $this, String errorMsgLowCase$1, BooleanRef flag$1, String fatalLog) {
        if (errorMsgLowCase$1.contains(fatalLog)) {
            $this.logger().error(new StringBuilder(35).append("match engineConn log fatal logs,is ").append(fatalLog).toString());
            flag$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$initSparkILoop$5(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public SparkScalaExecutor(SparkEngineSession sparkEngineSession, long id) {
        super(sparkEngineSession.sparkContext(), id);
        this.sparkContext = sparkEngineSession.sparkContext();
        this._sqlContext = sparkEngineSession.sqlContext();
        this.sparkSession = sparkEngineSession.sparkSession();
        this.sparkConf = this.sparkContext().getConf();
        this.bindFlag = false;
        this.engineExecutionContextFactory = new EngineExecutionContextFactory();
        this.lineOutputStream = new RsOutputStream();
        this.jOut = new PrintWriter((OutputStream)this.lineOutputStream(), true);
        this.jobGroup = new StringBuilder();
        this.executeCount = 0;
        this.sparkILoopInited = false;
        this.outputDir = sparkEngineSession.outputDir();
        this.fatalLogs = ((String)SparkConfiguration$.MODULE$.ENGINE_SHUTDOWN_LOGS().getValue()).split(";");
        this.executor = Utils$.MODULE$.newCachedExecutionContext(5, "Spark-Scala-REPL-Thread-", true);
    }
}

