/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ContextAwarePropertySource;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.ReloadablePropertySource;

public class PropertiesPropertySource
extends ContextAwarePropertySource
implements ReloadablePropertySource {
    private final int priority;
    private final Properties properties;

    public PropertiesPropertySource(Properties properties) {
        this(properties, "*", 200, false);
    }

    public PropertiesPropertySource(Properties properties, int priority) {
        this(properties, "*", priority, false);
    }

    public PropertiesPropertySource(Properties properties, String contextName, int priority) {
        this(properties, contextName, priority, false);
    }

    public PropertiesPropertySource(Properties properties, String contextName, int priority, boolean includeInvalid) {
        super(properties, contextName, includeInvalid);
        this.priority = priority;
        this.properties = properties;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        Properties properties = (Properties)this.propertiesMap.get("*");
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                action.accept((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        CharSequence result = PropertySource.Util.join(tokens);
        return result.length() > 0 ? "log4j2." + result : null;
    }

    @Override
    public void reload() {
        Map<String, Properties> map = this.parseProperties(this.properties);
        this.propertiesMap.putAll(map);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesPropertySource that = (PropertiesPropertySource)o;
        return this.priority == that.priority && this.propertiesMap.equals(that.propertiesMap);
    }

    public int hashCode() {
        return Objects.hash(this.propertiesMap, this.priority);
    }
}

