/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-reference-level.xml")
public class AppenderRefLevelTest {
    private final ListAppender app1;
    private final ListAppender app2;
    Logger logger1;
    Logger logger2;
    Logger logger3;
    Marker testMarker = MarkerManager.getMarker((String)"TEST");

    public AppenderRefLevelTest(LoggerContext context, @Named(value="LIST1") ListAppender first, @Named(value="LIST2") ListAppender second) {
        this.logger1 = context.getLogger("org.apache.logging.log4j.test1");
        this.logger2 = context.getLogger("org.apache.logging.log4j.test2");
        this.logger3 = context.getLogger("org.apache.logging.log4j.test3");
        this.app1 = first.clear();
        this.app2 = second.clear();
    }

    @Test
    public void logger1() {
        this.logger1.traceEntry();
        this.logger1.debug("debug message");
        this.logger1.error("Test Message");
        this.logger1.info("Info Message");
        this.logger1.warn("warn Message");
        this.logger1.traceExit();
        List<LogEvent> events = this.app1.getEvents();
        Assertions.assertEquals((int)6, (int)events.size(), (String)("Incorrect number of events. Expected 6, actual " + events.size()));
        events = this.app2.getEvents();
        Assertions.assertEquals((int)1, (int)events.size(), (String)("Incorrect number of events. Expected 1, actual " + events.size()));
    }

    @Test
    public void logger2() {
        this.logger2.traceEntry();
        this.logger2.debug("debug message");
        this.logger2.error("Test Message");
        this.logger2.info("Info Message");
        this.logger2.warn("warn Message");
        this.logger2.traceExit();
        List<LogEvent> events = this.app1.getEvents();
        Assertions.assertEquals((int)events.size(), (int)2, (String)("Incorrect number of events. Expected 2, actual " + events.size()));
        events = this.app2.getEvents();
        Assertions.assertEquals((int)events.size(), (int)4, (String)("Incorrect number of events. Expected 4, actual " + events.size()));
    }

    @Test
    public void logger3() {
        this.logger3.traceEntry();
        this.logger3.debug(this.testMarker, "debug message");
        this.logger3.error("Test Message");
        this.logger3.info(this.testMarker, "Info Message");
        this.logger3.warn("warn Message");
        this.logger3.traceExit();
        List<LogEvent> events = this.app1.getEvents();
        Assertions.assertEquals((int)4, (int)events.size(), (String)("Incorrect number of events. Expected 4, actual " + events.size()));
    }
}

