/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-customLevels.xml")
public class CustomLevelsOverrideTest {
    private final ListAppender listAppender;
    private final Level warnLevel = Level.getLevel((String)"WARN");
    private final Level infoLevel = Level.getLevel((String)"INFO");
    private final Level debugLevel = Level.getLevel((String)"DEBUG");
    private final Logger logger;

    public CustomLevelsOverrideTest(LoggerContext context, @Named(value="List1") ListAppender appender) {
        this.listAppender = appender.clear();
        this.logger = context.getLogger(this.getClass().getName());
    }

    @Test
    public void testCustomLevelInts() {
        Assertions.assertNotEquals((int)350, (int)this.warnLevel.intLevel());
        Assertions.assertNotEquals((int)450, (int)this.infoLevel.intLevel());
        Assertions.assertNotEquals((int)550, (int)this.debugLevel.intLevel());
    }

    @Test
    public void testCustomLevelPresence() {
        Assertions.assertNotNull((Object)this.warnLevel);
        Assertions.assertNotNull((Object)this.infoLevel);
        Assertions.assertNotNull((Object)this.debugLevel);
    }

    @Test
    public void testCustomLevelVsStdLevel() {
        Assertions.assertEquals((Object)Level.WARN, (Object)this.warnLevel);
        Assertions.assertEquals((Object)Level.INFO, (Object)this.infoLevel);
        Assertions.assertEquals((Object)Level.DEBUG, (Object)this.debugLevel);
    }

    @Test
    public void testLog() {
        MatcherAssert.assertThat(this.listAppender.getEvents(), (Matcher)Matchers.hasSize((int)0));
        this.logger.debug("Hello, {}", (Object)"World");
        MatcherAssert.assertThat(this.listAppender.getEvents(), (Matcher)Matchers.hasSize((int)1));
        this.logger.log(this.warnLevel, "Hello DIAG");
        MatcherAssert.assertThat(this.listAppender.getEvents(), (Matcher)Matchers.hasSize((int)2));
        Assertions.assertEquals((Object)this.listAppender.getEvents().get(1).getLevel(), (Object)this.warnLevel);
    }
}

