/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.GarbageCollectionHelper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class EventParameterMemoryLeakTest {
    @BeforeAll
    public static void beforeClass() {
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.enable.direct.encoders", "true");
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("log4j.configurationFile", "EventParameterMemoryLeakTest.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParametersAreNotLeaked() throws Exception {
        File file = new File("target", "EventParameterMemoryLeakTest.log");
        Assertions.assertTrue((!file.exists() || file.delete() ? 1 : 0) != 0, (String)"Deleted old file before test");
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        CountDownLatch latch = new CountDownLatch(1);
        ParameterObject parameter = new ParameterObject("paramValue", latch);
        log.info("Message with parameter {}", (Object)parameter);
        log.info((Object)parameter);
        log.info("test", (Throwable)new ObjectThrowable(parameter));
        log.info("test {}", (Object)"hello", (Object)new ObjectThrowable(parameter));
        parameter = null;
        CoreLoggerContexts.stopLoggerContext(file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        String line2 = reader.readLine();
        String line3 = reader.readLine();
        String line4 = reader.readLine();
        String line5 = reader.readLine();
        reader.close();
        file.delete();
        MatcherAssert.assertThat((Object)line1, (Matcher)Matchers.containsString((String)"Message with parameter paramValue"));
        MatcherAssert.assertThat((Object)line2, (Matcher)Matchers.containsString((String)"paramValue"));
        MatcherAssert.assertThat((Object)line3, (Matcher)Matchers.containsString((String)"paramValue"));
        MatcherAssert.assertThat((Object)line4, (Matcher)Matchers.containsString((String)"paramValue"));
        Assertions.assertNull((Object)line5, (String)"Expected only three lines");
        gcHelper.run();
        try (GarbageCollectionHelper gcHelper = new GarbageCollectionHelper();){
            Assertions.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS), (String)"Parameter should have been garbage collected");
        }
    }

    private static final class ObjectThrowable
    extends RuntimeException {
        private final Object object;

        ObjectThrowable(Object object) {
            super(String.valueOf(object));
            this.object = object;
        }

        @Override
        public String toString() {
            return "ObjectThrowable " + this.object;
        }
    }

    private static final class ParameterObject {
        private final String value;
        private final CountDownLatch latch;

        ParameterObject(String value, CountDownLatch latch) {
            this.value = value;
            this.latch = latch;
        }

        public String toString() {
            return this.value;
        }

        protected void finalize() throws Throwable {
            this.latch.countDown();
            super.finalize();
        }
    }
}

