/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.GarbageCollectionHelper;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.ReusableMessageFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReusableParameterizedMessageMemoryLeakTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParametersAreNotLeaked() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ReusableMessage message = (ReusableMessage)ReusableMessageFactory.INSTANCE.newMessage("foo {}", (Object)new ParameterObject("paramValue", latch));
        message.swapParameters(new Object[5]);
        gcHelper.run();
        try (GarbageCollectionHelper gcHelper = new GarbageCollectionHelper();){
            Assertions.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS), (String)"Parameter should have been garbage collected");
        }
    }

    private static final class ParameterObject {
        private final String value;
        private final CountDownLatch latch;

        ParameterObject(String value, CountDownLatch latch) {
            this.value = value;
            this.latch = latch;
        }

        public String toString() {
            return this.value;
        }

        protected void finalize() throws Throwable {
            this.latch.countDown();
            super.finalize();
        }
    }
}

