/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactoryTest;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.TimestampMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j2-744.xml")
public class TimestampMessageTest {
    private ListAppender app;

    public TimestampMessageTest(@Named(value="List") ListAppender app) {
        this.app = app.clear();
    }

    @BeforeAll
    public static void beforeClass() {
        System.setProperty("log4j.Clock", PoisonClock.class.getName());
    }

    @AfterAll
    public static void afterClass() throws IllegalAccessException {
        System.setProperty("Log4jContextSelector", "");
        ClockFactoryTest.resetClocks();
    }

    @Test
    public void testTimestampMessage(LoggerContext context) {
        Logger log = context.getLogger("TimestampMessageTest");
        log.info((Message)new TimeMsg("Message with embedded timestamp", 123456789000L));
        List<String> msgs = this.app.getMessages();
        Assertions.assertNotNull(msgs);
        Assertions.assertEquals((int)1, (int)msgs.size());
        String NL = System.lineSeparator();
        Assertions.assertEquals((Object)("123456789000 Message with embedded timestamp" + NL), (Object)msgs.get(0));
    }

    static class TimeMsg
    extends SimpleMessage
    implements TimestampMessage {
        private static final long serialVersionUID = 1L;
        private final long timestamp;

        public TimeMsg(String msg, long timestamp) {
            super(msg);
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class PoisonClock
    implements Clock {
        public long currentTimeMillis() {
            throw new RuntimeException("This should not have been called");
        }
    }
}

