/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.appender.AsyncAppenderEventDispatcher;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

class AsyncAppenderTest {
    AsyncAppenderTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rewriteTest(LoggerContext context) throws InterruptedException {
        List<String> messages;
        ExtendedLogger logger = context.getLogger(AsyncAppender.class);
        logger.error("This is a test");
        logger.warn("Hello world!");
        ListAppender appender = (ListAppender)context.getConfiguration().getAppender("List");
        try {
            messages = appender.getMessages(2, 2L, TimeUnit.SECONDS);
        }
        finally {
            appender.clear();
        }
        Assertions.assertNotNull(messages);
        Assertions.assertEquals((int)2, (int)messages.size());
        String messagePrefix = AsyncAppenderTest.class.getName() + " rewriteTest ";
        Assertions.assertEquals((Object)(messagePrefix + "This is a test"), (Object)messages.get(0));
        Assertions.assertEquals((Object)(messagePrefix + "Hello world!"), (Object)messages.get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exceptionTest(LoggerContext context) throws InterruptedException {
        List<String> messages;
        ExtendedLogger logger = context.getLogger(AsyncAppender.class);
        IllegalStateException parent = new IllegalStateException("Test");
        LoggingException child = new LoggingException("This is a test", (Throwable)parent);
        logger.error("This is a test", (Throwable)child);
        ListAppender appender = (ListAppender)context.getConfiguration().getAppender("List");
        try {
            messages = appender.getMessages(1, 2L, TimeUnit.SECONDS);
        }
        finally {
            appender.clear();
        }
        Assertions.assertNotNull(messages);
        Assertions.assertEquals((int)1, (int)messages.size());
        Assertions.assertTrue((boolean)messages.get(0).contains(parent.getClass().getName()));
    }

    @Test
    @LoggerContextSource(value="log4j-asynch.xml")
    void defaultAsyncAppenderConfig(LoggerContext context) throws InterruptedException {
        AsyncAppenderTest.rewriteTest(context);
        AsyncAppenderTest.exceptionTest(context);
        List backgroundThreads = Thread.getAllStackTraces().keySet().stream().filter(AsyncAppenderEventDispatcher.class::isInstance).collect(Collectors.toList());
        Assertions.assertFalse((boolean)backgroundThreads.isEmpty(), (String)"Failed to locate background thread");
        for (Thread thread : backgroundThreads) {
            Assertions.assertTrue((boolean)thread.isDaemon(), (String)"AsyncAppender should use daemon threads");
        }
    }

    @Test
    @LoggerContextSource(value="BlockingQueueFactory-ArrayBlockingQueue.xml")
    void arrayBlockingQueue(LoggerContext context) throws InterruptedException {
        AsyncAppenderTest.rewriteTest(context);
        AsyncAppenderTest.exceptionTest(context);
    }

    @Test
    @Tag(value="disruptor")
    @LoggerContextSource(value="BlockingQueueFactory-DisruptorBlockingQueue.xml")
    void disruptorBlockingQueue(LoggerContext context) throws InterruptedException {
        AsyncAppenderTest.rewriteTest(context);
        AsyncAppenderTest.exceptionTest(context);
    }

    @Test
    @Tag(value="jctools")
    @LoggerContextSource(value="BlockingQueueFactory-JCToolsBlockingQueue.xml")
    void jcToolsBlockingQueue(LoggerContext context) throws InterruptedException {
        AsyncAppenderTest.rewriteTest(context);
        AsyncAppenderTest.exceptionTest(context);
    }

    @Test
    @LoggerContextSource(value="BlockingQueueFactory-LinkedTransferQueue.xml")
    void linkedTransferQueue(LoggerContext context) throws InterruptedException {
        AsyncAppenderTest.rewriteTest(context);
        AsyncAppenderTest.exceptionTest(context);
    }

    @Test
    @Timeout(value=5L)
    @LoggerContextSource(value="log4j-asynch-shutdownTimeout.xml")
    void shutdownTimeout(LoggerContext context) {
        context.getLogger("Logger").info("This is a test");
        context.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @LoggerContextSource(value="log4j-asynch-no-location.xml")
    void noLocationInformation(LoggerContext context, @Named(value="List") ListAppender appender) throws InterruptedException {
        List<String> messages;
        ExtendedLogger logger = context.getLogger(this.getClass());
        logger.error("This is a test");
        logger.warn("Hello world!");
        try {
            messages = appender.getMessages(2, 2L, TimeUnit.SECONDS);
        }
        finally {
            appender.clear();
        }
        Assertions.assertNotNull(messages);
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)"?  This is a test", (Object)messages.get(0));
        Assertions.assertEquals((Object)"?  Hello world!", (Object)messages.get(1));
    }
}

