/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;

@Category(value={Layouts.Csv.class})
public class CsvJsonParameterLayoutFileAppenderTest {
    private static final String FILE_PATH = "target/CsvJsonParameterLayoutFileAppenderTest.log";
    private static final LoggerContextRule loggerContextRule = new LoggerContextRule("log4j-cvs-json-parameter.xml");
    @Rule
    public RuleChain rule = loggerContextRule.withCleanFilesRule("target/CsvJsonParameterLayoutFileAppenderTest.log");

    public void testNoNulCharacters(String message, String expected) throws IOException {
        LoggerContext loggerContext = loggerContextRule.getLoggerContext();
        Logger logger = loggerContext.getLogger("com.example");
        logger.error("log:", (Object)message);
        loggerContext.stop();
        File file = new File(FILE_PATH);
        byte[] contents = Files.toByteArray((File)file);
        int count0s = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < contents.length; ++i) {
            byte b = contents[i];
            if (b != 0) continue;
            sb.append(i);
            sb.append(", ");
            ++count0s;
        }
        Assert.assertEquals((String)("File contains " + count0s + " 0x00 byte at indices " + sb), (long)0L, (long)count0s);
        List readLines = Files.readLines((File)file, (Charset)Charset.defaultCharset());
        String actual = (String)readLines.get(0);
        Assert.assertEquals((String)actual, (Object)expected, (Object)actual);
        Assert.assertEquals((long)1L, (long)readLines.size());
    }

    @Test
    public void testNoNulCharactersDoubleQuote() throws IOException {
        this.testNoNulCharacters("\"", "\"\"\"\"");
    }

    @Test
    public void testNoNulCharactersJson() throws IOException {
        this.testNoNulCharacters("{\"id\":10,\"name\":\"Alice\"}", "\"{\"\"id\"\":10,\"\"name\"\":\"\"Alice\"\"}\"");
    }

    @Test
    public void testNoNulCharactersOneChar() throws IOException {
        this.testNoNulCharacters("A", "A");
    }

    @Test
    public void testNoNulCharactersOpenCurly() throws IOException {
        this.testNoNulCharacters("{", "{");
    }

    @Test
    public void testNoNulCharactersOpenParen() throws IOException {
        this.testNoNulCharacters("(", "(");
    }

    @Test
    public void testNoNulCharactersOpenSquare() throws IOException {
        this.testNoNulCharacters("[", "[");
    }

    public void testNoNulCharactersThreeChars() throws IOException {
        this.testNoNulCharacters("ABC", "ABC");
    }

    @Test
    public void testNoNulCharactersXml() throws IOException {
        this.testNoNulCharacters("<test attr1='val1' attr2=\"value2\">X</test>", "\"<test attr1='val1' attr2=\"\"value2\"\">X</test>\"");
    }
}

