/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.test.appender.InMemoryAppender;
import org.apache.logging.log4j.util.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InMemoryAppenderTest {
    @Test
    public void testAppender() {
        PatternLayout layout = PatternLayout.createDefaultLayout();
        boolean writeHeader = true;
        InMemoryAppender app = new InMemoryAppender("test", (Layout<? extends Serializable>)layout, null, false, true);
        String expectedHeader = null;
        this.assertMessage("Test", app, expectedHeader);
    }

    @Test
    public void testHeaderRequested() {
        PatternLayout layout = PatternLayout.newBuilder().withHeader("HEADERHEADER").build();
        boolean writeHeader = true;
        InMemoryAppender app = new InMemoryAppender("test", (Layout<? extends Serializable>)layout, null, false, true);
        String expectedHeader = "HEADERHEADER";
        this.assertMessage("Test", app, "HEADERHEADER");
    }

    @Test
    public void testHeaderSuppressed() {
        PatternLayout layout = PatternLayout.newBuilder().withHeader("HEADERHEADER").build();
        boolean writeHeader = false;
        InMemoryAppender app = new InMemoryAppender("test", (Layout<? extends Serializable>)layout, null, false, false);
        String expectedHeader = null;
        this.assertMessage("Test", app, expectedHeader);
    }

    private void assertMessage(String string, InMemoryAppender app, String header) {
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("TestLogger").setLoggerFqcn(InMemoryAppenderTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Test")).build();
        app.start();
        Assertions.assertTrue((boolean)app.isStarted(), (String)"Appender did not start");
        app.append((LogEvent)event);
        app.append((LogEvent)event);
        String msg = app.toString();
        Assertions.assertNotNull((Object)msg, (String)"No message");
        String expectedHeader = header == null ? "" : header;
        String expected = expectedHeader + "Test" + Strings.LINE_SEPARATOR + "Test" + Strings.LINE_SEPARATOR;
        Assertions.assertEquals((Object)expected, (Object)msg, (String)("Incorrect message: " + msg));
        app.stop();
        Assertions.assertFalse((boolean)app.isStarted(), (String)"Appender did not stop");
    }
}

