/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.kafka;

import org.apache.logging.log4j.categories.Appenders;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.Test;

@Category(value={Appenders.Kafka.class})
@LoggerContextSource(value="KafkaManagerProducerThreadLeakTest.xml")
class KafkaManagerProducerThreadLeakTest {
    KafkaManagerProducerThreadLeakTest() {
    }

    @Test
    void context_restart_shouldnt_leak_producer_threads(LoggerContext context) {
        int initialThreadCount = KafkaManagerProducerThreadLeakTest.kafkaProducerThreadCount();
        int contextRestartCount = 3;
        for (int i = 0; i < 3; ++i) {
            context.reconfigure();
        }
        int lastThreadCount = KafkaManagerProducerThreadLeakTest.kafkaProducerThreadCount();
        Assert.assertEquals((long)initialThreadCount, (long)lastThreadCount);
    }

    private static int kafkaProducerThreadCount() {
        long threadCount = Thread.getAllStackTraces().keySet().stream().filter(thread -> thread.getName().startsWith("kafka-producer")).count();
        return Math.toIntExact(threadCount);
    }
}

