/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;

public class RollingAppenderCronOnStartupTest {
    private static final String CONFIG = "log4j-rolling-cron-onStartup.xml";
    private static final String DIR = "target/rolling-cron-onStartup";
    private static final String FILE = "target/rolling-cron-onStartup/rollingtest.log";
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private LoggerContext context;

    @AfterAll
    public static void after() {
        File dir = new File(DIR);
        if (dir.exists()) {
            RollingAppenderCronOnStartupTest.cleanDir(dir);
            dir.delete();
        }
    }

    @AfterEach
    public void afterEach() {
        if (this.context != null) {
            this.context.stop();
        }
    }

    @Test
    public void testAppender() throws Exception {
        File dir = new File(DIR);
        if (dir.exists()) {
            RollingAppenderCronOnStartupTest.cleanDir(dir);
        } else {
            dir.mkdirs();
        }
        File file = new File(FILE);
        String today = formatter.format(LocalDate.now());
        File rolled = new File("target/rolling-cron-onStartup/test1-" + today + ".log");
        PrintStream ps = new PrintStream(new FileOutputStream(file));
        ps.println("This is a line2");
        ps.close();
        ps = new PrintStream(new FileOutputStream(rolled));
        ps.println("This is a line 1");
        ps.close();
        Assert.assertTrue((String)"Log file does not exist", (boolean)file.exists());
        Assert.assertTrue((String)"Log file does not exist", (boolean)rolled.exists());
        LoggerContext lc = Configurator.initialize((String)"Test", (String)CONFIG);
        ExtendedLogger logger = lc.getLogger(RollingAppenderCronOnStartupTest.class);
        logger.info("This is line 3");
        File[] files = dir.listFiles();
        Assert.assertNotNull((String)"No files", (Object)files);
        Assert.assertEquals((String)("Unexpected number of files. Expected 2 but found " + files.length), (long)2L, (long)files.length);
        List<String> lines = Files.readAllLines(file.toPath());
        Assert.assertEquals((String)("Unexpected number of lines. Expected 2: Actual: " + lines.size()), (long)2L, (long)lines.size());
        lines = Files.readAllLines(rolled.toPath());
        Assert.assertEquals((String)("Unexpected number of lines. Expected 1: Actual: " + lines.size()), (long)1L, (long)lines.size());
    }

    private static void cleanDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            Arrays.stream(files).forEach(File::delete);
        }
    }
}

