/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDirectWriteTest {
    private static final String CONFIG = "log4j-rolling-direct.xml";
    private static final String DIR = "target/rolling-direct";
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-direct.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling-direct");
    private Logger logger;

    @Before
    public void setUp() throws Exception {
        this.logger = loggerContextRule.getLogger(RollingAppenderDirectWriteTest.class.getName());
    }

    @Test
    public void testAppender() throws Exception {
        int count = 100;
        for (int i = 0; i < 100; ++i) {
            this.logger.debug("This is test message number " + i);
        }
        Thread.sleep(50L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
        File[] files = dir.listFiles();
        Assert.assertNotNull((Object)files);
        Assert.assertThat((Object)files, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".gz"))))));
        int found = 0;
        for (File file : files) {
            String line;
            String actual = file.getName();
            BufferedReader reader = file.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file)))) : new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                Assert.assertNotNull((String)("No log event in file " + actual), (Object)line);
                String[] parts = line.split(" ");
                String expected = "test1-" + parts[0];
                Assert.assertTrue((String)("Incorrect file name. Expected file prefix: " + expected + " Actual: " + actual), (boolean)actual.startsWith(expected));
                ++found;
            }
            reader.close();
        }
        Assert.assertEquals((String)("Incorrect number of events read. Expected 100, Actual " + found), (long)100L, (long)found);
    }
}

