/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RollingAppenderOnStartupDirectTest {
    private static final String SOURCE = "src/test/resources/__files";
    private static final String DIR = "target/onStartup";
    private static final String CONFIG = "log4j-rollOnStartupDirect.xml";
    private static final String FILENAME = "onStartup.log";
    private static final String PREFIX = "This is test message number ";
    private static final String ROLLED = "onStartup-";
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM-dd-yyyy");
    private static LoggerContext loggerContext;

    @BeforeClass
    public static void beforeClass() throws Exception {
        if (Files.exists(Paths.get(DIR, new String[0]), new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(DIR, new String[0]));){
                for (Path path : directoryStream) {
                    Files.delete(path);
                }
                Files.delete(Paths.get(DIR, new String[0]));
            }
        }
        Files.createDirectory(new File(DIR).toPath(), new FileAttribute[0]);
        String fileName = ROLLED + formatter.format(LocalDate.now()) + "-1.log";
        Path target = Paths.get(DIR, fileName);
        Files.copy(Paths.get(SOURCE, FILENAME), target, StandardCopyOption.COPY_ATTRIBUTES);
        FileTime newTime = FileTime.from(Instant.now().minus(1L, ChronoUnit.DAYS));
        Files.getFileAttributeView(target, BasicFileAttributeView.class, new LinkOption[0]).setTimes(newTime, newTime, newTime);
    }

    @Test
    public void performTest() throws Exception {
        loggerContext = Configurator.initialize((String)"Test", (String)CONFIG);
        ExtendedLogger logger = loggerContext.getLogger(RollingAppenderOnStartupDirectTest.class);
        for (int i = 3; i < 10; ++i) {
            logger.debug(PREFIX + i);
        }
        int fileCount = 0;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(DIR, new String[0]));){
            for (Path path : directoryStream) {
                ++fileCount;
                if (!path.toFile().getName().startsWith(ROLLED)) continue;
                List<String> lines = Files.readAllLines(path);
                Assert.assertTrue((String)("No messages in " + path.toFile().getName()), (lines.size() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Missing message for " + path.toFile().getName()), (boolean)lines.get(0).startsWith(PREFIX));
            }
        }
        Assert.assertEquals((String)"File did not roll", (long)2L, (long)fileCount);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        Configurator.shutdown((LoggerContext)loggerContext);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(DIR, new String[0]));){
            for (Path path : directoryStream) {
                Files.delete(path);
            }
        }
        Files.delete(Paths.get(DIR, new String[0]));
    }
}

