/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.file.PathUtils;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.RuleChain;

public class RollingAppenderRestartTest {
    private static final String CONFIG = "log4j-rolling-restart.xml";
    private static final Path DIR = Paths.get("target/rolling-restart", new String[0]);
    private static final Path FILE = DIR.resolve("test.log");
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-restart.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule(false, true, 5, DIR.toAbsolutePath().toString());

    @BeforeClass
    public static void setup() throws Exception {
        RollingAppenderRestartTest.tearDown();
        Files.createDirectories(DIR, new FileAttribute[0]);
        Files.write(FILE, "Hello, world".getBytes(), StandardOpenOption.CREATE);
        FileTime newTime = FileTime.from(Instant.now().minus(2L, ChronoUnit.DAYS));
        Files.getFileAttributeView(FILE, BasicFileAttributeView.class, new LinkOption[0]).setTimes(newTime, newTime, newTime);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (Files.exists(DIR, new LinkOption[0])) {
            PathUtils.deleteDirectory((Path)DIR);
        }
    }

    @Test
    public void testAppender() throws Exception {
        Logger logger = this.loggerContextRule.getLogger();
        logger.info("This is test message number 1");
        Thread.yield();
        String name = "RollingFile";
        RollingFileAppender appender = (RollingFileAppender)this.loggerContextRule.getAppender("RollingFile");
        Assertions.assertNotNull((Object)appender, (String)"RollingFile");
        if (((RollingFileManager)appender.getManager()).getSemaphore().tryAcquire(5L, TimeUnit.SECONDS)) {
            this.validate();
        } else {
            Assertions.fail((String)"Rolling over is taking too long.");
        }
    }

    private void validate() {
        Matcher hasGzippedFile = Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".gz")))));
        Object[] files = DIR.toFile().listFiles();
        Arrays.sort(files);
        Assertions.assertTrue((boolean)hasGzippedFile.matches((Object)files), () -> RollingAppenderRestartTest.lambda$validate$0((File[])files));
    }

    private static /* synthetic */ String lambda$validate$0(File[] files) {
        return "was expecting files with '.gz' suffix, found: " + Arrays.toString(files);
    }
}

