/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.core.appender.rolling.action.PathSortByModificationTime;
import org.apache.logging.log4j.core.appender.rolling.action.PathSorter;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.SortingVisitor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SortingVisitorTest {
    @TempDir
    Path base;
    private Path aaa;
    private Path bbb;
    private Path ccc;

    @BeforeEach
    public void setUp() throws Exception {
        this.aaa = Files.createFile(this.base.resolve("aaa"), new FileAttribute[0]);
        this.bbb = Files.createFile(this.base.resolve("bbb"), new FileAttribute[0]);
        this.ccc = Files.createFile(this.base.resolve("ccc"), new FileAttribute[0]);
        long now = System.currentTimeMillis();
        Files.setLastModifiedTime(this.aaa, FileTime.fromMillis(now));
        Files.setLastModifiedTime(this.bbb, FileTime.fromMillis(now + 1000L));
        Files.setLastModifiedTime(this.ccc, FileTime.fromMillis(now + 2000L));
    }

    @Test
    public void testRecentFirst() throws Exception {
        SortingVisitor visitor = new SortingVisitor((PathSorter)new PathSortByModificationTime(true));
        Set<FileVisitOption> options = Collections.emptySet();
        Files.walkFileTree(this.base, options, 1, (FileVisitor<? super Path>)visitor);
        List found = visitor.getSortedPaths();
        Assertions.assertNotNull((Object)found);
        Assertions.assertEquals((int)3, (int)found.size(), (String)"file count");
        Assertions.assertEquals((Object)this.ccc, (Object)((PathWithAttributes)found.get(0)).getPath(), (String)("1st: most recent; sorted=" + found));
        Assertions.assertEquals((Object)this.bbb, (Object)((PathWithAttributes)found.get(1)).getPath(), (String)("2nd; sorted=" + found));
        Assertions.assertEquals((Object)this.aaa, (Object)((PathWithAttributes)found.get(2)).getPath(), (String)("3rd: oldest; sorted=" + found));
    }

    @Test
    public void testRecentLast() throws Exception {
        SortingVisitor visitor = new SortingVisitor((PathSorter)new PathSortByModificationTime(false));
        Set<FileVisitOption> options = Collections.emptySet();
        Files.walkFileTree(this.base, options, 1, (FileVisitor<? super Path>)visitor);
        List found = visitor.getSortedPaths();
        Assertions.assertNotNull((Object)found);
        Assertions.assertEquals((int)3, (int)found.size(), (String)"file count");
        Assertions.assertEquals((Object)this.aaa, (Object)((PathWithAttributes)found.get(0)).getPath(), (String)("1st: oldest first; sorted=" + found));
        Assertions.assertEquals((Object)this.bbb, (Object)((PathWithAttributes)found.get(1)).getPath(), (String)("2nd; sorted=" + found));
        Assertions.assertEquals((Object)this.ccc, (Object)((PathWithAttributes)found.get(2)).getPath(), (String)("3rd: most recent sorted; list=" + found));
    }

    @Test
    public void testNoSuchFileFailure() throws IOException {
        SortingVisitor visitor = new SortingVisitor((PathSorter)new PathSortByModificationTime(false));
        Assertions.assertSame((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)visitor.visitFileFailed(Paths.get("doesNotExist", new String[0]), (IOException)new NoSuchFileException("doesNotExist"))));
    }

    @Test
    public void testIOException() {
        SortingVisitor visitor = new SortingVisitor((PathSorter)new PathSortByModificationTime(false));
        IOException exception = new IOException();
        Assertions.assertSame((Object)exception, (Object)Assertions.assertThrows(IOException.class, () -> visitor.visitFileFailed(Paths.get("doesNotExist", new String[0]), exception)));
    }
}

