/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RoutingAppender2767Test {
    private static final String CONFIG = "log4j-routing-2767.xml";
    private static final String ACTIVITY_LOG_FILE = "target/routing1/routingtest-Service.log";
    private final LoggerContextRule loggerContextRule = new LoggerContextRule("log4j-routing-2767.xml");
    @Rule
    public RuleChain rules = this.loggerContextRule.withCleanFilesRule("target/routing1/routingtest-Service.log");

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        this.loggerContextRule.getLoggerContext().stop();
    }

    @Test
    public void routingTest() throws Exception {
        StructuredDataMessage msg = new StructuredDataMessage("Test", "This is a test", "Service");
        EventLogger.logEvent((StructuredDataMessage)msg);
        File file = new File(ACTIVITY_LOG_FILE);
        Assert.assertTrue((String)"Activity file was not created", (boolean)file.exists());
        List lines = Files.lines(file.toPath()).collect(Collectors.toList());
        Assert.assertEquals((String)"Incorrect number of lines", (long)1L, (long)lines.size());
        Assert.assertTrue((String)"Incorrect content", (boolean)((String)lines.get(0)).contains("This is a test"));
    }
}

