/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async.perftest;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.core.async.perftest.Histogram;
import org.apache.logging.log4j.core.async.perftest.IPerfTestRunner;
import org.apache.logging.log4j.core.async.perftest.ResponseTimeTest;

public abstract class AbstractRunQueue
implements IPerfTestRunner {
    private static final String STOP = "STOP_TEST";
    private volatile boolean stopped = false;
    private final BlockingQueue<String> queue = this.createQueue(262144);
    private final Thread backGroundThread = new Thread(() -> {
        try {
            while (!Objects.equals(this.queue.take(), STOP)) {
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    });

    abstract BlockingQueue<String> createQueue(int var1);

    AbstractRunQueue() {
        this.backGroundThread.start();
    }

    @Override
    public void runThroughputTest(int lines, Histogram histogram) {
    }

    @Override
    public void runLatencyTest(int samples, Histogram histogram, long nanoTimeCost, int threadCount) {
    }

    @Override
    public final void shutdown() {
        this.stopped = true;
        try {
            this.queue.put(STOP);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void log(String finalMessage) {
        if (this.stopped) {
            return;
        }
        if (!this.queue.offer(finalMessage)) {
            ResponseTimeTest.PrintingAsyncQueueFullPolicy.ringbufferFull.incrementAndGet();
            try {
                this.queue.put(finalMessage);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

