/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import java.util.Map;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.InMemoryAdvertiser;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class AdvertiserTest {
    private static final String CONFIG = "log4j-advertiser.xml";
    private static final String STATUS_LOG = "target/status.log";

    @BeforeAll
    public static void setupClass() {
        File file = new File(STATUS_LOG);
        file.delete();
        System.setProperty("log4j.configurationFile", CONFIG);
        LoggerContext ctx = LoggerContext.getContext();
        Configuration config = ctx.getConfiguration();
        if (config instanceof XmlConfiguration) {
            String name = config.getName();
            if (name == null || !name.equals("XMLConfigTest")) {
                ctx.reconfigure();
            }
        } else {
            ctx.reconfigure();
        }
    }

    @AfterAll
    public static void cleanupClass() {
        System.clearProperty("log4j.configurationFile");
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
        StatusLogger.getLogger().reset();
        File file = new File(STATUS_LOG);
        file.delete();
    }

    private void verifyExpectedEntriesAdvertised(Map<Object, Map<String, String>> entries) {
        boolean foundFile1 = false;
        boolean foundFile2 = false;
        boolean foundSocket1 = false;
        boolean foundSocket2 = false;
        for (Map<String, String> entry : entries.values()) {
            if (foundFile1 && foundFile2 && foundSocket1 && foundSocket2) break;
            if (entry.get("name").equals("File1")) {
                foundFile1 = true;
            }
            if (entry.get("name").equals("File2")) {
                foundFile2 = true;
            }
            if (entry.get("name").equals("Socket1")) {
                foundSocket1 = true;
            }
            if (!entry.get("name").equals("Socket2")) continue;
            foundSocket2 = true;
        }
        Assertions.assertTrue((boolean)foundFile1, (String)"Entries for File1 appender do not exist");
        Assertions.assertFalse((boolean)foundFile2, (String)"Entries for File2 appender exist");
        Assertions.assertTrue((boolean)foundSocket1, (String)"Entries for Socket1 appender do not exist");
        Assertions.assertFalse((boolean)foundSocket2, (String)"Entries for Socket2 appender exist");
    }

    @Test
    public void testAdvertisementsFound() {
        this.verifyExpectedEntriesAdvertised(InMemoryAdvertiser.getAdvertisedEntries());
    }

    @Test
    public void testAdvertisementsRemovedOnConfigStop() {
        this.verifyExpectedEntriesAdvertised(InMemoryAdvertiser.getAdvertisedEntries());
        LoggerContext ctx = LoggerContext.getContext();
        ctx.stop();
        Map<Object, Map<String, String>> entries = InMemoryAdvertiser.getAdvertisedEntries();
        Assertions.assertTrue((boolean)entries.isEmpty(), (String)("Entries found: " + entries));
        ctx.start();
    }

    @Test
    public void testAdvertisementsAddedOnReconfigAfterStop() {
        this.verifyExpectedEntriesAdvertised(InMemoryAdvertiser.getAdvertisedEntries());
        LoggerContext ctx = LoggerContext.getContext();
        ctx.stop();
        Map<Object, Map<String, String>> entries = InMemoryAdvertiser.getAdvertisedEntries();
        Assertions.assertTrue((boolean)entries.isEmpty(), (String)("Entries found: " + entries));
        ctx.start();
        this.verifyExpectedEntriesAdvertised(InMemoryAdvertiser.getAdvertisedEntries());
    }
}

