/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.List;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.junit.UsingThreadContextMap;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@UsingThreadContextMap
@Tag(value="groovy")
public abstract class AbstractScriptFilterTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroovyFilter(LoggerContext context, @Named(value="List") ListAppender app) throws Exception {
        Logger logger = context.getLogger("TestGroovyFilter");
        logger.traceEntry();
        logger.info("This should not be logged");
        ThreadContext.put((String)"UserId", (String)"JohnDoe");
        logger.info("This should be logged");
        ThreadContext.clearMap();
        try {
            List<String> messages = app.getMessages();
            Assertions.assertNotNull(messages, (String)"No Messages");
            Assertions.assertEquals((int)messages.size(), (int)2, (String)("Incorrect number of messages. Expected 2, Actual " + messages.size()));
        }
        finally {
            app.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavascriptFilter(LoggerContext context, @Named(value="List") ListAppender app) throws Exception {
        Logger logger = context.getLogger("TestJavaScriptFilter");
        logger.traceEntry();
        logger.info("This should not be logged");
        ThreadContext.put((String)"UserId", (String)"JohnDoe");
        logger.info("This should be logged");
        ThreadContext.clearMap();
        List<String> messages = app.getMessages();
        try {
            Assertions.assertNotNull(messages, (String)"No Messages");
            Assertions.assertEquals((int)messages.size(), (int)2, (String)("Incorrect number of messages. Expected 2, Actual " + messages.size()));
        }
        finally {
            app.clear();
        }
    }
}

