/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadContextMapFilterTest {
    @Test
    public void testFilter() {
        ThreadContext.put((String)"userid", (String)"testuser");
        ThreadContext.put((String)"organization", (String)"Apache");
        KeyValuePair[] pairs = new KeyValuePair[]{new KeyValuePair("userid", "JohnDoe"), new KeyValuePair("organization", "Apache")};
        ThreadContextMapFilter filter = ThreadContextMapFilter.createFilter((KeyValuePair[])pairs, (String)"and", null, null);
        Assertions.assertNotNull((Object)filter);
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.remove((String)"userid");
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.put((String)"userid", (String)"JohnDoe");
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, null, (Throwable)null));
        ThreadContext.put((String)"organization", (String)"ASF");
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.clearMap();
        filter = ThreadContextMapFilter.createFilter((KeyValuePair[])pairs, (String)"or", null, null);
        Assertions.assertNotNull((Object)filter);
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        ThreadContext.put((String)"userid", (String)"testuser");
        ThreadContext.put((String)"organization", (String)"Apache");
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.put((String)"organization", (String)"ASF");
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.remove((String)"organization");
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        KeyValuePair[] single = new KeyValuePair[]{new KeyValuePair("userid", "testuser")};
        filter = ThreadContextMapFilter.createFilter((KeyValuePair[])single, null, null, null);
        Assertions.assertNotNull((Object)filter);
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.clearMap();
    }
}

