/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class ConcurrentLoggingWithJsonLayoutTest {
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j2-json-layout.xml");
    private static final String PATH = "target/test-json-layout.log";

    @AfterClass
    public static void after() {
        new File(PATH).delete();
    }

    @Test
    public void testConcurrentLogging() throws Throwable {
        org.apache.logging.log4j.core.Logger log = context.getLogger(ConcurrentLoggingWithJsonLayoutTest.class);
        Set<Thread> threads = Collections.synchronizedSet(new HashSet());
        List thrown = Collections.synchronizedList(new ArrayList());
        for (int x = 0; x < Runtime.getRuntime().availableProcessors() * 2; ++x) {
            LoggingThread t = new LoggingThread(threads, (Logger)log);
            threads.add(t);
            t.setUncaughtExceptionHandler((t1, e) -> thrown.add(e));
            t.start();
        }
        while (!threads.isEmpty()) {
            log.info("not done going to sleep...");
            Thread.sleep(10L);
        }
        if (!thrown.isEmpty()) {
            throw (Throwable)thrown.get(0);
        }
        if (new File(PATH).exists()) {
            List<String> lines = Files.readAllLines(new File(PATH).toPath(), Charset.defaultCharset());
            for (String line : lines) {
                Assert.assertThat((Object)line, (Matcher)CoreMatchers.containsString((String)"\"thread\":"));
                Assert.assertThat((Object)line, (Matcher)CoreMatchers.endsWith((String)"\"threadPriority\":5}"));
            }
        }
    }

    private class LoggingThread
    extends Thread {
        private final Set<Thread> threads;
        private final Logger log;

        LoggingThread(Set<Thread> threads, Logger log) {
            this.threads = threads;
            this.log = log;
        }

        @Override
        public void run() {
            this.log.info((Object)this.threads.size());
            try {
                for (int i = 0; i < 64; ++i) {
                    this.log.info("First message.");
                    this.log.info("Second message.");
                }
            }
            finally {
                this.threads.remove(this);
            }
        }
    }
}

