/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.SpyByteBufferDestination;
import org.apache.logging.log4j.core.layout.StringBuilderEncoder;
import org.apache.logging.log4j.core.layout.TextEncoderHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringBuilderEncoderTest {
    @Test
    public void testEncodeText_TextFitCharBuff_BytesFitByteBuff() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 16, 8192);
        StringBuilder text = this.createText(15);
        SpyByteBufferDestination destination = new SpyByteBufferDestination(17, 17);
        helper.encode(text, (ByteBufferDestination)destination);
        Assertions.assertEquals((int)0, (int)destination.drainPoints.size(), (String)"drained");
        Assertions.assertEquals((int)text.length(), (int)destination.buffer.position(), (String)"destination.buf.pos");
        for (int i = 0; i < text.length(); ++i) {
            Assertions.assertEquals((byte)((byte)text.charAt(i)), (byte)destination.buffer.get(i), (String)("char at " + i));
        }
    }

    @Test
    public void testEncodeText_TextFitCharBuff_BytesDontFitByteBuff() throws Exception {
        int i;
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 16, 8192);
        StringBuilder text = this.createText(15);
        SpyByteBufferDestination destination = new SpyByteBufferDestination(14, 15);
        helper.encode(text, (ByteBufferDestination)destination);
        Assertions.assertEquals((int)1, (int)destination.drainPoints.size(), (String)"drained");
        Assertions.assertEquals((int)0, (int)destination.drainPoints.get((int)0).position, (String)"drained[0].from");
        Assertions.assertEquals((int)destination.buffer.capacity(), (int)destination.drainPoints.get((int)0).limit, (String)"drained[0].to");
        Assertions.assertEquals((int)destination.buffer.capacity(), (int)destination.drainPoints.get(0).length(), (String)"drained[0].length");
        Assertions.assertEquals((int)(text.length() - destination.buffer.capacity()), (int)destination.buffer.position(), (String)"destination.buf.pos");
        for (i = 0; i < destination.buffer.capacity(); ++i) {
            Assertions.assertEquals((byte)((byte)text.charAt(i)), (byte)destination.drained.get(i), (String)("char at " + i));
        }
        for (i = destination.buffer.capacity(); i < text.length(); ++i) {
            int bufIx = i - destination.buffer.capacity();
            Assertions.assertEquals((byte)((byte)text.charAt(i)), (byte)destination.buffer.get(bufIx), (String)("char at " + i));
        }
    }

    @Test
    public void testEncodeText_TextFitCharBuff_BytesDontFitByteBuff_MultiplePasses() throws Exception {
        int i;
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 16, 8192);
        StringBuilder text = this.createText(15);
        SpyByteBufferDestination destination = new SpyByteBufferDestination(4, 20);
        helper.encode(text, (ByteBufferDestination)destination);
        Assertions.assertEquals((int)3, (int)destination.drainPoints.size(), (String)"drained");
        Assertions.assertEquals((int)0, (int)destination.drainPoints.get((int)0).position, (String)"drained[0].from");
        Assertions.assertEquals((int)destination.buffer.capacity(), (int)destination.drainPoints.get((int)0).limit, (String)"drained[0].to");
        Assertions.assertEquals((int)destination.buffer.capacity(), (int)destination.drainPoints.get(0).length(), (String)"drained[0].length");
        Assertions.assertEquals((int)0, (int)destination.drainPoints.get((int)1).position, (String)"drained[1].from");
        Assertions.assertEquals((int)destination.buffer.capacity(), (int)destination.drainPoints.get((int)1).limit, (String)"drained[1].to");
        Assertions.assertEquals((int)destination.buffer.capacity(), (int)destination.drainPoints.get(1).length(), (String)"drained[1].length");
        Assertions.assertEquals((int)0, (int)destination.drainPoints.get((int)2).position, (String)"drained[2].from");
        Assertions.assertEquals((int)destination.buffer.capacity(), (int)destination.drainPoints.get((int)2).limit, (String)"drained[2].to");
        Assertions.assertEquals((int)destination.buffer.capacity(), (int)destination.drainPoints.get(2).length(), (String)"drained[2].length");
        Assertions.assertEquals((int)(text.length() - 3 * destination.buffer.capacity()), (int)destination.buffer.position(), (String)"destination.buf.pos");
        for (i = 0; i < 3 * destination.buffer.capacity(); ++i) {
            Assertions.assertEquals((byte)((byte)text.charAt(i)), (byte)destination.drained.get(i), (String)("char at " + i));
        }
        for (i = 3 * destination.buffer.capacity(); i < text.length(); ++i) {
            int bufIx = i - 3 * destination.buffer.capacity();
            Assertions.assertEquals((byte)((byte)text.charAt(i)), (byte)destination.buffer.get(bufIx), (String)("char at " + i));
        }
    }

    @Test
    public void testEncodeText_TextDoesntFitCharBuff_BytesFitByteBuff() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 4, 8192);
        StringBuilder text = this.createText(15);
        SpyByteBufferDestination destination = new SpyByteBufferDestination(17, 17);
        helper.encode(text, (ByteBufferDestination)destination);
        Assertions.assertEquals((int)0, (int)destination.drainPoints.size(), (String)"drained");
        Assertions.assertEquals((int)text.length(), (int)destination.buffer.position(), (String)"destination.buf.pos");
        for (int i = 0; i < text.length(); ++i) {
            Assertions.assertEquals((byte)((byte)text.charAt(i)), (byte)destination.buffer.get(i), (String)("char at " + i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextUtf8DoesntFitCharBuff_BytesFitByteBuff() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 4, 8192);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(50, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        Assertions.assertEquals((int)0, (int)destination.drainPoints.size(), (String)"drained");
        destination.drain(destination.getByteBuffer());
        byte[] utf8 = text.toString().getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < utf8.length; ++i) {
            Assertions.assertEquals((byte)utf8[i], (byte)destination.drained.get(i), (String)("byte at " + i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextShiftJisDoesntFitCharBuff_BytesFitByteBuff() throws Exception {
        Charset SHIFT_JIS = Charset.forName("Shift_JIS");
        StringBuilderEncoder helper = new StringBuilderEncoder(SHIFT_JIS, 4, 8192);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(50, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        Assertions.assertEquals((int)0, (int)destination.drainPoints.size(), (String)"drained");
        destination.drain(destination.getByteBuffer());
        byte[] bytes = text.toString().getBytes(SHIFT_JIS);
        for (int i = 0; i < bytes.length; ++i) {
            Assertions.assertEquals((byte)bytes[i], (byte)destination.drained.get(i), (String)("byte at " + i));
        }
    }

    @Test
    public void testEncodeText_TextDoesntFitCharBuff_BytesDontFitByteBuff() throws Exception {
        int i;
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 4, 8192);
        StringBuilder text = this.createText(15);
        SpyByteBufferDestination destination = new SpyByteBufferDestination(3, 17);
        helper.encode(text, (ByteBufferDestination)destination);
        Assertions.assertEquals((int)4, (int)destination.drainPoints.size(), (String)"drained");
        Assertions.assertEquals((int)3, (int)destination.buffer.position(), (String)"destination.buf.pos");
        for (i = 0; i < text.length() - 3; ++i) {
            Assertions.assertEquals((byte)((byte)text.charAt(i)), (byte)destination.drained.get(i), (String)("char at " + i));
        }
        for (i = 0; i < 3; ++i) {
            Assertions.assertEquals((byte)((byte)text.charAt(12 + i)), (byte)destination.buffer.get(i), (String)("char at " + (12 + i)));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextUtf8DoesntFitCharBuff_BytesDontFitByteBuff() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 4, 8192);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(3, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        Assertions.assertEquals((int)7, (int)destination.drainPoints.size(), (String)"drained");
        destination.drain(destination.getByteBuffer());
        byte[] utf8 = text.toString().getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < utf8.length; ++i) {
            Assertions.assertEquals((byte)utf8[i], (byte)destination.drained.get(i), (String)("byte at " + i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextUtf8DoesntFitCharBuff_DoesntFitTempByteBuff_BytesDontFitDestinationByteBuff() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 4, 5);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(3, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        Assertions.assertEquals((int)15, (int)destination.drainPoints.size(), (String)"drained");
        destination.drain(destination.getByteBuffer());
        byte[] utf8 = text.toString().getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < utf8.length; ++i) {
            Assertions.assertEquals((byte)utf8[i], (byte)destination.drained.get(i), (String)("byte at " + i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextShiftJisDoesntFitCharBuff_BytesDontFitByteBuff() throws Exception {
        Charset SHIFT_JIS = Charset.forName("Shift_JIS");
        StringBuilderEncoder helper = new StringBuilderEncoder(SHIFT_JIS, 4, 8192);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(3, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        destination.drain(destination.getByteBuffer());
        byte[] bytes = text.toString().getBytes(SHIFT_JIS);
        for (int i = 0; i < bytes.length; ++i) {
            Assertions.assertEquals((byte)bytes[i], (byte)destination.drained.get(i), (String)("byte at " + i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextShiftJisDoesntFitCharBuff_DoesntFitTempByteBuff_BytesDontFitDestinationByteBuff() throws Exception {
        Charset SHIFT_JIS = Charset.forName("Shift_JIS");
        StringBuilderEncoder helper = new StringBuilderEncoder(SHIFT_JIS, 4, 5);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(3, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        destination.drain(destination.getByteBuffer());
        byte[] bytes = text.toString().getBytes(SHIFT_JIS);
        for (int i = 0; i < bytes.length; ++i) {
            Assertions.assertEquals((byte)bytes[i], (byte)destination.drained.get(i), (String)("byte at " + i));
        }
    }

    @Test
    public void testCopyCopiesAllDataIfSuffientRemainingSpace() throws Exception {
        CharBuffer buff = CharBuffer.wrap(new char[16]);
        StringBuilder text = this.createText(15);
        int length = TextEncoderHelper.copy((StringBuilder)text, (int)0, (CharBuffer)buff);
        Assertions.assertEquals((int)text.length(), (int)length, (String)"everything fits");
        for (int i = 0; i < length; ++i) {
            Assertions.assertEquals((char)text.charAt(i), (char)buff.get(i), (String)("char at " + i));
        }
        Assertions.assertEquals((int)text.length(), (int)buff.position(), (String)"position moved by length");
    }

    @Test
    public void testCopyUpToRemainingSpace() throws Exception {
        CharBuffer buff = CharBuffer.wrap(new char[3]);
        StringBuilder text = this.createText(15);
        int length = TextEncoderHelper.copy((StringBuilder)text, (int)0, (CharBuffer)buff);
        Assertions.assertEquals((int)buff.capacity(), (int)length, (String)"partial copy");
        for (int i = 0; i < length; ++i) {
            Assertions.assertEquals((char)text.charAt(i), (char)buff.get(i), (String)("char at " + i));
        }
        Assertions.assertEquals((int)0, (int)buff.remaining(), (String)"no space remaining");
        Assertions.assertEquals((int)buff.capacity(), (int)buff.position(), (String)"position at end");
    }

    @Test
    public void testCopyDoesNotWriteBeyondStringText() throws Exception {
        int i;
        CharBuffer buff = CharBuffer.wrap(new char[5]);
        Assertions.assertEquals((int)0, (int)buff.position(), (String)"initial buffer position");
        StringBuilder text = this.createText(2);
        int length = TextEncoderHelper.copy((StringBuilder)text, (int)0, (CharBuffer)buff);
        Assertions.assertEquals((int)text.length(), (int)length, (String)"full copy");
        for (i = 0; i < length; ++i) {
            Assertions.assertEquals((char)text.charAt(i), (char)buff.get(i), (String)("char at " + i));
        }
        Assertions.assertEquals((int)text.length(), (int)buff.position(), (String)"resulting buffer position");
        for (i = length; i < buff.capacity(); ++i) {
            Assertions.assertEquals((int)0, (int)buff.get(i), (String)("unset char at " + i));
        }
    }

    @Test
    public void testCopyStartsAtBufferPosition() throws Exception {
        CharBuffer buff = CharBuffer.wrap(new char[10]);
        int START_POSITION = 5;
        buff.position(5);
        StringBuilder text = this.createText(15);
        int length = TextEncoderHelper.copy((StringBuilder)text, (int)0, (CharBuffer)buff);
        Assertions.assertEquals((int)(buff.capacity() - 5), (int)length, (String)"partial copy");
        for (int i = 0; i < length; ++i) {
            Assertions.assertEquals((char)text.charAt(i), (char)buff.get(5 + i), (String)("char at " + i));
        }
        Assertions.assertEquals((int)buff.capacity(), (int)buff.position(), (String)"buffer position at end");
    }

    @Test
    public void testEncode_ALotWithoutErrors() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(Charset.defaultCharset());
        StringBuilder text = new StringBuilder("2016-04-13 21:07:47,487 DEBUG [org.apache.logging.log4j.perf.jmh.FileAppenderBenchmark.log4j2ParameterizedString-jmh-worker-1] FileAppenderBenchmark  - This is a debug [2383178] message\r\n");
        int DESTINATION_SIZE = 0x100000;
        SpyByteBufferDestination destination = new SpyByteBufferDestination(262144, 0x100000);
        int max = 0x100000 / text.length();
        for (int i = 0; i < max; ++i) {
            helper.encode(text, (ByteBufferDestination)destination);
        }
    }

    private StringBuilder createText(int length) {
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            result.append((char)(32 + i));
        }
        return result;
    }
}

