/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.layout.SyslogLayout;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.junit.UsingAnyThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@UsingAnyThreadContext
public class SyslogLayoutTest {
    LoggerContext ctx = LoggerContext.getContext();
    Logger root = this.ctx.getRootLogger();
    private static final String line1 = "starting mdc pattern test";
    private static final String line2 = "empty mdc";
    private static final String line3 = "filled mdc";
    private static final String line4 = "Audit [Transfer@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"] Transfer Complete";
    static ConfigurationFactory cf = new BasicConfigurationFactory();

    @BeforeAll
    public static void setupClass() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)cf);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    @AfterAll
    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)cf);
    }

    @Test
    public void testLayout() throws Exception {
        Object appender2;
        for (Object appender2 : this.root.getAppenders().values()) {
            this.root.removeAppender((Appender)appender2);
        }
        SyslogLayout layout = SyslogLayout.newBuilder().setFacility(Facility.LOCAL0).setIncludeNewLine(true).build();
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender2.start();
        this.root.addAppender((Appender)appender2);
        this.root.setLevel(Level.DEBUG);
        this.root.debug(line1);
        this.root.debug(line2);
        ThreadContext.put((String)"key1", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        this.root.debug(line3);
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        StructuredDataMessage msg = new StructuredDataMessage("Transfer@18060", "Transfer Complete", "Audit");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        this.root.info(MarkerManager.getMarker((String)"EVENT"), (Message)msg);
        appender2.stop();
        List<String> list = ((ListAppender)((Object)appender2)).getMessages();
        Assertions.assertTrue((boolean)list.get(0).endsWith(line1), (String)("Expected line 1 to end with: starting mdc pattern test Actual " + list.get(0)));
        Assertions.assertTrue((boolean)list.get(1).endsWith(line2), (String)("Expected line 2 to end with: empty mdc Actual " + list.get(1)));
        Assertions.assertTrue((boolean)list.get(2).endsWith(line3), (String)("Expected line 3 to end with: filled mdc Actual " + list.get(2)));
        Assertions.assertTrue((boolean)list.get(3).endsWith(line4), (String)("Expected line 4 to end with: Audit [Transfer@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"] Transfer Complete Actual " + list.get(3)));
    }
}

