/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-marker-lookup.yaml")
@Tag(value="yaml")
public class MarkerLookupConfigTest {
    public static final Marker PAYLOAD = MarkerManager.getMarker((String)"PAYLOAD");
    private static final String PAYLOAD_LOG = "Message in payload.log";
    public static final Marker PERFORMANCE = MarkerManager.getMarker((String)"PERFORMANCE");
    private static final String PERFORMANCE_LOG = "Message in performance.log";
    public static final Marker SQL = MarkerManager.getMarker((String)"SQL");
    private static final String SQL_LOG = "Message in sql.log";

    @Test
    public void test() throws IOException {
        Logger logger = LogManager.getLogger();
        logger.info(SQL, SQL_LOG);
        logger.info(PAYLOAD, PAYLOAD_LOG);
        logger.info(PERFORMANCE, PERFORMANCE_LOG);
        String log = FileUtils.readFileToString((File)new File("target/logs/sql.log"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)log.contains(SQL_LOG));
        Assertions.assertFalse((boolean)log.contains(PAYLOAD_LOG));
        Assertions.assertFalse((boolean)log.contains(PERFORMANCE_LOG));
        log = FileUtils.readFileToString((File)new File("target/logs/payload.log"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertFalse((boolean)log.contains(SQL_LOG));
        Assertions.assertTrue((boolean)log.contains(PAYLOAD_LOG));
        Assertions.assertFalse((boolean)log.contains(PERFORMANCE_LOG));
        log = FileUtils.readFileToString((File)new File("target/logs/performance.log"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertFalse((boolean)log.contains(SQL_LOG));
        Assertions.assertFalse((boolean)log.contains(PAYLOAD_LOG));
        Assertions.assertTrue((boolean)log.contains(PERFORMANCE_LOG));
    }
}

