/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.mock;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.logging.log4j.core.net.mock.MockSyslogServer;

public class MockTcpSyslogServer
extends MockSyslogServer {
    private final ServerSocket socketServer;
    private volatile boolean shutdown = false;
    private Thread thread;

    public MockTcpSyslogServer(int numberOfMessagesToReceive, int port) throws IOException {
        super(numberOfMessagesToReceive, port);
        this.socketServer = new ServerSocket(port);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        if (this.socketServer != null) {
            try {
                this.socketServer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException ie) {
                System.out.println("Shutdown of TCP server thread failed.");
            }
        }
    }

    @Override
    public void run() {
        System.out.println("TCP Server started");
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            try {
                byte[] buffer = new byte[4096];
                try {
                    Socket socket = this.socketServer.accept();
                    Throwable throwable = null;
                    try {
                        socket.setSoLinger(true, 0);
                        InputStream in = socket.getInputStream();
                        int i = in.read(buffer, 0, buffer.length);
                        while (i != -1) {
                            if (i < buffer.length) {
                                String line = new String(buffer, 0, i);
                                this.messageList.add(line);
                                i = in.read(buffer, 0, buffer.length);
                                continue;
                            }
                            if (i == 0) {
                                System.out.println("No data received");
                                continue;
                            }
                            System.out.println("Message too long");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (socket == null) continue;
                        if (throwable != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        socket.close();
                    }
                }
                catch (BindException be) {
                    be.printStackTrace();
                }
            }
            catch (Exception ex) {
                if (this.shutdown) continue;
                System.out.println("Caught exception: " + ex.getMessage());
            }
        }
        System.out.println("TCP Server stopped");
    }
}

